/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.gebco;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GebcoMigrateTileToBorderTile {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String[][] gebcoFiles = new String[][]{{"gebco_2021_n0.0_s-90.0_w-180.0_e-90.0.tif", "gebco_2021_n0.0_s-90.0_w-90.0_e0.0.tif", "gebco_2021_n0.0_s-90.0_w0.0_e90.0.tif", "gebco_2021_n0.0_s-90.0_w90.0_e180.0.tif"}, {"gebco_2021_n90.0_s0.0_w-180.0_e-90.0.tif", "gebco_2021_n90.0_s0.0_w-90.0_e0.0.tif", "gebco_2021_n90.0_s0.0_w0.0_e90.0.tif", "gebco_2021_n90.0_s0.0_w90.0_e180.0.tif"}};

    public static void main(String[] args) {
        String inputFolder = "C:\\Entwicklung\\Projects\\Maprender\\data\\input\\gebco\\gebco_2021_geotiff";
        String outputFolder = "C:\\Entwicklung\\Projects\\Maprender\\data\\input\\gebco\\gebco_2021_geotiff_bordered";
        GebcoMigrateTileToBorderTile instance = new GebcoMigrateTileToBorderTile();
        instance.addBorders(inputFolder, outputFolder);
    }

    public void addBorders(String inputFolderString, String outputFolderString) {
        try {
            File outputFolder = new File(outputFolderString);
            if (!outputFolder.exists()) {
                outputFolder.mkdirs();
            }
            Path dir = Paths.get(inputFolderString, new String[0]);
            Files.walk(dir, new FileVisitOption[0]).forEach(path -> this.addBorder(inputFolderString, path.toFile(), outputFolder));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.info("Done");
    }

    public void addBorder(String inputFolder, File inputFile, File outputFolder) {
        if (inputFile.exists() && inputFile.getAbsolutePath().endsWith(".tif")) {
            this.log.info("Start working on " + inputFile.getAbsolutePath());
            String filename = inputFile.getName();
            String northString = filename.substring(12);
            northString = northString.substring(0, northString.indexOf("_"));
            double north = Double.parseDouble(northString);
            String westString = filename.substring(24);
            westString = westString.substring(0, westString.indexOf("_"));
            double west = Double.parseDouble(westString);
            int xIndex = 0;
            if (west == -90.0) {
                xIndex = 1;
            } else if (west == 0.0) {
                xIndex = 2;
            } else if (west == 90.0) {
                xIndex = 3;
            }
            int yIndex = 0;
            if (north == 0.0) {
                yIndex = 1;
            }
            try {
                int rightIndex;
                float[] pixel;
                BufferedImage bufferedImage = ImageIO.read(inputFile);
                WritableRaster oldRaster = bufferedImage.getRaster();
                PixelInterleavedSampleModel oldModel = (PixelInterleavedSampleModel)oldRaster.getSampleModel();
                PixelInterleavedSampleModel newModel = new PixelInterleavedSampleModel(oldModel.getDataType(), oldModel.getWidth() + 2, oldModel.getHeight() + 2, 1, oldModel.getScanlineStride() + 2, oldModel.getBandOffsets());
                WritableRaster newRaster = Raster.createWritableRaster(newModel, new Point(0, 0));
                BufferedImage newBufferedImage = new BufferedImage(bufferedImage.getColorModel(), newRaster, false, new Hashtable());
                for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                    for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                        pixel = new float[4];
                        newRaster.setPixel(x + 1, y + 1, oldRaster.getPixel(x, y, pixel));
                    }
                }
                int leftIndex = xIndex - 1;
                if (leftIndex < 0) {
                    leftIndex = 2;
                }
                if ((rightIndex = xIndex + 1) > 2) {
                    rightIndex = 0;
                }
                pixel = new float[4];
                if (yIndex == 0) {
                    this.log.info(" - left");
                    leftImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[yIndex][leftIndex]));
                    for (int y = 1; y < leftImage.getHeight() - 1; ++y) {
                        newRaster.setPixel(0, y, leftImage.getRaster().getPixel(leftImage.getWidth() - 1, y, pixel));
                    }
                    leftImage = null;
                    this.log.info(" - right");
                    BufferedImage rightImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[yIndex][rightIndex]));
                    for (int y = 1; y < rightImage.getHeight() - 1; ++y) {
                        newRaster.setPixel(newRaster.getWidth() - 1, y, rightImage.getRaster().getPixel(0, y, pixel));
                    }
                    rightImage = null;
                    this.log.info(" - bottom");
                    BufferedImage bottomImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[1][xIndex]));
                    for (int x = 1; x < bottomImage.getWidth() - 1; ++x) {
                        newRaster.setPixel(x, newRaster.getHeight() - 1, bottomImage.getRaster().getPixel(x, 0, pixel));
                    }
                    bottomImage = null;
                    this.log.info(" - bottomLeft");
                    BufferedImage bottomLeftImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[1][leftIndex]));
                    newRaster.setPixel(0, newRaster.getHeight() - 1, bottomLeftImage.getRaster().getPixel(bottomLeftImage.getWidth() - 1, 0, pixel));
                    bottomLeftImage = null;
                    this.log.info(" - bottomRight");
                    BufferedImage bottomRightImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[1][rightIndex]));
                    newRaster.setPixel(newRaster.getWidth() - 1, newRaster.getHeight() - 1, bottomRightImage.getRaster().getPixel(0, 0, pixel));
                    bottomRightImage = null;
                    this.log.info(" - top");
                    for (int x = 0; x < newRaster.getWidth(); ++x) {
                        newRaster.setPixel(x, 0, newRaster.getPixel(x, 1, pixel));
                    }
                } else {
                    this.log.info(" - left");
                    leftImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[yIndex][leftIndex]));
                    for (int y = 1; y < leftImage.getHeight() - 1; ++y) {
                        newRaster.setPixel(0, y, leftImage.getRaster().getPixel(leftImage.getWidth() - 1, y, pixel));
                    }
                    leftImage = null;
                    this.log.info(" - right");
                    BufferedImage rightImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[yIndex][rightIndex]));
                    for (int y = 1; y < rightImage.getHeight() - 1; ++y) {
                        newRaster.setPixel(newRaster.getWidth() - 1, y, rightImage.getRaster().getPixel(0, y, pixel));
                    }
                    rightImage = null;
                    this.log.info(" - top");
                    BufferedImage topImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[0][xIndex]));
                    for (int x = 1; x < topImage.getWidth() - 1; ++x) {
                        newRaster.setPixel(x, 0, topImage.getRaster().getPixel(x, topImage.getHeight() - 1, pixel));
                    }
                    topImage = null;
                    this.log.info(" - topLeft");
                    BufferedImage topLeftImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[0][leftIndex]));
                    newRaster.setPixel(0, 0, topLeftImage.getRaster().getPixel(topLeftImage.getWidth() - 1, topLeftImage.getHeight() - 1, pixel));
                    topLeftImage = null;
                    this.log.info(" - topRight");
                    BufferedImage topRightImage = ImageIO.read(new File(inputFolder + "\\" + gebcoFiles[0][rightIndex]));
                    newRaster.setPixel(newRaster.getWidth() - 1, 0, topRightImage.getRaster().getPixel(0, topRightImage.getHeight() - 1, pixel));
                    topRightImage = null;
                    this.log.info(" - bottom");
                    for (int x = 0; x < newRaster.getWidth(); ++x) {
                        newRaster.setPixel(x, newRaster.getHeight() - 1, newRaster.getPixel(x, newRaster.getHeight() - 2, pixel));
                    }
                }
                newBufferedImage.flush();
                File outputFile = new File(outputFolder + "\\" + filename);
                ImageIO.write((RenderedImage)newBufferedImage, "TIFF", outputFile);
                this.log.info("Saved " + outputFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.log.error("readerGebcoFilePlain: could not load tile file: " + inputFile, (Throwable)e);
            }
        }
    }
}

