/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.ftp;

import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.ConnectableResourceManager;
import de.wideportal.maprender.resources.file.FileAccessor;
import de.wideportal.maprender.resources.ftp.FtpConnector;
import de.wideportal.maprender.resources.output.IRenderOutputPersister;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpPersister
extends FileAccessor
implements IRenderOutputPersister {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public synchronized void persistTile(RenderRequest renderRequest) {
        Optional<File> optionalYFile;
        this.log.debug("persistTile: start uploading to ftp");
        ConnectableResourceManager connectableResourceManager = renderRequest.getConnectableResourceManager();
        FtpConnector ftpConnector = (FtpConnector)connectableResourceManager.getConnectableResource(FtpConnector.class);
        if (ftpConnector != null && ftpConnector.isUsable() && renderRequest.getOsmMap().getJob().getOutput().getFile() != null && renderRequest.getOsmMap().getJob().getOutput().getFtp() != null && (optionalYFile = this.getLocalFile(renderRequest)).isPresent()) {
            File yFile = optionalYFile.get();
            String ftpFolder = this.getFtpFolder(renderRequest);
            String ftpFolderAndFile = this.getFtpFolderAndFile(renderRequest);
            if (ftpFolderAndFile != null) {
                FTPClient ftpClient = ftpConnector.getClient();
                try (FileInputStream fis = new FileInputStream(yFile);){
                    this.createFtpDirectoryTree(ftpClient, ftpFolder);
                    boolean storedSuccessfully = ftpClient.storeFile(ftpFolderAndFile, (InputStream)fis);
                    if (!storedSuccessfully) {
                        this.log.error("persistTile: could not upload to ftp: " + ftpFolderAndFile + ", " + ftpClient.getReplyCode() + ", " + ftpClient.getReplyString());
                    } else {
                        this.log.debug("persistTile: uploaded to ftp: " + ftpFolderAndFile + " -> " + storedSuccessfully);
                    }
                }
                catch (Exception e) {
                    this.log.error("persistTile: an error occurred during ftp upload: ftpFile=" + ftpFolderAndFile + ", localFile=" + yFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    private Optional<File> getLocalFile(RenderRequest renderRequest) {
        String localSavedFolder = renderRequest.getOsmMap().getJob().getOutput().getFile().getFolder();
        int zoom = (int)renderRequest.getZoomInfo().getZoom();
        int xIndex = (int)renderRequest.getTileIndex().getX();
        int yIndex = (int)renderRequest.getTileIndex().getY();
        RenderConfigurationJob currentJob = renderRequest.getOsmMap().getJob();
        String configuredImageType = currentJob.getOutput().getImageType();
        String fileType = "png";
        if (configuredImageType != null) {
            fileType = configuredImageType;
        }
        Optional<File> optionalYFile = this.getFile(localSavedFolder, zoom, xIndex, yIndex, fileType, false);
        return optionalYFile;
    }

    private String getFtpFolder(RenderRequest renderRequest) {
        String ftpFolder = renderRequest.getOsmMap().getJob().getOutput().getFtp().getFolder();
        if (ftpFolder != null) {
            int zoom = (int)renderRequest.getZoomInfo().getZoom();
            int xIndex = (int)renderRequest.getTileIndex().getX();
            String ftpFolderWithoutFile = this.getFtpFolderName(ftpFolder, zoom, xIndex);
            return ftpFolderWithoutFile;
        }
        return null;
    }

    public String getFtpFolderName(String baseFolder, int zoom, int xIndex) {
        if (!((String)(baseFolder = ((String)baseFolder).replaceAll("\\\\", "/"))).endsWith("/")) {
            baseFolder = (String)baseFolder + "/";
        }
        return (String)baseFolder + zoom + "/" + xIndex;
    }

    public String getFtpFileName(String baseFolder, int zoom, int xIndex, int yIndex, String fileType) {
        if (!((String)(baseFolder = ((String)baseFolder).replaceAll("\\\\", "/"))).endsWith("/")) {
            baseFolder = (String)baseFolder + "/";
        }
        return this.getFtpFolderName((String)baseFolder, zoom, xIndex) + "/" + yIndex + "." + fileType;
    }

    private String getFtpFolderAndFile(RenderRequest renderRequest) {
        String ftpFolder = renderRequest.getOsmMap().getJob().getOutput().getFtp().getFolder();
        if (ftpFolder != null) {
            int zoom = (int)renderRequest.getZoomInfo().getZoom();
            int xIndex = (int)renderRequest.getTileIndex().getX();
            int yIndex = (int)renderRequest.getTileIndex().getY();
            RenderConfigurationJob currentJob = renderRequest.getOsmMap().getJob();
            String configuredImageType = currentJob.getOutput().getImageType();
            String fileType = "png";
            if (configuredImageType != null) {
                fileType = configuredImageType;
            }
            String ftpFolderAndFile = this.getFtpFileName(ftpFolder, zoom, xIndex, yIndex, fileType);
            return ftpFolderAndFile;
        }
        return null;
    }

    private void openFtpDirectory(FTPClient client, String directory) throws Exception {
        client.changeWorkingDirectory(directory);
    }

    private void createFtpDirectoryTree(FTPClient client, String folderString) throws Exception {
        String[] folders;
        String currentWorkingDirectory = client.printWorkingDirectory();
        if (folderString.startsWith(currentWorkingDirectory) && (folderString = folderString.substring(currentWorkingDirectory.length())).startsWith("/")) {
            folderString = folderString.substring(1);
        }
        boolean folderExists = true;
        for (String folder : folders = folderString.split("/")) {
            if (folder.isEmpty()) continue;
            if (folderExists) {
                folderExists = client.changeWorkingDirectory(folder);
            }
            if (folderExists) continue;
            if (!client.makeDirectory(folder)) {
                String message = client.getReplyString();
                String currentFolder = client.printWorkingDirectory();
                client.changeWorkingDirectory(currentWorkingDirectory);
                throw new Exception("ftpCreateDirectoryTree: could not create remote folder: " + folder + " in " + currentFolder + ". Server message: " + message);
            }
            if (client.changeWorkingDirectory(folder)) continue;
            String message = client.getReplyString();
            String currentFolder = client.printWorkingDirectory();
            client.changeWorkingDirectory(currentWorkingDirectory);
            throw new Exception("ftpCreateDirectoryTree: could not enter remote folder: " + folder + " in " + currentFolder + ". Server message: " + message);
        }
        client.changeWorkingDirectory(currentWorkingDirectory);
    }
}

