/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.fonts;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationDatasources;
import de.wideportal.maprender.config.xml.RenderConfigurationFonts;
import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.config.xml.osm.OsmFont;
import de.wideportal.maprender.config.xml.osm.OsmFontSet;
import de.wideportal.maprender.config.xml.osm.OsmMap;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontsLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderConfiguration configuration;

    public FontsLoader(RenderConfiguration renderConfiguration) {
        this.configuration = renderConfiguration;
    }

    private ArrayList<OsmFont> getFontsMentionedInConfiguration() {
        ArrayList<OsmFont> fonts = new ArrayList<OsmFont>();
        for (RenderConfigurationJob job : this.configuration.getMaprenderConfiguration().getJobs().getJobs()) {
            OsmMap osmMap = job.getOsmMap();
            for (OsmFontSet osmFontSet : osmMap.getFontSets()) {
                for (OsmFont osmFont : osmFontSet.getOsmFonts()) {
                    if (fonts.contains(osmFont)) continue;
                    fonts.add(osmFont);
                }
            }
        }
        return fonts;
    }

    public void loadFonts() {
        RenderConfigurationFonts fonts;
        this.log.info("loadFonts: start loading fonts");
        RenderConfigurationDatasources datasources = this.configuration.getMaprenderConfiguration().getDatasources();
        List<Object> fontFolders = new ArrayList();
        if (datasources != null && (fonts = datasources.getFonts()) != null) {
            fontFolders = fonts.getFolders();
        }
        ArrayList<OsmFont> fontsMentionedInConfiguration = this.getFontsMentionedInConfiguration();
        int fontCounter = 0;
        for (String fontFolder : fontFolders) {
            this.log.info("loadFonts: loading fonts in folder: " + fontFolder);
            File fontFolderFile = new File(fontFolder);
            if (fontFolderFile.exists() && fontFolderFile.isDirectory()) {
                File[] possibleFontFiles;
                for (File possibleFont : possibleFontFiles = fontFolderFile.listFiles()) {
                    if (!possibleFont.canRead() || !possibleFont.getName().toLowerCase().endsWith("ttf")) continue;
                    this.log.debug("loadFonts:     loading font file: " + possibleFont.getName());
                    try (FileInputStream in = new FileInputStream(possibleFont);){
                        Font font = Font.createFont(0, in);
                        boolean fontFound = false;
                        for (OsmFont fontMentionedInConfiguration : fontsMentionedInConfiguration) {
                            if (!font.getName().equals(fontMentionedInConfiguration.getFaceName())) continue;
                            this.configuration.getLoadedFonts().put(font.getName(), font);
                            this.log.debug("loadFonts: loaded font: Font[family=" + font.getFamily() + ", fontName=" + font.getFontName() + ", name=" + font.getName() + "]");
                            ++fontCounter;
                            fontFound = true;
                            break;
                        }
                        if (fontFound) continue;
                        this.log.debug("loadFonts:   font not included in configuration therefore skipped: Font[family=" + font.getFamily() + ", fontName=" + font.getFontName() + ", name=" + font.getName() + "]");
                    }
                    catch (FileNotFoundException e) {
                        this.log.error("loadFonts:     font file not found: " + possibleFont.getAbsolutePath(), (Throwable)e);
                    }
                    catch (FontFormatException e) {
                        this.log.error("loadFonts:     font format exception: " + possibleFont.getAbsolutePath(), (Throwable)e);
                    }
                    catch (IOException e) {
                        this.log.error("loadFonts:     Could not create font: " + possibleFont.getAbsolutePath(), (Throwable)e);
                    }
                }
                continue;
            }
            this.log.warn("loadFonts: font folder does not exist: " + fontFolder);
        }
        Map<String, Font> loadedFonts = this.configuration.getLoadedFonts();
        for (Map.Entry<String, Font> loadedFont : loadedFonts.entrySet()) {
            Font font = loadedFont.getValue();
            this.log.info("loadFonts: Font available: Font[family=" + font.getFamily() + ", fontName=" + font.getFontName() + ", name=" + font.getName() + "]");
        }
        this.log.info("loadFonts: finished loading fonts: #" + fontCounter);
    }

    public void checkForMissingFonts() {
        this.log.info("checkForMissingFonts: start checking for missing fonts");
        ArrayList<OsmFont> fontsMentionedInConfiguration = this.getFontsMentionedInConfiguration();
        int missingFontCounter = 0;
        for (OsmFont fontMentionedInConfiguration : fontsMentionedInConfiguration) {
            Font font = new Font(fontMentionedInConfiguration.getFaceName(), 0, 12);
            if (!font.getName().equals("Default") && font.getName().equalsIgnoreCase(fontMentionedInConfiguration.getFaceName())) continue;
            this.log.warn("checkForMissingFonts: could not load font: " + fontMentionedInConfiguration.getFaceName());
            ++missingFontCounter;
        }
        this.log.info("checkForMissingFonts: finished checking for missing fonts: #" + missingFontCounter);
    }
}

