/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import de.wideportal.maprender.request.RenderRequestThread;
import de.wideportal.maprender.request.RenderRequestThreadManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderRequestThreadPoolExecutor
extends ThreadPoolExecutor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderRequestThreadManager threadManager;
    private int activeThreadCount = 0;

    public RenderRequestThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public void setThreadManager(RenderRequestThreadManager threadManager) {
        this.threadManager = threadManager;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        ++this.activeThreadCount;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable thread) {
        super.afterExecute(runnable, thread);
        double zoom = 0.0;
        long duration = -1L;
        if (runnable instanceof RenderRequestThread) {
            RenderRequestThread renderRequestThread = (RenderRequestThread)runnable;
            zoom = renderRequestThread.getRenderRequest().getZoomInfo().getZoom();
            duration = renderRequestThread.getDuration();
        }
        --this.activeThreadCount;
        this.threadManager.notifiyThreadFinished(zoom, this.activeThreadCount, duration);
    }
}

