/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmLineSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmStyleAccessor;
import de.wideportal.maprender.datasource.RenderResultSetCache;
import de.wideportal.maprender.datasource.kml.KmlLineString;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import de.wideportal.maprender.datasource.osm.PostgresPolygonElement;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmLineSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderLineSymbolizer(OsmLineSymbolizerAccessor lineSymbolizer, RenderImageLayer renderLayer, PostgresPolygon latLonPolygon, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, RenderResultSetCache resultSetCache) {
        Graphics2D canvas = renderLayer.getCanvas();
        Optional<String> optionalCDataColor = lineSymbolizer.getStrokeCData();
        Color directColor = lineSymbolizer.getStroke();
        Float strokeOpacity = lineSymbolizer.getStrokeOpacity();
        Color color = this.extractColorFromCData(optionalCDataColor, directColor, resultSetCache, strokeOpacity);
        canvas.setColor(color);
        boolean useRoundedLineCap = false;
        OsmStyleAccessor style = rule.getParent().getAccessor();
        if (style.getOpacity().isPresent() || style.getBaseImageFilters().size() > 0 || style.getCompOp().isPresent()) {
            useRoundedLineCap = true;
        }
        BasicStroke baseStroke = this.getBasicStroke(lineSymbolizer, useRoundedLineCap);
        canvas.setStroke(baseStroke);
        for (PostgresPolygonElement polygonElement : latLonPolygon.getPolygonElements()) {
            Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(polygonElement.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
            xyTilePoints = lineSymbolizer.getSimplifyAlgorithmFreshlyInstanced().filter(xyTilePoints);
            int[][] xyValues = PostgresPolygonElement.getPointsAsIntArray(xyTilePoints);
            Polygon xyPolygon = new Polygon(xyValues[0], xyValues[1], xyValues[0].length);
            canvas.draw(xyPolygon);
            xyPolygon = null;
        }
    }

    public void renderLineSymbolizer(OsmLineSymbolizerAccessor lineSymbolizer, RenderImageLayer renderLayer, KmlLineString kmlLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, RenderResultSetCache resultSetCache) {
        Point[] xyTilePoints = this.convertLatLonLineStringToTilePoints(kmlLineString.getPoints(), xOffset, yOffset, zoom, tileOutputter);
        this.renderLineSymbolizer(lineSymbolizer, renderLayer, xyTilePoints, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, resultSetCache);
    }

    public void renderLineSymbolizer(OsmLineSymbolizerAccessor lineSymbolizer, RenderImageLayer renderLayer, PostgresLineString mercatorLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, RenderResultSetCache resultSetCache) {
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorLineString.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        this.renderLineSymbolizer(lineSymbolizer, renderLayer, xyTilePoints, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, resultSetCache);
    }

    public void renderLineSymbolizer(OsmLineSymbolizerAccessor lineSymbolizer, RenderImageLayer renderLayer, Point[] xyTilePoints, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, RenderResultSetCache resultSetCache) {
        Graphics2D canvas = renderLayer.getCanvas();
        Optional<String> optionalCDataColor = lineSymbolizer.getStrokeCData();
        Color directColor = lineSymbolizer.getStroke();
        Float strokeOpacity = lineSymbolizer.getStrokeOpacity();
        Color color = this.extractColorFromCData(optionalCDataColor, directColor, resultSetCache, strokeOpacity);
        canvas.setColor(color);
        boolean useRoundedLineCap = false;
        OsmStyleAccessor style = rule.getParent().getAccessor();
        if (style.getOpacity().isPresent() || style.getBaseImageFilters().size() > 0 || style.getCompOp().isPresent()) {
            useRoundedLineCap = true;
        }
        BasicStroke baseStroke = this.getBasicStroke(lineSymbolizer, useRoundedLineCap);
        canvas.setStroke(baseStroke);
        double patternLength = this.getPatternLength(baseStroke);
        double totalLineLength = 0.0;
        boolean hasDashPattern = lineSymbolizer.getStrokeDasharray().isPresent();
        xyTilePoints = lineSymbolizer.getSimplifyAlgorithmFreshlyInstanced().filter(xyTilePoints);
        if (hasDashPattern) {
            Point lastRenderedPoint = null;
            for (int i = 0; i < xyTilePoints.length; ++i) {
                Point point = xyTilePoints[i];
                if (i == 0) {
                    lastRenderedPoint = point;
                    continue;
                }
                double distanceToLastRenderedPoint = lastRenderedPoint.getDistance(point);
                if (!(distanceToLastRenderedPoint >= 1.4) && i != xyTilePoints.length - 1) continue;
                double patternShift = totalLineLength % patternLength;
                BasicStroke lineShiftStroke = this.cloneBasicStroke(baseStroke, (float)patternShift);
                canvas.setStroke(lineShiftStroke);
                canvas.drawLine((int)lastRenderedPoint.getX(), (int)lastRenderedPoint.getY(), (int)point.getX(), (int)point.getY());
                totalLineLength += lastRenderedPoint.getDistance(point);
                lastRenderedPoint = point;
            }
        } else {
            Point lastRenderedPoint = null;
            for (int i = 0; i < xyTilePoints.length; ++i) {
                Point point = xyTilePoints[i];
                if (i == 0) {
                    lastRenderedPoint = point;
                    continue;
                }
                canvas.drawLine((int)lastRenderedPoint.getX(), (int)lastRenderedPoint.getY(), (int)point.getX(), (int)point.getY());
                lastRenderedPoint = point;
            }
        }
    }

    private BasicStroke getBasicStroke(OsmLineSymbolizerAccessor lineSymbolizer, boolean useRoundedLineCap) {
        float width = lineSymbolizer.getStrokeWidth().floatValue();
        int lineCap = 1;
        String lineCapString = lineSymbolizer.getStrokeLinecap();
        if (lineCapString.equalsIgnoreCase("round")) {
            lineCap = 1;
        } else if (lineCapString.equalsIgnoreCase("square")) {
            lineCap = 2;
        } else if (lineCapString.equalsIgnoreCase("butt")) {
            lineCap = 0;
        }
        if (useRoundedLineCap) {
            lineCap = 1;
        }
        int lineJoin = 0;
        String lineJoinString = lineSymbolizer.getStrokeLinejoin();
        if (lineJoinString.equalsIgnoreCase("mitre") || lineJoinString.equalsIgnoreCase("miter")) {
            lineJoin = 0;
        } else if (lineJoinString.equalsIgnoreCase("bevel")) {
            lineJoin = 2;
        } else if (lineJoinString.equalsIgnoreCase("round")) {
            lineJoin = 1;
        }
        BasicStroke basicStroke = null;
        Optional<float[]> optionalDashPattern = lineSymbolizer.getStrokeDasharray();
        if (optionalDashPattern.isPresent()) {
            float dashOffset = lineSymbolizer.getStrokeDashoffset().floatValue();
            basicStroke = new BasicStroke(width, lineCap, lineJoin, 1.0f, optionalDashPattern.get(), dashOffset);
        } else {
            basicStroke = new BasicStroke(width, lineCap, lineJoin);
        }
        return basicStroke;
    }

    private double getPatternLength(BasicStroke basicStroke) {
        float[] patternLength = basicStroke.getDashArray();
        float totalLength = 0.0f;
        if (patternLength != null) {
            for (float length : patternLength) {
                totalLength += length;
            }
        }
        return totalLength;
    }

    private BasicStroke cloneBasicStroke(BasicStroke source, float dynamicOffset) {
        BasicStroke basicStroke = new BasicStroke(source.getLineWidth(), source.getEndCap(), source.getLineJoin(), source.getMiterLimit(), source.getDashArray(), source.getDashPhase() + dynamicOffset);
        return basicStroke;
    }
}

