/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmHeightAngleSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmHeightAngleSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderHeight(RenderRequest renderRequest, OsmHeightAngleSymbolizerAccessor heightAngleSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        BoundingBox latLonBoundingBox;
        int yTileIndex;
        int xTileIndex;
        Color color = heightAngleSymbolizer.getColor();
        float angleImpact = heightAngleSymbolizer.getAngleImpact().floatValue();
        boolean renderMockTiles = heightAngleSymbolizer.getRenderMockTiles();
        HeightTileAccessor heightTileAccessor = renderRequest.getHeightTileAccessor();
        HeightCollectorTile heightCollectorTile = heightTileAccessor.collectValues((int)zoom, xTileIndex = (int)renderRequest.getTileIndex().getX(), yTileIndex = (int)renderRequest.getTileIndex().getY(), latLonBoundingBox = renderRequest.getBoundingBoxLatLon(), renderRequest, tileOutputter.getTileSize(), renderMockTiles, 0, 0, tileOutputter);
        if (heightCollectorTile == null) {
            this.log.error("renderHeightAngle: could not render height angle because the heightCollectorTile was null");
            return;
        }
        RenderImageLayer heightLayer = renderRequest.getRenderImage().createLayer("height", tileOutputter.getTileSize());
        BufferedImage topImage = heightLayer.getImage();
        WritableRaster topRaster = topImage.getRaster();
        double yLonStepSize = heightCollectorTile.getLatLonBBox().getHeight() / (double)heightCollectorTile.getPixelTileSize();
        for (int y = 0; y < heightCollectorTile.getPixelTileSize(); ++y) {
            double currentYLon = renderRequest.getBoundingBoxLatLon().getTop() - (double)y * yLonStepSize;
            float meterPerPixel = (float)tileOutputter.getMeterPerPixel(zoom, currentYLon);
            for (int x = 0; x < heightCollectorTile.getPixelTileSize(); ++x) {
                float maxHeightDiff = 0.0f;
                maxHeightDiff = Math.max(maxHeightDiff, this.getHeightDiff(heightCollectorTile.getValue(x - 1, y - 1), heightCollectorTile.getValue(x + 1, y + 1)));
                maxHeightDiff = Math.max(maxHeightDiff, this.getHeightDiff(heightCollectorTile.getValue(x - 1, y + 1), heightCollectorTile.getValue(x + 1, y - 1)));
                maxHeightDiff = Math.max(maxHeightDiff, this.getHeightDiff(heightCollectorTile.getValue(x - 1, y), heightCollectorTile.getValue(x + 1, y)));
                maxHeightDiff = Math.max(maxHeightDiff, this.getHeightDiff(heightCollectorTile.getValue(x, y - 1), heightCollectorTile.getValue(x, y + 1)));
                float maxSlopeDegree = (float)Math.toDegrees(Math.atan(maxHeightDiff / meterPerPixel));
                float rootedMaxSlopeDegree = (float)Math.sqrt(maxSlopeDegree);
                float weightedSlopeDegree = rootedMaxSlopeDegree * angleImpact;
                float[] topRgba = new float[4];
                topRgba = topRaster.getPixel(x, y, topRgba);
                topRgba[0] = color.getRed();
                topRgba[1] = color.getGreen();
                topRgba[2] = color.getBlue();
                float slope0to255 = 256.0f * weightedSlopeDegree / 90.0f;
                if (slope0to255 > 255.0f) {
                    slope0to255 = 255.0f;
                } else if (slope0to255 < 0.0f) {
                    slope0to255 = 0.0f;
                }
                topRgba[3] = slope0to255;
                topRaster.setPixel(x, y, topRgba);
            }
        }
        renderRequest.getRenderImage().mergeBackLayer(heightLayer);
    }

    private float getHeightDiff(float one, float two) {
        return Math.abs(one - two);
    }
}

