/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.osm;

import de.wideportal.maprender.datasource.kml.KmlLineString;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresPolygonElement {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String source;
    private Point[] points = null;

    private PostgresPolygonElement() {
    }

    public PostgresPolygonElement(String geometryString) {
        this.source = geometryString;
        this.parseGeometryString(geometryString);
    }

    public PostgresPolygonElement(PostgresLineString closedLineString) {
        this.source = closedLineString.getSource();
        this.points = closedLineString.getPoints();
    }

    public PostgresPolygonElement(KmlLineString kmlLineString) {
        this.source = kmlLineString.getSource();
        this.points = this.convertLatLonLineStringToMercatorPoints(kmlLineString.getPoints());
    }

    private void parseGeometryString(String geometryString) {
        geometryString = geometryString.replaceAll("/", ".");
        geometryString = geometryString.replaceAll("!", ".");
        geometryString = geometryString.replaceAll("([0-9])\\-([\\-0-9])", "$1,$2");
        String[] pointsList = geometryString.split(",");
        this.points = new Point[pointsList.length];
        try {
            for (int i = 0; i < pointsList.length; ++i) {
                Point mercatorPoint;
                String[] webMercatorPoints = pointsList[i].split(" ");
                this.points[i] = mercatorPoint = new Point(Double.parseDouble(webMercatorPoints[0]), Double.parseDouble(webMercatorPoints[1]));
            }
        }
        catch (Exception e) {
            this.log.error("parseGeometryString: could not parse geometry string: " + geometryString);
            throw new RuntimeException(e);
        }
    }

    public Point[] getPoints() {
        return this.points;
    }

    public ArrayList<Point> getPointsInBoundingBoxMercator(BoundingBox boundingBox) {
        ArrayList<Point> pointsInBoundingBox = new ArrayList<Point>();
        for (Point point : this.points) {
            if (!(point.x >= boundingBox.left) || !(point.x <= boundingBox.right) || !(point.y <= boundingBox.top) || !(point.y >= boundingBox.bottom)) continue;
            pointsInBoundingBox.add(point);
        }
        return pointsInBoundingBox;
    }

    public boolean hasPointsInBoundingBoxMercator(BoundingBox boundingBox) {
        return this.getPointsInBoundingBoxMercator(boundingBox).size() > 0;
    }

    public String getSource() {
        return this.source;
    }

    public static int[][] getPointsAsIntArray(ArrayList<Point> pointsToArray) {
        int[] xValues = new int[pointsToArray.size()];
        int[] yValues = new int[pointsToArray.size()];
        for (int i = 0; i < pointsToArray.size(); ++i) {
            xValues[i] = (int)pointsToArray.get(i).getX();
            yValues[i] = (int)pointsToArray.get(i).getY();
        }
        return new int[][]{xValues, yValues};
    }

    public static int[][] getPointsAsIntArray(Point[] pointsToArray) {
        int[] xValues = new int[pointsToArray.length];
        int[] yValues = new int[pointsToArray.length];
        for (int i = 0; i < pointsToArray.length; ++i) {
            xValues[i] = (int)Math.round(pointsToArray[i].getX());
            yValues[i] = (int)Math.round(pointsToArray[i].getY());
        }
        return new int[][]{xValues, yValues};
    }

    public static double[][] getPointsAsDoubleArray(ArrayList<Point> pointsToArray) {
        double[] xValues = new double[pointsToArray.size()];
        double[] yValues = new double[pointsToArray.size()];
        for (int i = 0; i < pointsToArray.size(); ++i) {
            xValues[i] = pointsToArray.get(i).getX();
            yValues[i] = pointsToArray.get(i).getY();
        }
        return new double[][]{xValues, yValues};
    }

    public PostgresLineString getAsLineString() {
        PostgresLineString lineString = new PostgresLineString(this.source, this.points);
        return lineString;
    }

    public BoundingBox getBoundingBox(boolean topIsMinY) {
        BoundingBox result = new BoundingBox(this.points, topIsMinY);
        return result;
    }

    protected Point[] convertLatLonLineStringToMercatorPoints(Point[] latLonPoints) {
        GeoCalculator geoCalculator = new GeoCalculator();
        Point[] mercatorPoints = new Point[latLonPoints.length];
        for (int i = 0; i < latLonPoints.length; ++i) {
            mercatorPoints[i] = geoCalculator.convertLatLonToMercator(latLonPoints[i]);
        }
        return mercatorPoints;
    }

    public PostgresPolygonElement clone() {
        PostgresPolygonElement clone = new PostgresPolygonElement();
        clone.source = this.source;
        clone.points = new Point[this.points.length];
        System.arraycopy(this.points, 0, clone.points, 0, this.points.length);
        return clone;
    }

    public String toString() {
        return "PostgresPolygonElement[#points=" + this.points.length + "]";
    }
}

