/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.osm;

import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.datasource.osm.PostgresMultiPolygon;
import de.wideportal.maprender.datasource.osm.PostgresOverCachingCache;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.resources.AbstractConnectableResource;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Optional;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresCache
implements AbstractConnectableResource {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String CACHE_POSTGRES_POLYGON = "postgresPolygonCache";
    public static final String CACHE_POSTGRES_MULTIPOLYGON = "postgresMultiPolygonCache";
    public static final String CACHE_POSTGRES_LINESTRING = "postgresLineStringCache";
    private Cache postgresPolygonCache = null;
    private Cache postgresMultiPolygonCache = null;
    private Cache postgresLineStringCache = null;
    private PostgresOverCachingCache postgresOverCachingCache = null;
    private CacheManager cacheManager = null;

    @Override
    public void connect() throws Exception {
        this.log.info("connect: starting postgres geometry ehcache");
        this.cacheManager = CacheManager.create();
        CacheConfiguration postgresPolygonCacheConfig = new CacheConfiguration(CACHE_POSTGRES_POLYGON, 200).copyOnRead(false).copyOnWrite(false).memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LFU).overflowToDisk(false).diskPersistent(false);
        this.postgresPolygonCache = new Cache(postgresPolygonCacheConfig);
        CacheConfiguration postgresMultiPolygonCacheConfig = new CacheConfiguration(CACHE_POSTGRES_MULTIPOLYGON, 200).copyOnRead(false).copyOnWrite(false).memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LFU).overflowToDisk(false).diskPersistent(false);
        this.postgresMultiPolygonCache = new Cache(postgresMultiPolygonCacheConfig);
        CacheConfiguration postgresLineStringCacheConfig = new CacheConfiguration(CACHE_POSTGRES_LINESTRING, 200).copyOnRead(false).copyOnWrite(false).memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LFU).overflowToDisk(false).diskPersistent(false);
        this.postgresLineStringCache = new Cache(postgresLineStringCacheConfig);
        this.cacheManager.addCache(this.postgresPolygonCache);
        this.cacheManager.addCache(this.postgresMultiPolygonCache);
        this.cacheManager.addCache(this.postgresLineStringCache);
        this.postgresOverCachingCache = new PostgresOverCachingCache();
    }

    @Override
    public void disconnect() {
        this.log.info("connect: stopping postgres geometry ehcache");
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
    }

    public void addToCache(PostgresPolygon polygon) {
        if (polygon.getSource() != null && !polygon.getSource().isBlank()) {
            this.postgresPolygonCache.put(new Element((Object)polygon.getSource(), (Object)polygon));
        }
    }

    public void addToCache(PostgresMultiPolygon multiPolygon) {
        if (multiPolygon.getSource() != null && !multiPolygon.getSource().isBlank()) {
            this.postgresMultiPolygonCache.put(new Element((Object)multiPolygon.getSource(), (Object)multiPolygon));
        }
    }

    public void addToCache(PostgresLineString lineString) {
        if (lineString.getSource() != null && !lineString.getSource().isBlank()) {
            this.postgresLineStringCache.put(new Element((Object)lineString.getSource(), (Object)lineString));
        }
    }

    public void addToCache(String cachingKeyFromSqlQuery, BoundingBox bbox, ResultSet resultSet) {
        this.postgresOverCachingCache.addToCache(cachingKeyFromSqlQuery, bbox, resultSet);
    }

    public Optional<IDatasourceGeometry> getPolygon(String source) {
        Element result = this.postgresPolygonCache.get((Serializable)((Object)source));
        if (result != null) {
            return Optional.ofNullable((IDatasourceGeometry)result.getObjectValue());
        }
        return Optional.empty();
    }

    public Optional<IDatasourceGeometry> getMultiPolygon(String source) {
        Element result = this.postgresMultiPolygonCache.get((Serializable)((Object)source));
        if (result != null) {
            return Optional.ofNullable((IDatasourceGeometry)result.getObjectValue());
        }
        return Optional.empty();
    }

    public Optional<IDatasourceGeometry> getLineString(String source) {
        Element result = this.postgresLineStringCache.get((Serializable)((Object)source));
        if (result != null) {
            return Optional.ofNullable((IDatasourceGeometry)result.getObjectValue());
        }
        return Optional.empty();
    }

    public Optional<ResultSet> getResultSet(String cachingKeyFromSqlQuery, BoundingBox bbox) {
        return this.postgresOverCachingCache.getResultSet(cachingKeyFromSqlQuery, bbox);
    }
}

