/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationDatasources;
import de.wideportal.maprender.datasource.DatasourceException;
import de.wideportal.maprender.datasource.DatasourceRequest;
import de.wideportal.maprender.datasource.IRenderDatasource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledRenderDatasource
implements IRenderDatasource {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderConfigurationDatasources datasourcesConfig;
    private BasicDataSource pool = new BasicDataSource();
    private boolean isConnected = false;

    public PooledRenderDatasource(RenderConfiguration configuration) {
        this.datasourcesConfig = configuration.getMaprenderConfiguration().getDatasources();
    }

    @Override
    public DatasourceRequest getNewRequest() {
        return new DatasourceRequest(this);
    }

    @Override
    public void connect(int threadCount) throws DatasourceException {
        this.log.info("connect: starting to connect to datasource: " + this.datasourcesConfig);
        if (this.datasourcesConfig != null && this.datasourcesConfig.getDb() != null) {
            try {
                this.pool.setUrl(this.datasourcesConfig.getDb().getConnection());
                this.pool.setUsername(this.datasourcesConfig.getDb().getUser());
                this.pool.setPassword(this.datasourcesConfig.getDb().getPassword());
                this.pool.setMinIdle(threadCount + 1);
                this.pool.setMaxIdle(threadCount * 2 + 1);
                this.pool.setMaxOpenPreparedStatements(100);
                this.pool.setDefaultAutoCommit(true);
                this.pool.setDefaultReadOnly(true);
                this.isConnected = true;
            }
            catch (Exception e) {
                this.log.error("connect: could not establish database connection for pool", (Throwable)e);
                throw new DatasourceException("Could not establish the datasource connection for pool: " + e.getMessage());
            }
            this.log.info("connect: connected to datasource: " + this.datasourcesConfig);
        } else {
            this.log.info("connect: no database configured");
        }
    }

    @Override
    public void disconnect() {
        this.log.info("disconnect: trying to disconnect datasource from db");
        try {
            this.pool.close();
            this.isConnected = false;
        }
        catch (SQLException e) {
            this.log.error("disconnect: could not disconnect", (Throwable)e);
        }
        this.log.info("disconnect: disconnect datasource from db");
    }

    @Override
    public Optional<Connection> getConnection() {
        Optional<Connection> result = Optional.empty();
        try {
            if (this.isConnected) {
                result = Optional.ofNullable(this.pool.getConnection());
            }
        }
        catch (SQLException e) {
            this.log.error("getConnection: could not get connection from pool", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean inspectConnection(Optional<Connection> connection) {
        if (connection.isPresent()) {
            Connection conn = connection.get();
            try {
                this.log.info("inspectConnection: DatabaseProductName=" + conn.getMetaData().getDatabaseProductName());
                this.log.info("inspectConnection: DatabaseProductVersion=" + conn.getMetaData().getDatabaseProductVersion());
                ResultSet resultSet = conn.getMetaData().getTables(null, "public", "%", null);
                while (resultSet.next()) {
                    this.log.debug("inspectConnection: Table=" + resultSet.getString(2) + " / " + resultSet.getString(3));
                }
                return true;
            }
            catch (SQLException e) {
                this.log.error("inspectConnection: an exception occured", (Throwable)e);
            }
        } else {
            this.log.info("inspectConnection: no connection");
        }
        return false;
    }
}

