/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource;

import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.datasource.osm.PostgresCache;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.datasource.osm.PostgresMultiLineString;
import de.wideportal.maprender.datasource.osm.PostgresMultiPolygon;
import de.wideportal.maprender.datasource.osm.PostgresPoint;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceGeometryFactory {
    protected static Logger log = LoggerFactory.getLogger(DatasourceGeometryFactory.class);

    public static Optional<IDatasourceGeometry> getFittingGeometry(String geometryString, PostgresCache postgresCache) {
        try {
            if (PostgresLineString.isFittingGeometry(geometryString)) {
                Optional<IDatasourceGeometry> cachedPostgresLineString = postgresCache.getLineString(geometryString);
                if (cachedPostgresLineString.isPresent()) {
                    return cachedPostgresLineString;
                }
                PostgresLineString pls = new PostgresLineString(geometryString);
                postgresCache.addToCache(pls);
                return Optional.of(pls);
            }
            if (PostgresMultiLineString.isFittingGeometry(geometryString)) {
                return Optional.of(new PostgresMultiLineString(geometryString));
            }
            if (PostgresPoint.isFittingGeometry(geometryString)) {
                return Optional.of(new PostgresPoint(geometryString));
            }
            if (PostgresPolygon.isFittingGeometry(geometryString)) {
                Optional<IDatasourceGeometry> cachedPostgresPolygon = postgresCache.getPolygon(geometryString);
                if (cachedPostgresPolygon.isPresent()) {
                    return cachedPostgresPolygon;
                }
                PostgresPolygon pp = new PostgresPolygon(geometryString);
                postgresCache.addToCache(pp);
                return Optional.of(pp);
            }
            if (PostgresMultiPolygon.isFittingGeometry(geometryString)) {
                Optional<IDatasourceGeometry> cachedPostgresMultiPolygon = postgresCache.getMultiPolygon(geometryString);
                if (cachedPostgresMultiPolygon.isPresent()) {
                    return cachedPostgresMultiPolygon;
                }
                PostgresMultiPolygon pmp = new PostgresMultiPolygon(geometryString);
                postgresCache.addToCache(pmp);
                return Optional.of(pmp);
            }
        }
        catch (Exception e) {
            log.error("getFittingGeometry: could not parse geometry string: " + geometryString, (Throwable)e);
            throw new RuntimeException(e);
        }
        return Optional.empty();
    }
}

