/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.imagefilter;

import de.wideportal.maprender.config.xml.osm.imagefilter.AbstractOsmStyleImageFilter;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseWatermarkFilter
extends AbstractOsmStyleImageFilter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int WATERMARK_BLOCK_SIZE = 46;
    private static final int WATERMARK_CELL_SIZE = 2;
    private static final int WATERMARK_BORDER_SIZE = 2;
    private static final int VALUE_FALSE = 0;
    private static final int VALUE_TRUE = 1;
    private static final int VALUE_UNKNOWN = 2;
    private RenderRequest renderRequest;

    public LicenseWatermarkFilter(RenderRequest renderRequest) {
        this.renderRequest = renderRequest;
    }

    @Override
    public void applyFilter(RenderImageLayer renderImageLayer) {
        String customerID = this.renderRequest.getLicense().getLicense().getSource().getMandatory().getCustomerId();
        String customer = this.renderRequest.getLicense().getLicense().getSource().getMandatory().getCustomer();
        String content = customerID + " " + customer;
        BufferedImage image = renderImageLayer.getImage();
        WritableRaster raster = image.getRaster();
        int imageSize = raster.getWidth();
        int blockWithBorder = 50;
        int offset = imageSize % blockWithBorder / 2;
        int cells = (int)Math.pow(23.0, 2.0);
        boolean[] watermarkAsBooleanArray = this.getWatermarkAsBooleanArray(content, cells);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                boolean isBlockStart = false;
                if ((x - offset) % blockWithBorder == 0 && x + blockWithBorder < imageSize && (y - offset) % blockWithBorder == 0 && y + blockWithBorder < imageSize) {
                    isBlockStart = true;
                }
                if (!isBlockStart) continue;
                int cellCounter = -1;
                for (int j = 0; j < blockWithBorder; ++j) {
                    for (int i = 0; i < blockWithBorder; ++i) {
                        if (this.isBorderCorner(i, j, blockWithBorder)) {
                            float[] rgba = new float[4];
                            rgba = raster.getPixel(x + i, y + j, rgba);
                            float[] newRGBA = this.setValueWatermark(rgba, true, false);
                            raster.setPixel(x + i, y + j, newRGBA);
                            continue;
                        }
                        if (this.isBorderEdge(i, j, blockWithBorder)) {
                            float[] rgba = new float[4];
                            rgba = raster.getPixel(x + i, y + j, rgba);
                            float[] newRGBA = this.setValueWatermark(rgba, false, true);
                            raster.setPixel(x + i, y + j, newRGBA);
                            continue;
                        }
                        if (i % 2 != 0 || j % 2 != 0) continue;
                        boolean watermarkBoolean = watermarkAsBooleanArray[++cellCounter];
                        for (int n = 0; n < 2; ++n) {
                            for (int m = 0; m < 2; ++m) {
                                float[] rgba = new float[4];
                                rgba = raster.getPixel(x + i + m, y + j + n, rgba);
                                float[] newRGBA = this.setValueWatermark(rgba, watermarkBoolean, !watermarkBoolean);
                                raster.setPixel(x + i + m, y + j + n, newRGBA);
                            }
                        }
                    }
                }
            }
        }
    }

    public void checkWatermark(BufferedImage image) {
        this.log.info("checkWatermark: checking watermark of given image");
        WritableRaster raster = image.getRaster();
        Point blockStart = this.searchBlockStart(raster);
        if (blockStart != null) {
            boolean[] values = this.readBlockValues(blockStart, raster);
            String watermark = this.getWatermarkFromBooleanArray(values);
            this.log.info("checkWatermark: watermark is: " + watermark);
        } else {
            this.log.info("checkWatermark: no watermark blocks found ");
        }
    }

    private boolean[] getWatermarkAsBooleanArray(String content, int cells) {
        byte[] contentBytes = content.getBytes();
        try {
            contentBytes = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.warn("applyFilter: Encoding UTF-8 not supported. Using default encoding instead.");
        }
        byte[] watermarkBytes = new byte[cells / 8];
        System.arraycopy(contentBytes, 0, watermarkBytes, 0, Math.min(watermarkBytes.length, contentBytes.length));
        boolean[] watermarkBooleans = new boolean[cells];
        for (int i = 0; i < watermarkBytes.length; ++i) {
            byte currentByte = watermarkBytes[i];
            watermarkBooleans[i * 8 + 0] = (currentByte & 1) != 0;
            watermarkBooleans[i * 8 + 1] = (currentByte & 2) != 0;
            watermarkBooleans[i * 8 + 2] = (currentByte & 4) != 0;
            watermarkBooleans[i * 8 + 3] = (currentByte & 8) != 0;
            watermarkBooleans[i * 8 + 4] = (currentByte & 0x10) != 0;
            watermarkBooleans[i * 8 + 5] = (currentByte & 0x20) != 0;
            watermarkBooleans[i * 8 + 6] = (currentByte & 0x40) != 0;
            watermarkBooleans[i * 8 + 7] = (currentByte & 0x80) != 0;
        }
        return watermarkBooleans;
    }

    private String getWatermarkFromBooleanArray(boolean[] values) {
        int bytes = values.length / 8;
        byte[] byteValues = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            byte value;
            byteValues[i] = value = (byte)((values[i * 8 + 0] ? 1 : 0) + (values[i * 8 + 1] ? 2 : 0) + (values[i * 8 + 2] ? 4 : 0) + (values[i * 8 + 3] ? 8 : 0) + (values[i * 8 + 4] ? 16 : 0) + (values[i * 8 + 5] ? 32 : 0) + (values[i * 8 + 6] ? 64 : 0) + (values[i * 8 + 7] ? 128 : 0));
        }
        String result = new String(byteValues);
        try {
            result = new String(byteValues, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.warn("getWatermarkFromBooleanArray: Encoding UTF-8 not supported. Using default encoding instead.");
        }
        return result;
    }

    private boolean[] readBlockValues(Point blockStart, WritableRaster raster) {
        int xStart = (int)blockStart.getX();
        int yStart = (int)blockStart.getY();
        int blockWithBorder = 50;
        int imageSize = raster.getWidth();
        int cells = (int)Math.pow(23.0, 2.0);
        if (xStart >= blockWithBorder) {
            xStart -= blockWithBorder;
        }
        if (yStart >= blockWithBorder) {
            yStart -= blockWithBorder;
        }
        ArrayList<int[]> intValues = new ArrayList<int[]>();
        for (int x = xStart; x < imageSize - blockWithBorder; x += blockWithBorder) {
            for (int y = yStart; y < imageSize - blockWithBorder; y += blockWithBorder) {
                Point currentBlockStart = new Point(x, y);
                int[] values = this.readBlock(currentBlockStart, raster);
                intValues.add(values);
            }
        }
        this.log.info("readBlockValues: found blocks #" + intValues.size());
        boolean[] aggregatedValues = new boolean[cells];
        int inconsistencyCounter = 0;
        for (int index = 0; index < cells; ++index) {
            int falseCounter = 0;
            int trueCounter = 0;
            int unknownCounter = 0;
            for (int block = 0; block < intValues.size(); ++block) {
                if (((int[])intValues.get(block))[index] == 1) {
                    ++trueCounter;
                    continue;
                }
                if (((int[])intValues.get(block))[index] == 0) {
                    ++falseCounter;
                    continue;
                }
                ++unknownCounter;
            }
            if (trueCounter > 0 && falseCounter > 0 || unknownCounter > 0) {
                ++inconsistencyCounter;
            }
            aggregatedValues[index] = trueCounter > falseCounter;
        }
        this.log.warn("readBlockValues: found inconsistencies between blocks: #" + inconsistencyCounter);
        return aggregatedValues;
    }

    private boolean isBorderCorner(int i, int j, int blockWithBorder) {
        return i >= 0 && i < 2 && (j >= 0 && j < 2 || j >= blockWithBorder - 2 && j < blockWithBorder) || i >= blockWithBorder - 2 && i < blockWithBorder && (j >= 0 && j < 2 || j >= blockWithBorder - 2 && j < blockWithBorder);
    }

    private boolean isBorderEdge(int i, int j, int blockWithBorder) {
        return i >= 0 && i < 2 || i >= blockWithBorder - 2 && i < blockWithBorder || j >= 0 && j < 2 || j >= blockWithBorder - 2 && j < blockWithBorder;
    }

    private int[] readBlock(Point blockStart, WritableRaster raster) {
        int cells = (int)Math.pow(23.0, 2.0);
        int cellCounter = -1;
        int[] intValues = new int[cells];
        float[] rgba = new float[4];
        int x = (int)blockStart.getX();
        int y = (int)blockStart.getY();
        for (int j = 0; j < 46; j += 2) {
            for (int i = 0; i < 46; i += 2) {
                int value1 = this.getValueWatermark(raster.getPixel(x + i, y + j, rgba));
                int value2 = this.getValueWatermark(raster.getPixel(x + i, y + j + 1, rgba));
                int value3 = this.getValueWatermark(raster.getPixel(x + i + 1, y + j, rgba));
                int value4 = this.getValueWatermark(raster.getPixel(x + i + 1, y + j + 1, rgba));
                intValues[++cellCounter] = value1 == value2 && value2 == value3 && value3 == value4 ? value1 : 2;
            }
        }
        return intValues;
    }

    private Point searchBlockStart(WritableRaster raster) {
        for (int y = 0; y < raster.getHeight() - 46 - 4; ++y) {
            for (int x = 0; x < raster.getWidth() - 46 - 4; ++x) {
                int valueRight;
                int valueLeft;
                int j;
                int valueBottom;
                int valueTop;
                int i;
                float[] rgba = new float[4];
                int value1 = this.getValueWatermark(raster.getPixel(x, y, rgba));
                int value2 = this.getValueWatermark(raster.getPixel(x, y + 1, rgba));
                int value3 = this.getValueWatermark(raster.getPixel(x + 1, y, rgba));
                int value4 = this.getValueWatermark(raster.getPixel(x + 1, y + 1, rgba));
                if (value1 != 1 || value2 != 1 || value3 != 1 || value4 != 1) continue;
                boolean noBorder = false;
                for (i = 0; i < 46; ++i) {
                    valueTop = this.getValueWatermark(raster.getPixel(x + 2 + i, y + 0, rgba));
                    valueBottom = this.getValueWatermark(raster.getPixel(x + 2 + i, y + 1, rgba));
                    if (valueTop == 0 && valueBottom == 0) continue;
                    noBorder = true;
                    break;
                }
                if (noBorder) continue;
                value1 = this.getValueWatermark(raster.getPixel(x + 2 + 46, y, rgba));
                value2 = this.getValueWatermark(raster.getPixel(x + 2 + 46, y + 1, rgba));
                value3 = this.getValueWatermark(raster.getPixel(x + 2 + 46 + 1, y, rgba));
                value4 = this.getValueWatermark(raster.getPixel(x + 2 + 46 + 1, y + 1, rgba));
                if (value1 != 1 || value2 != 1 || value3 != 1 || value4 != 1) {
                    noBorder = true;
                    continue;
                }
                for (j = 0; j < 46; ++j) {
                    valueLeft = this.getValueWatermark(raster.getPixel(x + 0, y + 2 + j, rgba));
                    valueRight = this.getValueWatermark(raster.getPixel(x + 1, y + 2 + j, rgba));
                    if (valueLeft == 0 && valueRight == 0) continue;
                    noBorder = true;
                    break;
                }
                if (noBorder) continue;
                value1 = this.getValueWatermark(raster.getPixel(x, y + 2 + 46, rgba));
                value2 = this.getValueWatermark(raster.getPixel(x, y + 2 + 46 + 1, rgba));
                value3 = this.getValueWatermark(raster.getPixel(x + 1, y + 2 + 46, rgba));
                value4 = this.getValueWatermark(raster.getPixel(x + 1, y + 2 + 46 + 1, rgba));
                if (value1 != 1 || value2 != 1 || value3 != 1 || value4 != 1) {
                    noBorder = true;
                    continue;
                }
                for (i = 0; i < 46; ++i) {
                    valueTop = this.getValueWatermark(raster.getPixel(x + 2 + i, y + 2 + 46 + 0, rgba));
                    valueBottom = this.getValueWatermark(raster.getPixel(x + 2 + i, y + 2 + 46 + 1, rgba));
                    if (valueTop == 0 && valueBottom == 0) continue;
                    noBorder = true;
                    break;
                }
                if (noBorder) continue;
                value1 = this.getValueWatermark(raster.getPixel(x + 2 + 46, y + 2 + 46, rgba));
                value2 = this.getValueWatermark(raster.getPixel(x + 2 + 46, y + 2 + 46 + 1, rgba));
                value3 = this.getValueWatermark(raster.getPixel(x + 2 + 46 + 1, y + 2 + 46, rgba));
                value4 = this.getValueWatermark(raster.getPixel(x + 2 + 46 + 1, y + 2 + 46 + 1, rgba));
                if (value1 != 1 || value2 != 1 || value3 != 1 || value4 != 1) {
                    noBorder = true;
                    continue;
                }
                for (j = 0; j < 46; ++j) {
                    valueLeft = this.getValueWatermark(raster.getPixel(x + 2 + 46 + 0, y + 2 + j, rgba));
                    valueRight = this.getValueWatermark(raster.getPixel(x + 2 + 46 + 1, y + 2 + j, rgba));
                    if (valueLeft == 0 && valueRight == 0) continue;
                    noBorder = true;
                    break;
                }
                if (noBorder) continue;
                return new Point(x + 2, y + 2);
            }
        }
        return null;
    }

    private int getValueWatermark(float[] rgba) {
        int red = (int)rgba[0];
        int green = (int)rgba[1];
        boolean[] redBits = new boolean[8];
        boolean[] greenBits = new boolean[8];
        for (int i = 7; i >= 0; --i) {
            redBits[i] = (red & 1 << i) != 0;
            greenBits[i] = (green & 1 << i) != 0;
        }
        if (redBits[0] && !greenBits[0]) {
            return 1;
        }
        if (!redBits[0] && greenBits[0]) {
            return 0;
        }
        return 2;
    }

    private float[] setValueWatermark(float[] rgba, boolean redFlag, boolean greenFlag) {
        int red = (int)rgba[0];
        int green = (int)rgba[1];
        boolean[] redBits = new boolean[8];
        boolean[] greenBits = new boolean[8];
        for (int i = 7; i >= 0; --i) {
            redBits[i] = (red & 1 << i) != 0;
            greenBits[i] = (green & 1 << i) != 0;
        }
        redBits[0] = redFlag;
        greenBits[0] = greenFlag;
        int newRed = (redBits[0] ? 1 : 0) + (redBits[1] ? 2 : 0) + (redBits[2] ? 4 : 0) + (redBits[3] ? 8 : 0) + (redBits[4] ? 16 : 0) + (redBits[5] ? 32 : 0) + (redBits[6] ? 64 : 0) + (redBits[7] ? 128 : 0);
        int newGreen = (greenBits[0] ? 1 : 0) + (greenBits[1] ? 2 : 0) + (greenBits[2] ? 4 : 0) + (greenBits[3] ? 8 : 0) + (greenBits[4] ? 16 : 0) + (greenBits[5] ? 32 : 0) + (greenBits[6] ? 64 : 0) + (greenBits[7] ? 128 : 0);
        float[] newRGBA = new float[]{newRed, newGreen, rgba[2], rgba[3]};
        return newRGBA;
    }
}

