/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.filter;

import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterPart;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterResult;
import de.wideportal.maprender.datasource.RenderResultSetCache;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmRuleFilterCondition
extends OsmRuleFilterPart {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public OsmRuleFilterCondition(String filterDescription) {
        super(filterDescription);
    }

    public OsmRuleFilterCondition(OsmRuleFilterPart part) {
        super(part.getFilterDescription());
        this.subFilters = part.getSubFilters();
    }

    @Override
    public boolean matchesResultSet(RenderResultSetCache resultSetCache, OsmRuleFilterResult filterResult) {
        String keyword = this.getKeyword();
        String operator = this.getOperator(keyword);
        String expectedResult = this.getExpectedResult(keyword, operator);
        String realResult = "";
        boolean result = false;
        Object resultString = this.filterDescription;
        try {
            realResult = resultSetCache.getString(keyword);
            resultString = (String)resultString + " -> [" + keyword + "=" + realResult + "]";
            if (expectedResult == null) {
                if ("=".equalsIgnoreCase(operator)) {
                    result = realResult == null;
                } else if ("!=".equalsIgnoreCase(operator)) {
                    result = realResult != null;
                }
            } else if ("=".equalsIgnoreCase(operator)) {
                result = realResult == null && (expectedResult.equalsIgnoreCase("no") || expectedResult.equalsIgnoreCase("false")) ? false : (realResult == null && expectedResult.equalsIgnoreCase("") ? true : expectedResult.equalsIgnoreCase(realResult));
            } else if ("!=".equalsIgnoreCase(operator)) {
                result = realResult == null && (expectedResult.equalsIgnoreCase("no") || expectedResult.equalsIgnoreCase("false")) ? true : (realResult == null && expectedResult.equalsIgnoreCase("") ? false : !expectedResult.equalsIgnoreCase(realResult));
            } else if ("&gt;".equalsIgnoreCase(operator) || ">".equalsIgnoreCase(operator)) {
                if (realResult != null) {
                    double expectedDouble = Double.parseDouble(expectedResult);
                    double realDouble = Double.parseDouble(realResult);
                    result = realDouble > expectedDouble;
                }
            } else if ("&lt;".equalsIgnoreCase(operator) || "<".equalsIgnoreCase(operator)) {
                if (realResult != null) {
                    double expectedDouble = Double.parseDouble(expectedResult);
                    double realDouble = Double.parseDouble(realResult);
                    result = realDouble < expectedDouble;
                }
            } else if ("&ge;".equalsIgnoreCase(operator) || ">=".equalsIgnoreCase(operator)) {
                if (realResult != null) {
                    double expectedDouble = Double.parseDouble(expectedResult);
                    double realDouble = Double.parseDouble(realResult);
                    result = realDouble >= expectedDouble;
                }
            } else if ("&le;".equalsIgnoreCase(operator) || "<=".equalsIgnoreCase(operator)) {
                if (realResult != null) {
                    double expectedDouble = Double.parseDouble(expectedResult);
                    double realDouble = Double.parseDouble(realResult);
                    result = realDouble <= expectedDouble;
                }
            } else {
                this.log.warn("matchesResultSet: unknown operator: " + operator + " in filter: " + this.filterDescription);
            }
        }
        catch (SQLException e) {
            this.log.error("matchesResultSet: could not get filter values from resultset: " + keyword, (Throwable)e);
        }
        catch (Exception ex) {
            this.log.error("matchesResultSet: unexpected exception: realResult=" + realResult + ", expectedResult=" + expectedResult + ", keyword=" + keyword + ", operator=" + operator, (Throwable)ex);
        }
        resultString = (String)resultString + " -> " + result + " ";
        filterResult.addFilterPart((String)resultString);
        return result;
    }

    private String getOperator(String keyword) {
        String operatorAndExpectedResult = this.filterDescription;
        operatorAndExpectedResult = operatorAndExpectedResult.substring(keyword.length() + 2).trim();
        int afterOperator = operatorAndExpectedResult.indexOf(" ");
        String operator = operatorAndExpectedResult.substring(0, afterOperator);
        return operator;
    }

    private String getKeyword() {
        int indexOpeningBracket = -1;
        int indexClosingBracket = -1;
        for (int i = 0; i < this.filterDescription.length(); ++i) {
            if (indexOpeningBracket == -1) {
                if (this.filterDescription.charAt(i) != '[') continue;
                indexOpeningBracket = i;
                continue;
            }
            if (this.filterDescription.charAt(i) != ']') continue;
            indexClosingBracket = i;
            break;
        }
        return this.filterDescription.substring(indexOpeningBracket + 1, indexClosingBracket);
    }

    private String getExpectedResult(String keyword, String operator) {
        String expectedResult = null;
        try {
            String operatorAndExpectedResult = this.filterDescription;
            operatorAndExpectedResult = operatorAndExpectedResult.substring(keyword.length() + 2).trim();
            expectedResult = operatorAndExpectedResult.substring(operator.length()).trim();
            if ("null".equals(expectedResult)) {
                return null;
            }
            expectedResult = expectedResult.startsWith("'") ? expectedResult.substring(1) : expectedResult;
            expectedResult = expectedResult.startsWith("\"") ? expectedResult.substring(1) : expectedResult;
            expectedResult = expectedResult.endsWith("'") ? expectedResult.substring(0, expectedResult.length() - 1) : expectedResult;
            expectedResult = expectedResult.endsWith("\"") ? expectedResult.substring(0, expectedResult.length() - 1) : expectedResult;
        }
        catch (Exception e) {
            this.log.error("getExpectedResult: unexpected exception. filterDescription=" + this.filterDescription + ", expectedResult=" + expectedResult, (Throwable)e);
        }
        return expectedResult;
    }

    @Override
    public String toString() {
        return "OsmRuleFilterCondition[filterDescription=" + this.filterDescription + "]";
    }
}

