/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.filter;

import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterAlwaysTrue;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterCondition;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterOperator;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterPart;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterResult;
import de.wideportal.maprender.datasource.RenderResultSetCache;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmRuleFilter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String filterMode;
    private OsmRule rule;
    private OsmRuleFilterPart filter = null;
    private double minScaleDenominator = -1.0;
    private double maxScaleDenominator = -1.0;

    public static OsmRuleFilter getDefaultTrueFilter() {
        String filterMode = null;
        OsmRule osmRule = null;
        OsmRuleFilter result = new OsmRuleFilter(filterMode, osmRule);
        result.setFilter(new OsmRuleFilterAlwaysTrue(null));
        return result;
    }

    public OsmRuleFilter(String filterMode, OsmRule osmRule) {
        this.filterMode = filterMode;
        this.rule = osmRule;
    }

    public void buildFilter() {
        if (this.rule == null || this.rule.getFilter() == null || this.rule.getFilter().trim().isEmpty()) {
            this.filter = new OsmRuleFilterAlwaysTrue(this.rule.getFilter());
        } else {
            OsmRuleFilterPart part = new OsmRuleFilterPart(this.rule.getFilter());
            this.filter = this.parseFilterDescription(part);
            this.filter = this.rearrangeFilterTreeForOperators(this.filter);
            this.logFilter(0, this.filter);
        }
        if (this.rule != null) {
            if (this.rule.getMinScaleDenominator() != null && !this.rule.getMinScaleDenominator().trim().isEmpty()) {
                this.minScaleDenominator = Double.parseDouble(this.rule.getMinScaleDenominator());
            }
            if (this.rule.getMaxScaleDenominator() != null && !this.rule.getMaxScaleDenominator().trim().isEmpty()) {
                this.maxScaleDenominator = Double.parseDouble(this.rule.getMaxScaleDenominator());
            }
        }
    }

    public String getFilterMode() {
        return this.filterMode;
    }

    public void setFilterMode(String filterMode) {
        this.filterMode = filterMode;
    }

    public OsmRuleFilterPart getFilter() {
        return this.filter;
    }

    public void setFilter(OsmRuleFilterPart filter) {
        this.filter = filter;
    }

    public OsmRule getRule() {
        return this.rule;
    }

    public void setRule(OsmRule rule) {
        this.rule = rule;
    }

    public String toString() {
        return "OsmRuleFilter[...]";
    }

    private OsmRuleFilterPart rearrangeFilterTreeForOperators(OsmRuleFilterPart filter) {
        ArrayList<OsmRuleFilterPart> subFilters = filter.getSubFilters();
        for (int i = subFilters.size() - 1; i >= 0; --i) {
            if (subFilters.get(i) instanceof OsmRuleFilterOperator) {
                OsmRuleFilterOperator operator = (OsmRuleFilterOperator)subFilters.get(i);
                OsmRuleFilterPart leftCondition = subFilters.get(i - 1);
                OsmRuleFilterPart rightCondition = subFilters.get(i + 1);
                this.rearrangeFilterTreeForOperators(leftCondition);
                operator.getSubFilters().add(leftCondition);
                operator.getSubFilters().add(rightCondition);
                subFilters.remove(i + 1);
                subFilters.remove(i - 1);
                --i;
                continue;
            }
            this.rearrangeFilterTreeForOperators(subFilters.get(i));
        }
        return filter;
    }

    private OsmRuleFilterPart parseFilterDescription(OsmRuleFilterPart input) {
        int i;
        ArrayList<OsmRuleFilterPart> parts = new ArrayList<OsmRuleFilterPart>();
        int currentParsingStartPoint = 0;
        int indexOpeningBracket = -1;
        int openingBracketsCounter = 0;
        int indexClosingBracket = -1;
        int foundBracketCounter = 0;
        String currentFilterDescription = input.getFilterDescription();
        for (i = 0; i < currentFilterDescription.length(); ++i) {
            String suffixPartDescription;
            if (indexOpeningBracket == -1) {
                if (currentFilterDescription.charAt(i) == '(') {
                    indexOpeningBracket = i;
                    ++openingBracketsCounter;
                }
            } else {
                if (currentFilterDescription.charAt(i) == '(') {
                    ++openingBracketsCounter;
                } else if (currentFilterDescription.charAt(i) == ')') {
                    --openingBracketsCounter;
                }
                if (openingBracketsCounter == 0) {
                    indexClosingBracket = i;
                    ++foundBracketCounter;
                    String prefixPartDescription = currentFilterDescription.substring(currentParsingStartPoint, indexOpeningBracket);
                    String bracketsPartDescription = currentFilterDescription.substring(indexOpeningBracket + 1, indexClosingBracket);
                    if (!prefixPartDescription.trim().isEmpty()) {
                        OsmRuleFilterPart prefixPart = new OsmRuleFilterPart(prefixPartDescription.trim());
                        parts.add(prefixPart);
                    }
                    if (!bracketsPartDescription.trim().isEmpty()) {
                        OsmRuleFilterPart bracketsPart = new OsmRuleFilterPart(bracketsPartDescription.trim());
                        parts.add(bracketsPart);
                    }
                    currentParsingStartPoint = i + 1;
                    indexOpeningBracket = -1;
                    indexClosingBracket = -1;
                }
            }
            if (i != currentFilterDescription.length() - 1 || currentParsingStartPoint >= i || (suffixPartDescription = currentFilterDescription.substring(indexClosingBracket + 1, currentFilterDescription.length())).trim().isEmpty()) continue;
            OsmRuleFilterPart suffixPart = new OsmRuleFilterPart(suffixPartDescription.trim());
            parts.add(suffixPart);
        }
        if (foundBracketCounter == 0) {
            if (input.isOperator()) {
                return new OsmRuleFilterOperator(input);
            }
            return new OsmRuleFilterCondition(input);
        }
        input.setSubFilters(parts);
        for (i = 0; i < parts.size(); ++i) {
            OsmRuleFilterPart part = parts.get(i);
            if (part.getSubFilters().size() != 0) continue;
            OsmRuleFilterPart updatedPart = this.parseFilterDescription(part);
            parts.set(i, updatedPart);
        }
        return input;
    }

    public OsmRuleFilterResult matchesResultSet(RenderResultSetCache resultSetCache, double currentDenominator) {
        OsmRuleFilterResult result = new OsmRuleFilterResult();
        result.setRuleIdentifier(this.rule.getIdentifier());
        result.setDenominatorRangeMin(this.minScaleDenominator);
        result.setDenominatorRangeMax(this.maxScaleDenominator);
        result.setDenominatorRangeActual(currentDenominator);
        if (!this.isInMinMaxDenominatorRange(currentDenominator)) {
            result.setMatches(false);
            return result;
        }
        boolean matches = this.filter.matchesResultSet(resultSetCache, result);
        result.setMatches(matches);
        return result;
    }

    private boolean isInMinMaxDenominatorRange(double currentDenominator) {
        if (this.minScaleDenominator != -1.0 && currentDenominator < this.minScaleDenominator) {
            return false;
        }
        return this.maxScaleDenominator == -1.0 || !(currentDenominator > this.maxScaleDenominator);
    }

    private void logFilter(int recursionDepth, OsmRuleFilterPart filter) {
        int indentationCount = 4 * recursionDepth;
        Object indentation = "";
        for (int i = 0; i < indentationCount; ++i) {
            indentation = (String)indentation + " ";
        }
        this.log.debug("logFilter: " + (String)indentation + filter);
        for (OsmRuleFilterPart part : filter.getSubFilters()) {
            this.logFilter(recursionDepth + 1, part);
        }
    }
}

