/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.compop;

import de.wideportal.maprender.config.xml.osm.compop.AbstractOsmStyleImageCompOp;
import de.wideportal.maprender.config.xml.osm.imagefilter.HslColor;
import de.wideportal.maprender.request.RenderImageLayer;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmStyleImageCompOpOpacityToHSL
extends AbstractOsmStyleImageCompOp {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private float mediumOpacity = 0.0f;
    private float lowHueScale = 0.0f;
    private float highHueScale = 0.0f;
    private float lowSaturationScale = 0.0f;
    private float highSaturationScale = 0.0f;
    private float lowLuminocityScale = 0.0f;
    private float highLuminocityScale = 0.0f;

    public OsmStyleImageCompOpOpacityToHSL(String configuration) {
        this.parseConfiguration(configuration);
    }

    public void parseConfiguration(String compOpString) {
        String configuration = compOpString.substring("opacityToHSL(".length(), compOpString.length() - 1);
        String[] parts = configuration.split(",");
        if (configuration == null || configuration.trim().length() == 0 || parts.length != 7) {
            this.log.error("parseConfiguration: no configuration or wrong configuration given which is most likely an error: " + configuration);
        }
        this.mediumOpacity = Float.parseFloat(parts[0]);
        this.lowHueScale = Float.parseFloat(parts[1]);
        this.highHueScale = Float.parseFloat(parts[2]);
        this.lowSaturationScale = Float.parseFloat(parts[3]);
        this.highSaturationScale = Float.parseFloat(parts[4]);
        this.lowLuminocityScale = Float.parseFloat(parts[5]);
        this.highLuminocityScale = Float.parseFloat(parts[6]);
    }

    @Override
    public boolean applyCompOp(RenderImageLayer topLayer, RenderImageLayer bottomLayer) {
        BufferedImage topImage = topLayer.getImage();
        WritableRaster topRaster = topImage.getRaster();
        BufferedImage bottomImage = bottomLayer.getImage();
        WritableRaster bottomRaster = bottomImage.getRaster();
        for (int x = 0; x < topImage.getWidth(); ++x) {
            for (int y = 0; y < topImage.getHeight(); ++y) {
                float[] topRgba = new float[4];
                topRgba = topRaster.getPixel(x, y, topRgba);
                float[] bottomRgba = new float[4];
                bottomRgba = bottomRaster.getPixel(x, y, bottomRgba);
                float[] bottomHsla = HslColor.fromRGBA0255(bottomRgba);
                float bottomHue = bottomHsla[0];
                float bottomSaturation = bottomHsla[1];
                float bottomLuminocity = bottomHsla[2];
                float topOpacity = topRgba[3];
                float alphaShift = topOpacity - this.mediumOpacity;
                if (alphaShift >= 0.0f) {
                    float newHue = bottomHue - alphaShift * this.highHueScale;
                    newHue = Math.max(0.0f, newHue);
                    bottomHsla[0] = newHue = Math.min(359.0f, newHue);
                    newSaturation = bottomSaturation - alphaShift * this.highSaturationScale;
                    newSaturation = Math.max(0.0f, newSaturation);
                    bottomHsla[1] = newSaturation = Math.min(100.0f, newSaturation);
                    newLuminocity = bottomLuminocity - alphaShift * this.highLuminocityScale;
                    newLuminocity = Math.max(0.0f, newLuminocity);
                    bottomHsla[2] = newLuminocity = Math.min(100.0f, newLuminocity);
                } else if (alphaShift < 0.0f) {
                    float newHue = bottomHue - alphaShift * this.lowHueScale;
                    newHue = Math.max(0.0f, newHue);
                    bottomHsla[0] = newHue = Math.min(359.0f, newHue);
                    newSaturation = bottomSaturation - alphaShift * this.lowSaturationScale;
                    newSaturation = Math.max(0.0f, newSaturation);
                    bottomHsla[1] = newSaturation = Math.min(100.0f, newSaturation);
                    newLuminocity = bottomLuminocity - alphaShift * this.lowLuminocityScale;
                    newLuminocity = Math.max(0.0f, newLuminocity);
                    bottomHsla[2] = newLuminocity = Math.min(100.0f, newLuminocity);
                }
                float[] newRGBA = HslColor.toRGBA0255(bottomHsla);
                bottomRaster.setPixel(x, y, newRGBA);
            }
        }
        boolean mergeLayerBackToBase = false;
        return mergeLayerBackToBase;
    }
}

