/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm;

import de.wideportal.maprender.config.xml.osm.OsmFont;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="FontSet")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OsmFontSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @XmlAttribute(name="name")
    private String name;
    @XmlElement(name="Font")
    private List<OsmFont> osmFonts = new ArrayList<OsmFont>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<OsmFont> getOsmFonts() {
        return this.osmFonts;
    }

    public void setOsmFonts(List<OsmFont> osmFonts) {
        this.osmFonts = osmFonts;
    }

    public Font getBestAvailableFont(Map<String, Font> loadedFonts, Optional<String> fontName, int faceStyle, int fontSize, String charToPrint) {
        if (fontName.isPresent()) {
            Font explicitFont = loadedFonts.get(fontName.get());
            if (explicitFont != null) {
                return explicitFont.deriveFont(faceStyle, fontSize);
            }
            this.log.warn("getBestAvailableFont(): Font-face " + fontName + " not available, fallback to next best font");
        }
        for (OsmFont osmFont : this.osmFonts) {
            Font loadedFont = loadedFonts.get(osmFont.getFaceName());
            if (loadedFont == null) continue;
            if (charToPrint != null && charToPrint.length() > 0) {
                if (!loadedFont.canDisplay(charToPrint.charAt(0))) continue;
                return loadedFont.deriveFont(faceStyle, fontSize);
            }
            return loadedFont.deriveFont(faceStyle, fontSize);
        }
        Font fallbackfond = new Font("Serif", faceStyle, fontSize);
        return fallbackfond;
    }

    public String toString() {
        return "OsmFontSet[name=" + this.name + ", osmFonts=" + this.osmFonts + "]";
    }
}

