/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import it.geosolutions.rendered.viewer.ImageTreeModel;
import it.geosolutions.rendered.viewer.ImageTreeRenderer;
import it.geosolutions.rendered.viewer.RenderedImageInfoPanel;
import it.geosolutions.rendered.viewer.StringifyUtilities;
import it.geosolutions.rendered.viewer.TextTreeBuilder;
import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import javax.media.jai.WarpAffine;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class RenderedImageBrowser
extends JPanel {
    private static final Map<Integer, String> TYPE_MAP = new HashMap<Integer, String>();
    private static final Logger LOGGER = Logger.getLogger(RenderedImageBrowser.class.toString());
    ImageTreeModel model;
    JTree imageTree;
    RenderedImageInfoPanel imageInfo;
    JSplitPane split;
    boolean showHistogram;
    boolean showRoi;

    public static void showChain(RenderedImage image, String title) {
        RenderedImageBrowser.showChain(image, true, true, title);
    }

    public static void showChain(RenderedImage image) {
        RenderedImageBrowser.showChain(image, "");
    }

    public static void showChain(RenderedImage image, boolean showHistogram) {
        RenderedImageBrowser.showChain(image, showHistogram, false);
    }

    public static void showChain(RenderedImage image, boolean showHistogram, boolean showRoi) {
        RenderedImageBrowser.showChain(image, showHistogram, showRoi, "");
    }

    public static String dumpChain(RenderedImage image) {
        return RenderedImageBrowser.dumpChain(image, false);
    }

    public static String dumpChain(RenderedImage image, boolean minimal) {
        TextTreeBuilder builder = new TextTreeBuilder();
        RenderedImageBrowser.dumpChain(image, builder, minimal, new int[]{0});
        return builder.toString();
    }

    private static void dumpChain(RenderedImage image, TextTreeBuilder builder, boolean minimal, int[] level) {
        ColorModel cm;
        SampleModel sm;
        String name;
        RenderedOp op;
        TileCache tcache = null;
        TileScheduler tscheduler = null;
        if (image instanceof RenderedOp) {
            String renderingName;
            String operationName;
            block19: {
                op = (RenderedOp)image;
                operationName = op.getOperationName();
                renderingName = "null";
                try {
                    op.getWidth();
                    renderingName = op.getCurrentRendering().getClass().getName();
                }
                catch (Exception ignored) {
                    Logger logger = Logger.getLogger(RenderedImageBrowser.class.toString());
                    if (!logger.isLoggable(Level.WARNING)) break block19;
                    logger.log(Level.WARNING, ignored.getMessage());
                }
            }
            name = "JAI op: " + operationName + '(' + renderingName + ')';
            tcache = (TileCache)op.getRenderingHint(JAI.KEY_TILE_CACHE);
            tscheduler = (TileScheduler)op.getRenderingHint(JAI.KEY_TILE_SCHEDULER);
        } else {
            name = "Non op: " + image.getClass();
        }
        builder.append(name + " at Level: " + level[0]);
        builder.append(", offset:");
        builder.append(image.getMinX() + ", " + image.getMinY());
        builder.append(", size:");
        builder.append(image.getWidth() + " x " + image.getHeight());
        builder.append(", tile size:" + image.getTileWidth() + " x " + image.getTileHeight());
        builder.newLine();
        if (image instanceof RenderedOp) {
            builder.append("Params. ");
            op = (RenderedOp)image;
            ParameterBlock block = op.getParameterBlock();
            Vector<Object> paramValues = block.getParameters();
            for (int i = 0; i < paramValues.size(); ++i) {
                String pname = "Parameter " + (i + 1);
                if (block instanceof ParameterBlockJAI) {
                    pname = ((ParameterBlockJAI)block).getParameterListDescriptor().getParamNames()[i];
                }
                builder.append(pname);
                builder.append(":");
                Object value = paramValues.get(i);
                RenderedImageBrowser.dumpValue(builder, value);
                builder.append("; ");
            }
            builder.newLine();
        }
        if ((sm = image.getSampleModel()) != null) {
            builder.append("Bands: " + sm.getNumBands() + ", type: " + TYPE_MAP.get(sm.getDataType()));
        }
        if ((cm = image.getColorModel()) != null) {
            builder.append("; Color model:" + cm.getClass());
            builder.append(", transparency: ");
            switch (cm.getTransparency()) {
                case 1: {
                    builder.append("Opaque");
                    break;
                }
                case 3: {
                    builder.append("Translucent");
                    break;
                }
                case 2: {
                    builder.append("Bitmask");
                }
            }
        }
        if (!minimal) {
            builder.newLine();
            builder.append("Tile cache: " + tcache);
            builder.newLine();
            builder.append("Tile scheduler: ");
            if (tscheduler == null) {
                builder.append("null");
            } else {
                builder.append(tscheduler + (tscheduler == JAI.getDefaultInstance().getTileScheduler() ? "<global>" : "<local>") + ", parallelism " + tscheduler.getParallelism() + ", priority " + tscheduler.getPriority());
            }
        }
        if (image.getSources() != null) {
            builder.newLine();
            builder.append("Number of sources: " + image.getSources().size());
            for (RenderedImage child : image.getSources()) {
                builder.newChild();
                level[0] = level[0] + 1;
                RenderedImageBrowser.dumpChain(child, builder, minimal, level);
                level[0] = level[0] - 1;
                builder.endChild();
            }
        }
    }

    private static void dumpValue(TextTreeBuilder builder, Object value) {
        if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            builder.append("[");
            for (int j = 0; j < length; ++j) {
                RenderedImageBrowser.dumpValue(builder, Array.get(value, j));
                if (j < length - 1) {
                    builder.append(", ");
                    continue;
                }
                builder.append("]");
            }
        } else if (value instanceof EnumeratedParameter) {
            String enumName = ((EnumeratedParameter)value).getName();
            builder.append(enumName);
        } else if (value instanceof Interpolation) {
            String interpName = value.getClass().getSimpleName();
            builder.append(interpName);
        } else if (value instanceof WarpAffine) {
            String warpAffineValue = StringifyUtilities.printWarpAffine((WarpAffine)value, true);
            builder.append(warpAffineValue);
        } else if (value instanceof ImageReadParam) {
            String param = StringifyUtilities.printImageReadParam((ImageReadParam)value, true);
            builder.append(param);
        } else {
            builder.append(String.valueOf(value));
        }
    }

    public static void showChain(RenderedImage image, boolean showHistogram, boolean showRoi, String title) {
        RenderedImageBrowser.showChain(image, showHistogram, showRoi, title, false);
    }

    public static void showChain(RenderedImage image, boolean showHistogram, boolean showRoi, String title, boolean waitOnClose) {
        String frameTitle = "Rendered image information tool";
        frameTitle = frameTitle + (title != null ? ": " + title : "");
        frameTitle = frameTitle + (waitOnClose ? "(Code is paused, close to continue)" : "");
        JFrame frame = new JFrame(frameTitle);
        RenderedImageBrowser info = new RenderedImageBrowser(showHistogram, showRoi);
        info.setImage(image);
        frame.setContentPane(info);
        frame.setSize(1024, 768);
        frame.setVisible(true);
        RenderedImageBrowser.doWait(frame, waitOnClose);
    }

    private static void doWait(final JFrame frame, boolean waitOnClose) {
        if (waitOnClose) {
            final Object lock = new Object();
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        while (frame.isVisible()) {
                            try {
                                lock.wait();
                            }
                            catch (InterruptedException e) {
                                LOGGER.fine(e.getLocalizedMessage());
                            }
                        }
                    }
                }
            };
            t.start();
            frame.addWindowListener(new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosing(WindowEvent arg0) {
                    Object object = lock;
                    synchronized (object) {
                        frame.setVisible(false);
                        lock.notify();
                    }
                }
            });
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.fine(e.getLocalizedMessage());
            }
        }
    }

    public RenderedImageBrowser() {
        this(true, false);
    }

    public RenderedImageBrowser(boolean showHistogram, boolean showRoi) {
        this.showHistogram = showHistogram;
        this.showRoi = showRoi;
        this.model = new ImageTreeModel();
        this.imageTree = new JTree(this.model);
        this.imageTree.setCellRenderer(new ImageTreeRenderer());
        this.imageTree.setShowsRootHandles(true);
        this.imageTree.putClientProperty("JTree.lineStyle", "Angled");
        this.imageInfo = new RenderedImageInfoPanel(showHistogram, showRoi);
        this.split = new JSplitPane();
        this.split.setLeftComponent(new JScrollPane(this.imageTree));
        this.split.setRightComponent(this.imageInfo);
        this.split.setResizeWeight(0.2);
        this.setLayout(new BorderLayout());
        this.add(this.split);
        this.imageTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectedpath = RenderedImageBrowser.this.imageTree.getSelectionPath();
                if (selectedpath == null) {
                    RenderedImageBrowser.this.imageTree.setSelectionRow(0);
                }
                RenderedImage image = (RenderedImage)RenderedImageBrowser.this.imageTree.getSelectionPath().getLastPathComponent();
                RenderedImageBrowser.this.imageInfo.setImage(image);
            }
        });
    }

    public static void showChainAndWaitOnClose(RenderedImage renderedImage) {
        RenderedImageBrowser.showChain(renderedImage, true, true, "renderedImage", true);
    }

    public void setImage(RenderedImage image) {
        int rc;
        this.model.setRoot(image);
        this.imageTree.setSelectionPath(new TreePath(image));
        do {
            for (int x = rc = this.imageTree.getRowCount(); x >= 0; --x) {
                this.imageTree.expandRow(x);
            }
        } while (rc != this.imageTree.getRowCount());
    }

    static {
        TYPE_MAP.put(0, "Byte");
        TYPE_MAP.put(5, "Double");
        TYPE_MAP.put(4, "Float");
        TYPE_MAP.put(3, "Int");
        TYPE_MAP.put(2, "Short");
        TYPE_MAP.put(32, "Undefined");
        TYPE_MAP.put(1, "Short");
    }
}

