/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.factory;

import java.awt.RenderingHints;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.geotools.util.Arguments;
import org.geotools.util.Classes;
import org.geotools.util.NullEntityResolver;
import org.geotools.util.PreventLocalEntityResolver;
import org.geotools.util.Utilities;
import org.geotools.util.Version;
import org.geotools.util.factory.FactoryIteratorProvider;
import org.geotools.util.factory.FactoryIteratorProviders;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.DefaultLoggerFactory;
import org.geotools.util.logging.LoggerAdapter;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;
import org.xml.sax.EntityResolver;

public final class GeoTools {
    private static final Properties PROPS = GeoTools.loadProperites("GeoTools.properties");
    private static final Version VERSION = new Version(PROPS.getProperty("version", "20-SNAPSHOT"));
    private static final String BUILD_REVISION = PROPS.getProperty("build.revision", "-1");
    private static final String BUILD_TIMESTAMP = PROPS.getProperty("build.timestamp", "");
    private static final EventListenerList LISTENERS = new EventListenerList();
    public static final String CRS_AUTHORITY_EXTRA_DIRECTORY = "org.geotools.referencing.crs-directory";
    public static final String EPSG_DATA_SOURCE = "org.geotools.referencing.epsg-datasource";
    public static final String FORCE_LONGITUDE_FIRST_AXIS_ORDER = "org.geotools.referencing.forceXY";
    public static final String FORCE_SRS_STYLE = "org.geotools.gml.forceSrsStyle";
    public static final String ENTITY_RESOLVER = "org.xml.sax.EntityResolver";
    public static final String RESAMPLE_TOLERANCE = "org.geotools.referencing.resampleTolerance";
    public static final String LOCAL_DATE_TIME_HANDLING = "org.geotools.localDateTimeHandling";
    public static final String DATE_TIME_FORMAT_HANDLING = "org.geotools.dateTimeFormatHandling";
    public static final String ENCODE_WKT = "org.geotools.ecql.ewkt";
    public static final String HTTP_CLIENT = "org.geotools.http.client";
    public static final String HTTP_LOGGING = "org.geotools.http.logging";
    private static InitialContext context;
    private static final Set<ClassLoader> addedClassLoaders;
    private static final Map<String, RenderingHints.Key> BINDINGS;
    public static final Predicate<String> DEFAULT_JNDI_VALIDATOR;
    private static Predicate<String> jndiValidator;

    private static Properties loadProperites(String resource) {
        Properties props = new Properties();
        InputStream stream = GeoTools.class.getResourceAsStream(resource);
        if (stream != null) {
            try (InputStream inputStream = stream;){
                try {
                    props.load(stream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return props;
    }

    private static void bind(String property, RenderingHints.Key key, Map<String, RenderingHints.Key> bindings) {
        RenderingHints.Key old = bindings.putIfAbsent(property, key);
        if (old != null) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "property", property));
        }
    }

    private GeoTools() {
    }

    public static String getAboutInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeoTools.getEnvironmentInfo());
        sb.append(String.format("%n", new Object[0]));
        sb.append(GeoTools.getGeoToolsJarInfo());
        return sb.toString();
    }

    public static String getEnvironmentInfo() {
        String newline = String.format("%n", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append("GeoTools version ").append(GeoTools.getVersion().toString());
        if (sb.toString().endsWith("SNAPSHOT")) {
            sb.append(" (built from r").append(GeoTools.getBuildRevision().toString()).append(")");
        }
        sb.append(newline).append("Java version: ");
        sb.append(System.getProperty("java.version"));
        sb.append(newline).append("Operating system: ");
        sb.append(System.getProperty("os.name")).append(' ').append(System.getProperty("os.version"));
        return sb.toString();
    }

    public static String getGeoToolsJarInfo() {
        StringBuilder sb = new StringBuilder();
        String newline = String.format("%n", new Object[0]);
        String indent = "    ";
        sb.append("GeoTools jars on classpath:");
        for (String jarName : GeoTools.getGeoToolsJars()) {
            sb.append(newline).append("    ").append(jarName);
        }
        return sb.toString();
    }

    private static List<String> getGeoToolsJars() {
        Pattern pattern = Pattern.compile(".*\\/" + GeoTools.getVersion() + "\\/(gt-.*jar$)");
        ArrayList<String> jarNames = new ArrayList<String>();
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(classpath, pathSep);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            Matcher matcher = pattern.matcher(path);
            if (!matcher.find()) continue;
            jarNames.add(matcher.group(1));
        }
        Collections.sort(jarNames);
        return jarNames;
    }

    public static String getBuildRevision() {
        return BUILD_REVISION;
    }

    public static String getBuildTimestamp() {
        return BUILD_TIMESTAMP;
    }

    public static Properties getBuildProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)PROPS);
        return props;
    }

    public static Version getVersion() {
        return VERSION;
    }

    public static Version getVersion(Class<?> type) {
        String name;
        URL classLocation = GeoTools.classLocation(type);
        String path = classLocation.toString();
        if (classLocation.getProtocol().equalsIgnoreCase("jar")) {
            String jarVersion = GeoTools.jarVersion(path);
            if (jarVersion != null) {
                return new Version(jarVersion);
            }
            try {
                URL manifestLocation = GeoTools.manifestLocation(path);
                Manifest manifest = new Manifest();
                try (InputStream content = manifestLocation.openStream();){
                    manifest.read(content);
                }
                for (String attribute : new String[]{"Implementation-Version", "Project-Version", "Specification-Version"}) {
                    String value = manifest.getMainAttributes().getValue(attribute);
                    if (value == null) continue;
                    return new Version(value);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((name = type.getName()).startsWith("org.geotools") || name.startsWith("org.opengis")) {
            return GeoTools.getVersion();
        }
        return null;
    }

    static URL classLocation(Class<?> type) {
        return type.getResource(type.getSimpleName() + ".class");
    }

    static String jarVersion(String classLocation) {
        String location;
        if (classLocation.startsWith("jar:") || classLocation.contains(".jar!")) {
            location = classLocation.substring(0, classLocation.lastIndexOf("!") + 1);
            String file = location.substring(location.lastIndexOf(File.pathSeparator) + 1);
            int dash = file.lastIndexOf("-");
            int dot = file.lastIndexOf(".jar");
            if (dash != -1 && dot != -1) {
                String version = file.substring(dash + 1, dot);
                if (version.startsWith("RC") || version.equals("SNAPSHOT")) {
                    dash = file.lastIndexOf("-", dash - 1);
                    version = file.substring(dash + 1, dot);
                }
                return version;
            }
        }
        if (classLocation.contains(".jar/")) {
            location = classLocation.substring(0, classLocation.indexOf(".jar/") + 4);
            int dash = location.lastIndexOf("-");
            int dot = location.lastIndexOf(".jar");
            if (dash != -1 && dot != -1) {
                return location.substring(dash + 1, dot);
            }
        }
        return null;
    }

    static URL manifestLocation(String classLocation) {
        if (classLocation.startsWith("jar:")) {
            try {
                URL url = new URL(classLocation.substring(0, classLocation.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF");
                return url;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (classLocation.contains(".jar/")) {
            String location = classLocation.substring(0, classLocation.indexOf(".jar/") + 4);
            try {
                URL url = new URL(location + "/META-INF/MANIFEST.MF");
                return url;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public static Manifest getManifest(Class<?> type) {
        String name;
        URL classLocation = GeoTools.classLocation(type);
        Manifest manifest = new Manifest();
        URL manifestLocation = GeoTools.manifestLocation(classLocation.toString());
        if (manifestLocation != null) {
            try (InputStream content2 = manifestLocation.openStream();){
                manifest.read(content2);
            }
            catch (IOException content2) {
                // empty catch block
            }
        }
        if (manifest.getMainAttributes().isEmpty() && ((name = type.getName()).startsWith("org.geotools") || name.startsWith("org.opengis") || name.startsWith("net.opengis"))) {
            String generated = "Manifest-Version: 1.0\nProject-Version: " + GeoTools.getVersion() + "\n";
            try {
                manifest.read(new ByteArrayInputStream(generated.getBytes()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return manifest;
    }

    public static void setLoggerFactory(LoggerFactory<?> factory) {
        Logging.ALL.setLoggerFactory(factory);
        if (factory == null || factory == DefaultLoggerFactory.getInstance()) {
            Logging.ALL.forceMonolineConsoleOutput();
        }
    }

    public static void init(Hints hints) {
        GeoTools.init();
        if (hints != null) {
            Hints.putSystemDefault(hints);
        }
    }

    public static void init() {
        if (Logging.ALL.getLoggerFactory() == null) {
            String[] CANDIDATES;
            for (String factoryName : CANDIDATES = new String[]{"org.geotools.util.logging.LogbackLoggerFactory", "org.geotools.util.logging.Log4J2LoggerFactory", "org.geotools.util.logging.Log4JLoggerFactory", "org.geotools.util.logging.CommonsLoggerFactory", "org.geotools.util.logging.DefaultLoggerFactory"}) {
                try {
                    Logger logger;
                    LoggerFactory<?> factory;
                    Logging.ALL.setLoggerFactory(factoryName);
                    if (factoryName != "org.geotools.util.logging.CommonsLoggerFactory" || (factory = Logging.ALL.getLoggerFactory()) == null || (logger = Logging.ALL.getLoggerFactory().getLogger("org.geotools")) instanceof LoggerAdapter) break;
                }
                catch (ClassNotFoundException classNotFound) {
                    // empty catch block
                }
            }
        }
        if (Logging.ALL.getLoggerFactory() == null || Logging.ALL.getLoggerFactory() == DefaultLoggerFactory.getInstance()) {
            Logging.ALL.forceMonolineConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(InitialContext initialContext) {
        Class<GeoTools> clazz = GeoTools.class;
        synchronized (GeoTools.class) {
            context = initialContext;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            GeoTools.fireConfigurationChanged();
            return;
        }
    }

    static boolean scanForSystemHints(Map<RenderingHints.Key, Object> hints) {
        boolean changed = false;
        for (Map.Entry<String, RenderingHints.Key> entry : BINDINGS.entrySet()) {
            Object old;
            String property;
            block12: {
                String propertyKey = entry.getKey();
                try {
                    property = System.getProperty(propertyKey);
                    if (property == null) {
                    }
                    break block12;
                }
                catch (SecurityException e) {
                    GeoTools.unexpectedException(e);
                }
                continue;
            }
            Object value = property;
            RenderingHints.Key hintKey = entry.getValue();
            if (hintKey.getClass().equals(Hints.Key.class)) {
                Class<?> type = ((Hints.Key)hintKey).getValueClass();
                if (type.equals(Boolean.class)) {
                    value = Boolean.valueOf(property);
                } else if (Number.class.isAssignableFrom(type)) {
                    try {
                        value = Classes.valueOf(type, property);
                    }
                    catch (NumberFormatException e) {
                        GeoTools.unexpectedException(e);
                        continue;
                    }
                }
            }
            try {
                old = hints.put(hintKey, value);
            }
            catch (IllegalArgumentException e) {
                GeoTools.unexpectedException(e);
                continue;
            }
            changed = changed || !Utilities.equals(old, value);
        }
        return changed;
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(Hints.class, "scanSystemProperties", exception);
    }

    public static Hints getDefaultHints() {
        return Hints.getDefaults(false);
    }

    public static Hints addDefaultHints(Hints hints) {
        Hints completed = GeoTools.getDefaultHints();
        if (hints != null) {
            completed.add(hints);
        }
        return completed;
    }

    public static EntityResolver getEntityResolver(Hints hints) {
        if (hints == null) {
            hints = GeoTools.getDefaultHints();
        }
        if (hints.containsKey(Hints.ENTITY_RESOLVER)) {
            Object hint = hints.get(Hints.ENTITY_RESOLVER);
            if (hint == null) {
                return NullEntityResolver.INSTANCE;
            }
            if (hint instanceof EntityResolver) {
                return (EntityResolver)hint;
            }
            if (hint instanceof String) {
                String className = (String)hint;
                return GeoTools.instantiate(className, EntityResolver.class, PreventLocalEntityResolver.INSTANCE);
            }
        }
        return PreventLocalEntityResolver.INSTANCE;
    }

    static <T, D extends T> T instantiate(String className, Class<T> type, D defaultValue) {
        if (className == null) {
            return defaultValue;
        }
        Logger LOGGER = Logging.getLogger(GeoTools.class);
        try {
            Class<?> kind = Class.forName(className);
            for (Field field : kind.getDeclaredFields()) {
                int modifier = field.getModifiers();
                if (!"INSTANCE".equals(field.getName()) || !Modifier.isStatic(modifier) || !Modifier.isPublic(modifier)) continue;
                try {
                    Object value = field.get(null);
                    if (value != null && value instanceof EntityResolver) {
                        return type.cast(value);
                    }
                    LOGGER.log(Level.FINER, "Unable to use ENTITY_RESOLVER: " + className + ".INSTANCE");
                }
                catch (Throwable t) {
                    LOGGER.log(Level.FINER, "Unable to instantiate ENTITY_RESOLVER: " + className + ".INSTANCE", t);
                }
                return defaultValue;
            }
            try {
                Object value = kind.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (type.isInstance(value)) {
                    return type.cast(value);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.log(Level.FINER, "Unable to instantiate ENTITY_RESOLVER: " + e.getMessage(), e);
            }
        }
        catch (ClassNotFoundException notFound) {
            LOGGER.log(Level.FINER, "Unable to instantiate ENTITY_RESOLVER: " + notFound.getMessage(), notFound);
        }
        return defaultValue;
    }

    @Deprecated
    public static synchronized InitialContext getInitialContext() throws NamingException {
        Logging.getLogger(GeoTools.class).severe("Please don't use GeoTools.getInitialContext(), perform lookups using GeoTools.jndiLookup(s) instead.");
        return GeoTools.getJNDIContext();
    }

    private static synchronized InitialContext getJNDIContext() throws NamingException {
        if (context == null) {
            try {
                context = new InitialContext();
            }
            catch (Exception e) {
                throw GeoTools.handleException(e);
            }
        }
        return context;
    }

    public static boolean isJNDIAvailable() {
        try {
            return GeoTools.getJNDIContext() != null;
        }
        catch (NamingException e) {
            return false;
        }
    }

    public static void setJNDINameValidator(Predicate<String> validator) {
        jndiValidator = validator;
    }

    public static Object jndiLookup(String name) throws NamingException {
        if (!jndiValidator.test(name)) {
            return null;
        }
        return GeoTools.getJNDIContext().lookup(name);
    }

    private static NamingException handleException(Exception e) {
        Logger LOGGER = Logging.getLogger(GeoTools.class);
        String propFileName = "jndi.properties";
        if (LOGGER.isLoggable(Level.WARNING)) {
            String javaHome;
            StringBuilder sb = new StringBuilder();
            sb.append("Error while retriving Initial Context.\n\n").append("Exception: ").append(e.getMessage()).append("\n");
            String contextFactory = System.getProperty("java.naming.factory.initial");
            sb.append("Factory could be taken from System property: ").append("java.naming.factory.initial").append("=").append(contextFactory == null ? "" : contextFactory).append("\n");
            Enumeration<URL> urls = AccessController.doPrivileged(new PrivilegedAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() {
                    try {
                        return ClassLoader.getSystemResources("jndi.properties");
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
            if (urls != null) {
                sb.append("Or from these property files:\n");
                while (urls.hasMoreElements()) {
                    sb.append(urls.nextElement().getPath()).append("\n");
                }
                sb.append("\n");
            }
            if ((javaHome = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        String javahome = System.getProperty("java.home");
                        if (javahome == null) {
                            return null;
                        }
                        String pathname = javahome + File.separator + "lib" + File.separator + "jndi.properties";
                        return pathname;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            })) != null) {
                sb.append("Or from a file specified by system property java.home:\n").append(javaHome).append("\n");
            }
            LOGGER.log(Level.WARNING, sb.toString());
        }
        NamingException throwing = new NamingException("Couldn't get Initial context.");
        throwing.setRootCause(e);
        return throwing;
    }

    public static synchronized void clearInitialContext() throws NamingException {
        if (context != null) {
            context.close();
        }
        context = null;
    }

    @Deprecated
    public static String fixName(String name) {
        return GeoTools.fixName(null, name, null);
    }

    @Deprecated
    public static String fixName(Context context, String name) {
        return context != null ? GeoTools.fixName(context, name, null) : name;
    }

    @Deprecated
    private static String fixName(Context context, String name, Hints hints) {
        String fixed = null;
        if (name != null) {
            StringTokenizer tokens = new StringTokenizer(name, ":/");
            while (tokens.hasMoreTokens()) {
                String part = tokens.nextToken();
                if (fixed == null) {
                    fixed = part;
                    continue;
                }
                try {
                    if (context == null) {
                        context = GeoTools.getInitialContext();
                    }
                    fixed = context.composeName(fixed, part);
                }
                catch (NamingException e) {
                    Logging.unexpectedException(GeoTools.class, "fixName", e);
                    return name;
                }
            }
        }
        return fixed;
    }

    public static void addFactoryIteratorProvider(FactoryIteratorProvider provider) {
        FactoryIteratorProviders.addFactoryIteratorProvider(provider);
    }

    public static void removeFactoryIteratorProvider(FactoryIteratorProvider provider) {
        FactoryIteratorProviders.removeFactoryIteratorProvider(provider);
    }

    public static void addChangeListener(ChangeListener listener) {
        GeoTools.removeChangeListener(listener);
        LISTENERS.add(ChangeListener.class, listener);
    }

    public static void removeChangeListener(ChangeListener listener) {
        LISTENERS.remove(ChangeListener.class, listener);
    }

    public static void fireConfigurationChanged() {
        ChangeEvent event = new ChangeEvent(GeoTools.class);
        Object[] listeners = LISTENERS.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static void addClassLoader(ClassLoader classLoader) {
        addedClassLoaders.add(classLoader);
        GeoTools.fireConfigurationChanged();
    }

    static Set<ClassLoader> getClassLoaders() {
        return addedClassLoaders;
    }

    public static void main(String ... args) {
        Arguments arguments = new Arguments(args);
        arguments.getRemainingArguments(0);
        arguments.out.print("GeoTools version ");
        arguments.out.println(GeoTools.getVersion());
        Hints hints = GeoTools.getDefaultHints();
        if (hints != null && !hints.isEmpty()) {
            arguments.out.println(hints);
        }
    }

    static {
        addedClassLoaders = Collections.synchronizedSet(new HashSet());
        HashMap<String, RenderingHints.Key> bindings = new HashMap<String, RenderingHints.Key>();
        GeoTools.bind(ENCODE_WKT, Hints.ENCODE_EWKT, bindings);
        GeoTools.bind(CRS_AUTHORITY_EXTRA_DIRECTORY, Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, bindings);
        GeoTools.bind(EPSG_DATA_SOURCE, Hints.EPSG_DATA_SOURCE, bindings);
        GeoTools.bind(FORCE_LONGITUDE_FIRST_AXIS_ORDER, Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, bindings);
        GeoTools.bind(ENTITY_RESOLVER, Hints.ENTITY_RESOLVER, bindings);
        GeoTools.bind(RESAMPLE_TOLERANCE, Hints.RESAMPLE_TOLERANCE, bindings);
        GeoTools.bind(LOCAL_DATE_TIME_HANDLING, Hints.LOCAL_DATE_TIME_HANDLING, bindings);
        GeoTools.bind(DATE_TIME_FORMAT_HANDLING, Hints.DATE_TIME_FORMAT_HANDLING, bindings);
        GeoTools.bind(HTTP_CLIENT, Hints.HTTP_CLIENT, bindings);
        GeoTools.bind(HTTP_LOGGING, Hints.HTTP_LOGGING, bindings);
        GeoTools.bind(FORCE_SRS_STYLE, Hints.FORCE_SRS_STYLE, bindings);
        BINDINGS = Collections.unmodifiableMap(bindings);
        DEFAULT_JNDI_VALIDATOR = name -> {
            Logger LOGGER = Logging.getLogger(GeoTools.class);
            try {
                boolean result;
                URI uri = new URI((String)name);
                boolean bl = result = uri.getScheme() == null || uri.getScheme().equals("java");
                if (!result) {
                    LOGGER.warning("JNDI lookup allowed only on java scheme, or no scheme. Found instead: " + name);
                }
                return result;
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, "Invalid JNDI name provided", e);
                return false;
            }
        };
        jndiValidator = DEFAULT_JNDI_VALIDATOR;
    }
}

