/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;

public class DefaultCRSFilterVisitor
extends DuplicatingFilterVisitor {
    private CoordinateReferenceSystem defaultCrs;

    public DefaultCRSFilterVisitor(FilterFactory factory, CoordinateReferenceSystem defaultCrs) {
        super(factory);
        this.defaultCrs = defaultCrs;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        ReferencedEnvelope envelope = ReferencedEnvelope.reference((Bounds)filter.getBounds());
        if (envelope != null && envelope.getCoordinateReferenceSystem() != null) {
            return super.visit(filter, extraData);
        }
        if (this.defaultCrs == null || filter.getBounds() == null || this.defaultCrs.getCoordinateSystem().getDimension() == filter.getBounds().getDimension()) {
            return this.getFactory(extraData).bbox(filter.getExpression1(), (BoundingBox)ReferencedEnvelope.create((Bounds)filter.getBounds(), this.defaultCrs));
        }
        try {
            SingleCRS horizontalCRS = CRS.getHorizontalCRS(this.defaultCrs);
            ReferencedEnvelope bounds = ReferencedEnvelope.create((Bounds)filter.getBounds(), (CoordinateReferenceSystem)horizontalCRS);
            return this.getFactory(extraData).bbox(filter.getExpression1(), (BoundingBox)bounds);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create filter with defaulted CRS", e);
        }
    }

    @Override
    public Object visit(Literal expression, Object extraData) {
        if (!(expression.getValue() instanceof Geometry)) {
            return super.visit(expression, extraData);
        }
        Geometry geom = (Geometry)expression.getValue();
        if (geom.getUserData() != null && geom.getUserData() instanceof CoordinateReferenceSystem) {
            return super.visit(expression, extraData);
        }
        Geometry clone = geom.getFactory().createGeometry(geom);
        clone.setUserData((Object)this.defaultCrs);
        return this.ff.literal((Object)clone);
    }
}

