/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.AttributeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Utilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;

public class GeometryAttributeImpl
extends AttributeImpl
implements GeometryAttribute {
    protected BoundingBox bounds;

    public GeometryAttributeImpl(Object content, GeometryDescriptor descriptor, Identifier id) {
        super(content, (AttributeDescriptor)descriptor, id);
    }

    public GeometryType getType() {
        return (GeometryType)super.getType();
    }

    public GeometryDescriptor getDescriptor() {
        return (GeometryDescriptor)super.getDescriptor();
    }

    public Geometry getValue() {
        return (Geometry)super.getValue();
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
        super.setValue(newValue);
    }

    public void setValue(Geometry geometry) {
        super.setValue(geometry);
    }

    public synchronized void setBounds(BoundingBox bbox) {
        this.bounds = bbox;
    }

    public synchronized BoundingBox getBounds() {
        if (this.bounds == null) {
            ReferencedEnvelope bbox = new ReferencedEnvelope(this.getType().getCoordinateReferenceSystem());
            Geometry geom = this.getValue();
            if (geom != null) {
                bbox.expandToInclude(geom.getEnvelopeInternal());
            } else {
                bbox.setToNull();
            }
            this.bounds = bbox;
        }
        return this.bounds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeometryAttributeImpl)) {
            return false;
        }
        GeometryAttributeImpl att = (GeometryAttributeImpl)o;
        if (!Utilities.equals((Object)this.descriptor, (Object)att.descriptor)) {
            return false;
        }
        if (!Utilities.equals((Object)this.id, (Object)att.id)) {
            return false;
        }
        if (this.value != null && att.value != null) {
            if (att.value instanceof GeometryCollection && !(att.value instanceof MultiPoint) && !(att.value instanceof MultiLineString) && !(att.value instanceof MultiPolygon)) {
                if (this.value instanceof GeometryCollection) {
                    GeometryCollection c1 = (GeometryCollection)this.value;
                    GeometryCollection c2 = (GeometryCollection)att.value;
                    if (c1.getNumGeometries() != c2.getNumGeometries()) {
                        return false;
                    }
                    for (int i = 0; i < c1.getNumGeometries(); ++i) {
                        Geometry g2;
                        Geometry g1 = c1.getGeometryN(i);
                        if (g1.equalsExact(g2 = c2.getGeometryN(i))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return ((Geometry)this.value).equalsExact((Geometry)att.value);
        }
        return Utilities.deepEquals((Object)this.value, (Object)this.value);
    }

    @Override
    public int hashCode() {
        int hash = this.descriptor.hashCode();
        if (this.id != null) {
            hash += 37 * this.id.hashCode();
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName()).append(":");
        sb.append(this.getDescriptor().getName().getLocalPart());
        CoordinateReferenceSystem crs = this.getDescriptor().getType().getCoordinateReferenceSystem();
        if (!this.getDescriptor().getName().getLocalPart().equals(this.getDescriptor().getType().getName().getLocalPart()) || this.id != null || crs != null) {
            sb.append("<");
            sb.append(this.getDescriptor().getType().getName().getLocalPart());
            if (this.id != null) {
                sb.append(" id=");
                sb.append(this.id);
            }
            if (crs != null) {
                sb.append(" crs=");
                sb.append(crs);
            }
            if (this.id != null) {
                sb.append(" id=");
                sb.append(this.id);
            }
            sb.append(">");
        }
        sb.append("=");
        sb.append(this.value);
        return sb.toString();
    }
}

