/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_JP = "Jap\u00e1n";
        final String metaValue_zbl = "Bliss jelk\u00e9prendszer";
        final String metaValue_Hant = "Hagyom\u00e1nyos";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "Ogam", "Ogham" },
            { "mwl", "mirand\u00e9z" },
            { "Zsym", "Szimb\u00f3lum" },
            { "cch", "atszam" },
            { "mwr", "m\u00e1rv\u00e1ri" },
            { "Tagb", "Tagbanwa" },
            { "Zsye", "Emoji" },
            { "%%NJIVA", "Gniva/Njiva t\u00e1jsz\u00f3l\u00e1s" },
            { "ccp", "csakma" },
            { "egy", "\u00f3egyiptomi" },
            { "raj", "radzsaszt\u00e1ni" },
            { "Phag", "Phags-pa" },
            { "tem", "temne" },
            { "teo", "tesz\u00f3" },
            { "rap", "rapanui" },
            { "ter", "teren\u00f3" },
            { "AC", "Ascension-sziget" },
            { "rar", "rarotongai" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Egyes\u00fclt Arab Em\u00edrs\u00e9gek" },
            { "nl_BE", "flamand" },
            { "AF", "Afganiszt\u00e1n" },
            { "AG", "Antigua \u00e9s Barbuda" },
            { "type.ca.ethiopic", "Eti\u00f3p napt\u00e1r" },
            { "AI", "Anguilla" },
            { "key.tz", "Id\u0151z\u00f3na" },
            { "AL", "Alb\u00e1nia" },
            { "AM", "\u00d6rm\u00e9nyorsz\u00e1g" },
            { "Teng", "Tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktisz" },
            { "AR", "Argent\u00edna" },
            { "Prti", "Feliratos parthian" },
            { "AS", "Amerikai Szamoa" },
            { "AT", "Ausztria" },
            { "AU", "Ausztr\u00e1lia" },
            { "AW", "Aruba" },
            { "en_US", "amerikai angol" },
            { "AX", "\u00c5land-szigetek" },
            { "mye", "myene" },
            { "AZ", "Azerbajdzs\u00e1n" },
            { "%%AREVELA", "Keleti \u00f6rm\u00e9ny" },
            { "BA", "Bosznia-Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "szebuano" },
            { "BD", "Banglades" },
            { "kum", "kum\u00fck" },
            { "BE", "Belgium" },
            { "gmh", "k\u00f6z\u00e9p fels\u0151 n\u00e9met" },
            { "Sogo", "\u00d3szogd" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulg\u00e1ria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzj\u00e1ny" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Holland Karib-t\u00e9rs\u00e9g" },
            { "BR", "Braz\u00edlia" },
            { "BS", "Bahama-szigetek" },
            { "xog", "szoga" },
            { "BT", "Bhut\u00e1n" },
            { "BV", "Bouvet-sziget" },
            { "BW", "Botswana" },
            { "BY", "Belarusz" },
            { "BZ", "Belize" },
            { "Visp", "L\u00e1that\u00f3 besz\u00e9d" },
            { "type.ca.persian", "Perzsa napt\u00e1r" },
            { "type.nu.hebr", "H\u00e9ber sz\u00e1mok" },
            { "CA", "Kanada" },
            { "CC", "K\u00f3kusz (Keeling)-szigetek" },
            { "mzn", "m\u00e1zander\u00e1ni" },
            { "CD", "Kong\u00f3 \u2013 Kinshasa" },
            { "CF", "K\u00f6z\u00e9p-afrikai K\u00f6zt\u00e1rsas\u00e1g" },
            { "CG", "Kong\u00f3 \u2013 Brazzaville" },
            { "CH", "Sv\u00e1jc" },
            { "CI", "Elef\u00e1ntcsontpart" },
            { "CK", "Cook-szigetek" },
            { "CL", "Chile" },
            { "Kthi", "Kaithi" },
            { "CM", "Kamerun" },
            { "CN", "K\u00edna" },
            { "CO", "Kolumbia" },
            { "CP", "Clipperton-sziget" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Z\u00f6ld-foki K\u00f6zt\u00e1rsas\u00e1g" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Kar\u00e1csony-sziget" },
            { "CY", "Ciprus" },
            { "CZ", "Csehorsz\u00e1g" },
            { "eka", "ekadzsuk" },
            { "Sogd", "Szogd" },
            { "DE", "N\u00e9metorsz\u00e1g" },
            { "goh", "\u00f3fels\u0151 n\u00e9met" },
            { "ace", "achin\u00e9z" },
            { "cgg", "kiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "D\u00e9van\u00e1gari sz\u00e1mjegyek" },
            { "DJ", "Dzsibuti" },
            { "DK", "D\u00e1nia" },
            { "ach", "akoli" },
            { "gon", "gondi" },
            { "Brai", "Vak\u00edr\u00e1s" },
            { "Brah", "Br\u00e1mi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "\u00d6rm\u00e9ny kisbet\u0171s sz\u00e1mok" },
            { "DO", "Dominikai K\u00f6zt\u00e1rsas\u00e1g" },
            { "gor", "gorontalo" },
            { "got", "g\u00f3t" },
            { "Mtei", "Meitei mayek" },
            { "zun", "zuni" },
            { "tig", "tigr\u00e9" },
            { "DZ", "Alg\u00e9ria" },
            { "pag", "pangaszinan" },
            { "type.d0.hwidth", "F\u00e9l sz\u00e9less\u00e9g" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta \u00e9s Melilla" },
            { "chb", "csibcsa" },
            { "pam", "pampangan" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "\u00c9sztorsz\u00e1g" },
            { "tiv", "tiv" },
            { "EG", "Egyiptom" },
            { "EH", "Nyugat-Szahara" },
            { "chg", "csagat\u00e1j" },
            { "pau", "palaui" },
            { "chk", "csuk\u00e9z" },
            { "chn", "csinuk zsargon" },
            { "chm", "mari" },
            { "chp", "csipev\u00e9" },
            { "cho", "csokt\u00f3" },
            { "chr", "cseroki" },
            { "ER", "Eritrea" },
            { "ES", "Spanyolorsz\u00e1g" },
            { "ET", "Eti\u00f3pia" },
            { "EU", "Eur\u00f3pai Uni\u00f3" },
            { "elx", "elamit" },
            { "type.ca.gregorian", "Gergely-napt\u00e1r" },
            { "EZ", "Eur\u00f3z\u00f3na" },
            { "chy", "csejen" },
            { "type.nu.gujr", "Gudzsar\u00e1ti sz\u00e1mjegyek" },
            { "Inds", "Indus" },
            { "ady", "adyghe" },
            { "FI", "Finnorsz\u00e1g" },
            { "FJ", "Fidzsi" },
            { "FK", "Falkland-szigetek" },
            { "FM", "Mikron\u00e9zia" },
            { "key.va", "F\u00f6ldrajzi helyvari\u00e1ns" },
            { "FO", "Fer\u00f6er szigetek" },
            { "Taml", "Tamil" },
            { "FR", "Franciaorsz\u00e1g" },
            { "tkl", "tokelaui" },
            { "grb", "greb\u00f3" },
            { "type.ca.indian", "Indiai nemzeti napt\u00e1r" },
            { "grc", "\u00f3g\u00f6r\u00f6g" },
            { "GA", "Gabon" },
            { "vot", "votj\u00e1k" },
            { "GB", "Egyes\u00fclt Kir\u00e1lys\u00e1g" },
            { "pcm", "nig\u00e9riai pidgin" },
            { "GD", "Grenada" },
            { "GE", "Gr\u00fazia" },
            { "GF", "Francia Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Gh\u00e1na" },
            { "Tale", "Tai Le" },
            { "GI", "Gibralt\u00e1r" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f6nland" },
            { "enm", "k\u00f6z\u00e9p angol" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Egyenl\u00edt\u0151i-Guinea" },
            { "GR", "G\u00f6r\u00f6gorsz\u00e1g" },
            { "GS", "D\u00e9li-Georgia \u00e9s D\u00e9li-Sandwich-szigetek" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Bissau-Guinea" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "\u00daj tai lue" },
            { "GY", "Guyana" },
            { "ckb", "k\u00f6z\u00e9p-\u00e1zsiai kurd" },
            { "zxx", "nincs nyelv\u00e9szeti tartalom" },
            { "de_AT", "osztr\u00e1k n\u00e9met" },
            { "HK", "Hongkong KKT" },
            { "Vaii", "Vai" },
            { "HM", "Heard-sziget \u00e9s McDonald-szigetek" },
            { "HN", "Honduras" },
            { "HR", "Horv\u00e1torsz\u00e1g" },
            { "agq", "agem" },
            { "gsw", "sv\u00e1jci n\u00e9met" },
            { "type.ca.islamic-umalqura", "Iszl\u00e1m Umm al-Qura napt\u00e1r" },
            { "HT", "Haiti" },
            { "HU", "Magyarorsz\u00e1g" },
            { "tmh", "tamasek" },
            { "IC", "Kan\u00e1ri-szigetek" },
            { "nan", "min nan k\u00ednai" },
            { "ID", "Indon\u00e9zia" },
            { "peo", "\u00f3perzsa" },
            { "IE", "\u00cdrorsz\u00e1g" },
            { "nap", "n\u00e1polyi" },
            { "%%NDYUKA", "Ndyuka dialektus" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "Izrael" },
            { "IM", "Man-sziget" },
            { "IN", "India" },
            { "type.co.eor", "Eur\u00f3pai rendez\u00e9si szab\u00e1lyok" },
            { "IO", "Brit Indiai-\u00f3ce\u00e1ni Ter\u00fclet" },
            { "IQ", "Irak" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Izland" },
            { "IT", "Olaszorsz\u00e1g" },
            { "Zmth", "Matematikai jelrendszer" },
            { "type.nu.thai", "Thai sz\u00e1mjegyek" },
            { "%%POSIX", "Sz\u00e1m\u00edt\u00f3g\u00e9p" },
            { "type.nu.beng", "Beng\u00e1li sz\u00e1mjegyek" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Iszl\u00e1m napt\u00e1r" },
            { "JM", "Jamaica" },
            { "Beng", "Beng\u00e1li" },
            { "JO", "Jord\u00e1nia" },
            { "JP", metaValue_JP },
            { "%%1606NICT", "K\u00e9s\u0151i k\u00f6z\u00e9p francia 1606-ig" },
            { "ain", "ainu" },
            { "guz", "guszii" },
            { "tog", "nyugati nyasza" },
            { "type.nu.knda", "Kannada sz\u00e1mjegyek" },
            { "Kali", "Kajah li" },
            { "Sidd", "Sziddham" },
            { "de_CH", "sv\u00e1jci feln\u00e9met" },
            { "type.co.phonetic", "Fonetikus rendez\u00e9si sorrend" },
            { "type.ca.buddhist", "Buddhista napt\u00e1r" },
            { "KE", "Kenya" },
            { "419", "Latin-Amerika" },
            { "KG", "Kirgiziszt\u00e1n" },
            { "KH", "Kambodzsa" },
            { "KI", "Kiribati" },
            { "KM", "Comore-szigetek" },
            { "KN", "Saint Kitts \u00e9s Nevis" },
            { "Knda", "Kannada" },
            { "Zinh", "Sz\u00e1rmaztatott" },
            { "fr_CA", "kanadai francia" },
            { "KP", "\u00c9szak-Korea" },
            { "KR", "D\u00e9l-Korea" },
            { "Plrd", "Pollard fonetikus" },
            { "fr_CH", "sv\u00e1jci francia" },
            { "KW", "Kuvait" },
            { "tpi", "tok pisin" },
            { "KY", "Kajm\u00e1n-szigetek" },
            { "KZ", "Kazahszt\u00e1n" },
            { "Cyrl", "Cirill" },
            { "LA", "Laosz" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "phn", "f\u0151niciai" },
            { "Cyrs", "\u00d3egyh\u00e1zi szl\u00e1v cirill" },
            { "gwi", "gvicsin" },
            { "%%LUNA1918", "Luna1918" },
            { "nds", "als\u00f3n\u00e9met" },
            { "LI", "Liechtenstein" },
            { "LK", "Sr\u00ed Lanka" },
            { "akk", "akk\u00e1d" },
            { "cop", "kopt" },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lesotho" },
            { "Phlv", "K\u00f6nyv pahlavi" },
            { "LT", "Litv\u00e1nia" },
            { "LU", "Luxemburg" },
            { "LV", "Lettorsz\u00e1g" },
            { "Kana", "Katakana" },
            { "LY", "L\u00edbia" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "%%LAUKIKA", "Laukika" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "Thaana" },
            { "MA", "Marokk\u00f3" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegr\u00f3" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaszk\u00e1r" },
            { "MH", "Marshall-szigetek" },
            { "ale", "aleut" },
            { "Thai", "Thai" },
            { "type.nu.vaii", "Vai sz\u00e1mjegyek" },
            { "MK", "\u00c9szak-Maced\u00f3nia" },
            { "ML", "Mali" },
            { "MM", "Mianmar" },
            { "MN", "Mong\u00f3lia" },
            { "new", "nevari" },
            { "MO", "Maka\u00f3 KKT" },
            { "MP", "\u00c9szaki Mariana-szigetek" },
            { "MQ", "Martinique" },
            { "MR", "Maurit\u00e1nia" },
            { "MS", "Montserrat" },
            { "MT", "M\u00e1lta" },
            { "type.m0.ungegn", "UNGEGN" },
            { "MU", "Mauritius" },
            { "alt", "d\u00e9l-altaji" },
            { "MV", "Mald\u00edv-szigetek" },
            { "MW", "Malawi" },
            { "MX", "Mexik\u00f3" },
            { "type.ca.japanese", "Jap\u00e1n napt\u00e1r" },
            { "MY", "Malajzia" },
            { "MZ", "Mozambik" },
            { "Phli", "Felriatos pahlavi" },
            { "NA", "Nam\u00edbia" },
            { "202", "Szubszaharai Afrika" },
            { "type.ca.hebrew", "H\u00e9ber napt\u00e1r" },
            { "type.co.dictionary", "Sz\u00f3t\u00e1ri rendez\u00e9si sorrend" },
            { "NC", "\u00daj-Kaled\u00f3nia" },
            { "%%WADEGILE", "Wade-Giles \u00e1t\u00edr\u00e1s" },
            { "%%UCRCOR", "Egyes\u00edtett \u00e1tdolgozott helyes\u00edr\u00e1s" },
            { "NE", "Niger" },
            { "NF", "Norfolk-sziget" },
            { "NG", "Nig\u00e9ria" },
            { "trv", "tarok\u00f3" },
            { "Phlp", "Psalter pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh hmong" },
            { "NL", "Hollandia" },
            { "NO", "Norv\u00e9gia" },
            { "NP", "Nep\u00e1l" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "F\u0151niciai" },
            { "rof", "rombo" },
            { "tsi", "csimsi\u00e1ni" },
            { "NZ", "\u00daj-Z\u00e9land" },
            { "rom", "roma" },
            { "Mero", "Meroitikus" },
            { "crh", "kr\u00edmi tat\u00e1r" },
            { "ang", "\u00f3angol" },
            { "OM", "Om\u00e1n" },
            { "%%PETR1708", "Petr1708" },
            { "anp", "angika" },
            { "crs", "szeszelva kreol francia" },
            { "Xpeo", "\u00d3perzsa" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Iszl\u00e1m civil napt\u00e1r" },
            { "csb", "kasub" },
            { "en_GB", "brit angol" },
            { "PE", "Peru" },
            { "PF", "Francia Polin\u00e9zia" },
            { "PG", "P\u00e1pua \u00daj-Guinea" },
            { "PH", "F\u00fcl\u00f6p-szigetek" },
            { "PK", "Pakiszt\u00e1n" },
            { "PL", "Lengyelorsz\u00e1g" },
            { "ewo", "evondo" },
            { "PM", "Saint-Pierre \u00e9s Miquelon" },
            { "PN", "Pitcairn-szigetek" },
            { "PR", "Puerto Rico" },
            { "PS", "Palesztin Auton\u00f3mia" },
            { "Bali", "Balin\u00e9z" },
            { "PT", "Portug\u00e1lia" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "G\u00f6r\u00f6g kisbet\u0171s sz\u00e1mok" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", "H\u00e9ber" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "Sk\u00f3t szabv\u00e1nyos angol" },
            { "niu", "niuei" },
            { "QO", "K\u00fcls\u0151-\u00d3ce\u00e1nia" },
            { "lez", "lezg" },
            { "%%FONUPA", "UPA fonetika" },
            { "tvl", "tuvalu" },
            { "Tavt", "Tai viet" },
            { "001", "Vil\u00e1g" },
            { "002", "Afrika" },
            { "003", "\u00c9szak-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "D\u00e9l-Amerika" },
            { "jbo", "lojban" },
            { "Rjng", "Redzsang" },
            { "009", "\u00d3ce\u00e1nia" },
            { "%%SURSILV", "Sursilv" },
            { "RO", "Rom\u00e1nia" },
            { "RS", "Szerbia" },
            { "RU", "Oroszorsz\u00e1g" },
            { "RW", "Ruanda" },
            { "Mani", "Manicheus" },
            { "Ugar", "Ugari" },
            { "Khar", "Kharoshthi" },
            { "SA", "Sza\u00fad-Ar\u00e1bia" },
            { "pon", "pohnpei" },
            { "Mand", "Mandai" },
            { "SB", "Salamon-szigetek" },
            { "twq", "szav\u00e1k" },
            { "011", "Nyugat-Afrika" },
            { "SC", "Seychelle-szigetek" },
            { "SD", "Szud\u00e1n" },
            { "013", "K\u00f6z\u00e9p-Amerika" },
            { "SE", "Sv\u00e9dorsz\u00e1g" },
            { "014", "Kelet-Afrika" },
            { "arc", "ar\u00e1mi" },
            { "015", "\u00c9szak-Afrika" },
            { "SG", "Szingap\u00far" },
            { "SH", "Szent Ilona" },
            { "type.lb.strict", "Sz\u0171k st\u00edlus\u00fa sort\u00f6r\u00e9s" },
            { "017", "K\u00f6z\u00e9p-Afrika" },
            { "SI", "Szlov\u00e9nia" },
            { "018", "Afrika d\u00e9li r\u00e9sze" },
            { "SJ", "Svalbard \u00e9s Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Szlov\u00e1kia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Szeneg\u00e1l" },
            { "SO", "Szom\u00e1lia" },
            { "arn", "mapucse" },
            { "arp", "arapaho" },
            { "type.nu.taml", "Hagyom\u00e1nyos tamil sz\u00e1mjegyek" },
            { "SR", "Suriname" },
            { "SS", "D\u00e9l-Szud\u00e1n" },
            { "ST", "S\u00e3o Tom\u00e9 \u00e9s Pr\u00edncipe" },
            { "SV", "Salvador" },
            { "ars", "nedzsdi arab" },
            { "SX", "Sint Maarten" },
            { "SY", "Sz\u00edria" },
            { "yao", "ja\u00f3" },
            { "SZ", "Szv\u00e1zif\u00f6ld" },
            { "arw", "aravak" },
            { "yap", "japi" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "Amerikai m\u00e9rt\u00e9kegys\u00e9grendszer" },
            { "021", "Amerika \u00e9szaki r\u00e9sze" },
            { "TC", "Turks- \u00e9s Caicos-szigetek" },
            { "yav", "jangben" },
            { "TD", "Cs\u00e1d" },
            { "Qaag", "Zawgyi" },
            { "TF", "Francia D\u00e9li Ter\u00fcletek" },
            { "TG", "Togo" },
            { "TH", "Thaif\u00f6ld" },
            { "TJ", "T\u00e1dzsikiszt\u00e1n" },
            { "029", "Karib-t\u00e9rs\u00e9g" },
            { "TK", "Tokelau" },
            { "TL", "Kelet-Timor" },
            { "ybb", "jemba" },
            { "type.co.searchjl", "Keres\u00e9s hangul kezd\u0151 m\u00e1ssalhangz\u00f3 szerint" },
            { "TM", "T\u00fcrkmeniszt\u00e1n" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tun\u00e9zia" },
            { "TO", "Tonga" },
            { "TR", "T\u00f6r\u00f6korsz\u00e1g" },
            { "TT", "Trinidad \u00e9s Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "ast", "aszt\u00far" },
            { "Orkh", "Orhon" },
            { "TZ", "Tanz\u00e1nia" },
            { "nmg", "ngumba" },
            { "Zzzz", "Ismeretlen \u00edr\u00e1srendszer" },
            { "UA", "Ukrajna" },
            { "rup", "arom\u00e1n" },
            { "030", "Kelet-\u00c1zsia" },
            { "tyv", "tuvai" },
            { "sw_CD", "kong\u00f3i szuah\u00e9li" },
            { "034", "D\u00e9l-\u00c1zsia" },
            { "hai", "haida" },
            { "035", "D\u00e9lkelet-\u00c1zsia" },
            { "UG", "Uganda" },
            { "hak", "hakka k\u00ednai" },
            { "type.co.pinyin", "Pinyin sorrend" },
            { "039", "D\u00e9l-Eur\u00f3pa" },
            { "Sinh", "Szingal\u00e9z" },
            { "UM", "Az USA lakatlan k\u00fclbirtokai" },
            { "UN", "Egyes\u00fclt Nemzetek Szervezete" },
            { "US", "Egyes\u00fclt \u00c1llamok" },
            { "haw", "hawaii" },
            { "%%1959ACAD", "Akad\u00e9miai" },
            { "type.co.gb2312han", "Egyszer\u0171s\u00edtett k\u00ednai sorrend - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "porosz" },
            { "UZ", "\u00dczbegiszt\u00e1n" },
            { "tzm", "k\u00f6z\u00e9p-atlaszi tamazigt" },
            { "type.co.stroke", "Von\u00e1ssorrend" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatik\u00e1n" },
            { "pro", "\u00f3prov\u00e1nszi" },
            { "VC", "Saint Vincent \u00e9s a Grenadine-szigetek" },
            { "VE", "Venezuela" },
            { "VG", "Brit Virgin-szigetek" },
            { "VI", "Amerikai Virgin-szigetek" },
            { "VN", "Vietn\u00e1m" },
            { "VU", "Vanuatu" },
            { "nog", "nogaj" },
            { "rwk", "rwo" },
            { "non", "\u00f3skandin\u00e1v" },
            { "053", "Ausztr\u00e1l\u00e1zsia" },
            { "%%AREVMDA", "Nyugati \u00f6rm\u00e9ny" },
            { "054", "Melan\u00e9zia" },
            { "WF", "Wallis \u00e9s Futuna" },
            { "type.co.traditional", metaValue_Hant },
            { "057", "Mikron\u00e9ziai r\u00e9gi\u00f3" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "type.nu.finance", "P\u00e9nz\u00fcgyi sz\u00e1mok" },
            { "%%HEPBURN", "Hepburn romaniz\u00e1ci\u00f3" },
            { "type.co.compat", "El\u0151z\u0151 rendez\u00e9si sorrend a kompatibilit\u00e1s \u00e9rdek\u00e9ben" },
            { "wae", "walser" },
            { "WS", "Szamoa" },
            { "wal", "valamo" },
            { "was", "vas\u00f3" },
            { "XA", "Pszeudo-nyelvj\u00e1r\u00e1sok" },
            { "war", "vara\u00f3" },
            { "XB", "Pszeudo-k\u00e9tir\u00e1ny\u00fa" },
            { "awa", "aw\u00e1di" },
            { "061", "Polin\u00e9zia" },
            { "XK", "Koszov\u00f3" },
            { "Gujr", "Gudzsar\u00e1ti" },
            { "Zxxx", "\u00cdratlan nyelvek k\u00f3dja" },
            { "Olck", "Ol chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", "n\u2019k\u00f3" },
            { "type.co.standard", "Norm\u00e1l rendez\u00e9si sorrend" },
            { "fan", "fang" },
            { "%%ROZAJ", "Rezij\u00e1n" },
            { "%%SUTSILV", "Sutsilv" },
            { "fat", "fanti" },
            { "Sgnw", "Jel\u00edr\u00e1s" },
            { "YT", "Mayotte" },
            { "ZA", "D\u00e9l-afrikai K\u00f6zt\u00e1rsas\u00e1g" },
            { "type.lb.loose", "T\u00e1g st\u00edlus\u00fa sort\u00f6r\u00e9s" },
            { "Deva", "Devanag\u00e1ri" },
            { "type.nu.geor", "Gr\u00faz sz\u00e1mok" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "pinjin \u00e1t\u00edr\u00e1s" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Ismeretlen k\u00f6rzet" },
            { "Runr", "Runikus" },
            { "type.ms.metric", "M\u00e9terrendszer" },
            { "type.ca.iso8601", "ISO-8601 napt\u00e1r" },
            { "lol", "mong\u00f3" },
            { "nso", "\u00e9szaki szeszot\u00f3" },
            { "type.nu.telu", "Telugu sz\u00e1mjegyek" },
            { "lou", "louisianai kreol" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "Egyszer\u0171s\u00edtett k\u00ednai p\u00e9nz\u00fcgyi sz\u00e1mok" },
            { "hil", "ilokano" },
            { "type.nu.arabext", "Kib\u0151v\u00edtett arab-indiai sz\u00e1mjegyek" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "Teljes sz\u00e9less\u00e9g\u0171 sz\u00e1mjegyek" },
            { "hit", "hittite" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "Maya", "Maja hieroglif\u00e1k" },
            { "lrc", "\u00e9szaki luri" },
            { "type.co.emoji", "Emodzsi rendez\u00e9si sorrend" },
            { "Copt", "Kopt" },
            { "nwc", "klasszikus newari" },
            { "udm", "udmurt" },
            { "Khmr", "Khmer" },
            { "Limb", "Limbu" },
            { "sad", "szandave" },
            { "type.nu.roman", "R\u00f3mai sz\u00e1mok" },
            { "sah", "szaha" },
            { "sam", "szamarit\u00e1nus ar\u00e1mi" },
            { "%%SCOUSE", "Scouse" },
            { "saq", "szamburu" },
            { "sas", "sasak" },
            { "sat", "szant\u00e1li" },
            { "Tfng", "Berber" },
            { "jpr", "zsid\u00f3-perzsa" },
            { "type.d0.npinyin", "Sz\u00e1m" },
            { "type.nu.native", "Nat\u00edv sz\u00e1mjegyek" },
            { "sba", "ngambay" },
            { "Guru", "Gurmuki" },
            { "%%ALUKU", "Aluku dialektus" },
            { "lua", "luba-lulua" },
            { "%%BISCAYAN", "Biszkajan" },
            { "type.d0.fwidth", "Teljes sz\u00e9less\u00e9g" },
            { "sbp", "szangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamv\u00e9zi" },
            { "lun", "lunda" },
            { "nyo", "nyor\u00f3" },
            { "luo", "luo" },
            { "fil", "filipp\u00edn\u00f3" },
            { "hmn", "hmong" },
            { "del", "delav\u00e1r" },
            { "lus", "lushai" },
            { "bal", "balucsi" },
            { "den", "szlevi" },
            { "ban", "balin\u00e9z" },
            { "uga", "ugariti" },
            { "luy", "lujia" },
            { "bas", "basza" },
            { "bax", "bamun" },
            { "jrb", "zsid\u00f3-arab" },
            { "es_ES", "eur\u00f3pai spanyol" },
            { "nzi", "nzima" },
            { "sco", "sk\u00f3t" },
            { "scn", "szic\u00edliai" },
            { "aa", "afar" },
            { "ab", "abh\u00e1z" },
            { "Aran", "Nasztalik" },
            { "ae", "aveszt\u00e1n" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "gomala" },
            { "am", "amhara" },
            { "an", "aragon\u00e9z" },
            { "Arab", "Arab" },
            { "%%SOLBA", "Stolvizza/Solbica t\u00e1jsz\u00f3l\u00e1s" },
            { "Jpan", metaValue_JP },
            { "ar", "arab" },
            { "Hrkt", "Katakana vagy hiragana" },
            { "as", "assz\u00e1mi" },
            { "Lina", "Line\u00e1ris A" },
            { "av", "avar" },
            { "Linb", "Line\u00e1ris B" },
            { "sdh", "d\u00e9l-kurd" },
            { "ay", "ajmara" },
            { "az", "azerbajdzs\u00e1ni" },
            { "%%OSOJS", "Oseacco/Osojane t\u00e1jsz\u00f3l\u00e1s" },
            { "ba", "bask\u00edr" },
            { "type.co.unihan", "Sz\u00f3t\u0151von\u00e1s rendez\u00e9si sorrend" },
            { "be", "belarusz" },
            { "bg", "bolg\u00e1r" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bangla" },
            { "bo", "tibeti" },
            { "dgr", "dogrib" },
            { "br", "breton" },
            { "bs", "bosny\u00e1k" },
            { "see", "szeneka" },
            { "Mymr", "Burmai" },
            { "type.nu.laoo", "Lao sz\u00e1mjegyek" },
            { "seh", "szena" },
            { "Nkoo", "N\u2019ko" },
            { "sel", "sz\u00f6lkup" },
            { "ca", "katal\u00e1n" },
            { "ses", "kojra-szenni" },
            { "ce", "csecsen" },
            { "ch", "csamor\u00f3" },
            { "%%REVISED", "\u00c1tdolgozott helyes\u00edr\u00e1s" },
            { "co", "korzikai" },
            { "Orya", "Oriya" },
            { "cr", "kr\u00ed" },
            { "cs", "cseh" },
            { "cu", "egyh\u00e1zi szl\u00e1v" },
            { "cv", "csuvas" },
            { "cy", "walesi" },
            { "type.nu.ethi", "Eti\u00f3p sz\u00e1mok" },
            { "Yiii", "Ji" },
            { "da", "d\u00e1n" },
            { "pt_PT", "eur\u00f3pai portug\u00e1l" },
            { "de", "n\u00e9met" },
            { "type.cf.standard", "Norm\u00e1l p\u00e9nznemform\u00e1tum" },
            { "bej", "bedzsa" },
            { "din", "dinka" },
            { "Bugi", "Bugin\u00e9z" },
            { "bem", "bemba" },
            { "sga", "\u00f3\u00edr" },
            { "type.nu.mong", "Mongol sz\u00e1mjegyek" },
            { "dv", "divehi" },
            { "es_419", "latin-amerikai spanyol" },
            { "dz", "dzsonga" },
            { "bez", "bena" },
            { "type.ca.chinese", "K\u00ednai napt\u00e1r" },
            { "dje", "zarma" },
            { "type.nu.grek", "G\u00f6r\u00f6g sz\u00e1mok" },
            { "ee", "eve" },
            { "bfd", "bafut" },
            { "type.lb.normal", "Norm\u00e1l st\u00edlus\u00fa sort\u00f6r\u00e9s" },
            { "ro_MD", "moldvai" },
            { "el", "g\u00f6r\u00f6g" },
            { "en", "angol" },
            { "eo", "eszperant\u00f3" },
            { "type.co.big5han", "Hagyom\u00e1nyos k\u00ednai sorrend - Big5" },
            { "es", "spanyol" },
            { "et", "\u00e9szt" },
            { "Hanb", "Han bopomof\u00f3val" },
            { "eu", "baszk" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Szamarit\u00e1n" },
            { "shi", "tachelhit" },
            { "hsb", "fels\u0151-szorb" },
            { "Hani", "Han" },
            { "%%ULSTER", "Ulster" },
            { "shn", "san" },
            { "Hano", "Hanunoo" },
            { "fa", "perzsa" },
            { "Hans", "Egyszer\u0171s\u00edtett" },
            { "type.nu.latn", "Nyugati sz\u00e1mjegyek" },
            { "Hant", metaValue_Hant },
            { "ff", "fulani" },
            { "shu", "cs\u00e1di arab" },
            { "hsn", "xiang k\u00ednai" },
            { "fi", "finn" },
            { "fj", "fidzsi" },
            { "fon", "fon" },
            { "bgn", "nyugati beludzs" },
            { "yue", "kantoni" },
            { "fo", "fer\u00f6eri" },
            { "type.m0.bgn", "BGN" },
            { "umb", "umbundu" },
            { "fr", "francia" },
            { "sid", "szidam\u00f3" },
            { "fy", "nyugati fr\u00edz" },
            { "ga", "\u00edr" },
            { "gd", "sk\u00f3ciai kelta" },
            { "gl", "gallego" },
            { "gn", "guarani" },
            { "bho", "bodzspuri" },
            { "und", "ismeretlen nyelv" },
            { "type.ca.ethiopic-amete-alem", "Eti\u00f3p amete alem napt\u00e1r" },
            { "gu", "gudzsar\u00e1ti" },
            { "gv", "man-szigeti" },
            { "ha", "hausza" },
            { "he", "h\u00e9ber" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "horv\u00e1t" },
            { "ht", "haiti kreol" },
            { "hu", "magyar" },
            { "hy", "\u00f6rm\u00e9ny" },
            { "hz", "herero" },
            { "frc", "cajun francia" },
            { "%%FONIPA", "IPA fonetika" },
            { "ia", "interlingva" },
            { "Jamo", "Jamo" },
            { "id", "indon\u00e9z" },
            { "type.nu.tibt", "Tibeti sz\u00e1mjegyek" },
            { "ie", "interlingue" },
            { "ig", "igb\u00f3" },
            { "ii", "szecsu\u00e1n ji" },
            { "frm", "k\u00f6z\u00e9p francia" },
            { "%%RUMGR", "Rumgr" },
            { "ik", "inupiak" },
            { "fro", "\u00f3francia" },
            { "io", "id\u00f3" },
            { "frs", "keleti fr\u00edz" },
            { "frr", "\u00e9szaki fr\u00edz" },
            { "is", "izlandi" },
            { "it", "olasz" },
            { "iu", "inuktitut" },
            { "%%HOGNORSK", "Hongorszk" },
            { "ja", "jap\u00e1n" },
            { "Mlym", "Malaj\u00e1lam" },
            { "Sara", "Szarati" },
            { "doi", "dogri" },
            { "bkm", "kom" },
            { "sma", "d\u00e9li sz\u00e1mi" },
            { "jv", "j\u00e1vai" },
            { "Shaw", "Shaw \u00e1b\u00e9c\u00e9" },
            { "%%BAUDDHA", "Bauddha" },
            { "mad", "madurai" },
            { "smj", "lulei sz\u00e1mi" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "inari sz\u00e1mi" },
            { "ka", "gr\u00faz" },
            { "bla", "siksika" },
            { "mak", "makaszar" },
            { "wuu", "wu k\u00ednai" },
            { "sms", "kolta sz\u00e1mi" },
            { "man", "manding\u00f3" },
            { "kg", "kongo" },
            { "Goth", "G\u00f3t" },
            { "ki", "kikuju" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kazah" },
            { "kl", "gr\u00f6nlandi" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "ko", "koreai" },
            { "kr", "kanuri" },
            { "ks", "kasm\u00edri" },
            { "Lepc", "Lepcha" },
            { "Avst", "Aveszt\u00e1n" },
            { "ku", "kurd" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiz" },
            { "snk", "szoninke" },
            { "la", "latin" },
            { "lb", "luxemburgi" },
            { "type.nu.mlym", "Malaj\u00e1lam sz\u00e1mjegyek" },
            { "lg", "ganda" },
            { "Roro", "Rongorongo" },
            { "li", "limburgi" },
            { "Tibt", "Tibeti" },
            { "ln", "lingala" },
            { "fur", "friuli" },
            { "lo", "lao" },
            { "type.ms.uksystem", "Angolsz\u00e1sz m\u00e9rt\u00e9kegys\u00e9grendszer" },
            { "lt", "litv\u00e1n" },
            { "lu", "luba-katanga" },
            { "lv", "lett" },
            { "sog", "sogdien" },
            { "mg", "malgas" },
            { "mh", "marshalli" },
            { "type.co.ducet", "Alap\u00e9rtelmezett Unicode rendez\u00e9si sorrend" },
            { "mi", "maori" },
            { "mk", "maced\u00f3n" },
            { "ml", "malaj\u00e1lam" },
            { "mn", "mongol" },
            { "mr", "mar\u00e1thi" },
            { "ms", "mal\u00e1j" },
            { "mt", "m\u00e1ltai" },
            { "my", "burmai" },
            { "Saur", "Szaurastra" },
            { "Armn", "\u00d6rm\u00e9ny" },
            { "mdf", "moks\u00e1n" },
            { "mde", "maba" },
            { "dsb", "als\u00f3-szorb" },
            { "Armi", "Birodalmi ar\u00e1mi" },
            { "na", "naurui" },
            { "type.co.search", "\u00c1ltal\u00e1nos c\u00e9l\u00fa keres\u00e9s" },
            { "nb", "norv\u00e9g (bokm\u00e5l)" },
            { "nd", "\u00e9szaki ndebele" },
            { "ne", "nep\u00e1li" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "holland" },
            { "nn", "norv\u00e9g (nynorsk)" },
            { "no", "norv\u00e9g" },
            { "nr", "d\u00e9li ndebele" },
            { "nv", "navah\u00f3" },
            { "kaa", "kara-kalpak" },
            { "ny", "nyandzsa" },
            { "kac", "kacsin" },
            { "kab", "kabije" },
            { "%%POLYTON", "Politonikus" },
            { "oc", "okszit\u00e1n" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ojibva" },
            { "mer", "meru" },
            { "type.nu.armn", "\u00d6rm\u00e9ny sz\u00e1mok" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", "odia" },
            { "os", "osz\u00e9t" },
            { "%%ALALC97", "ALA-LC romaniz\u00e1ci\u00f3, 1997-es kiad\u00e1s" },
            { "kbd", "kabardi" },
            { "mfe", "mauritiusi kreol" },
            { "srn", "szranai tong\u00f3" },
            { "pa", "pandzs\u00e1bi" },
            { "dua", "duala" },
            { "srr", "szerer" },
            { "%%LIPAW", "Rezij\u00e1n lipovaz t\u00e1jsz\u00f3l\u00e1s" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "pl", "lengyel" },
            { "dum", "k\u00f6z\u00e9p holland" },
            { "type.ca.dangi", "Dangi napt\u00e1r" },
            { "%%VALLADER", "Vallader" },
            { "ps", "pastu" },
            { "pt", "portug\u00e1l" },
            { "mga", "k\u00f6z\u00e9p \u00edr" },
            { "key.co", "Rendez\u00e9si sorrend" },
            { "pt_BR", "braz\u00edliai portug\u00e1l" },
            { "kcg", "tyap" },
            { "mgh", "makua-met\u00f3" },
            { "key.cf", "P\u00e9nznemform\u00e1tum" },
            { "bra", "braj" },
            { "key.ca", "Napt\u00e1r" },
            { "%%JAUER", "Jauer" },
            { "Laoo", "Lao" },
            { "%%SURMIRAN", "Surmiran" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "24 \u00f3r\u00e1s rendszer (0\u201323)" },
            { "type.hc.h24", "24 \u00f3r\u00e1s rendszer (0\u201324)" },
            { "ssy", "szah\u00f3" },
            { "type.nu.mymr", "Mianmari sz\u00e1mjegyek" },
            { "qu", "kecsua" },
            { "zap", "zapot\u00e9k" },
            { "brx", "bodo" },
            { "Lana", "Lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "Vaidika" },
            { "Ethi", "Eti\u00f3p" },
            { "%%JYUTPING", "Jyutping" },
            { "type.hc.h12", "12 \u00f3r\u00e1s rendszer (0\u201312)" },
            { "type.hc.h11", "12 \u00f3r\u00e1s rendszer (0\u201311)" },
            { "rm", "r\u00e9torom\u00e1n" },
            { "rn", "kirundi" },
            { "key.cu", "P\u00e9nznem" },
            { "ro", "rom\u00e1n" },
            { "%%SAAHO", "Saho" },
            { "type.nu.orya", "Orija sz\u00e1mjegyek" },
            { "type.nu.hanidec", "K\u00ednai tizedes sz\u00e1mok" },
            { "ru", "orosz" },
            { "bss", "koszi" },
            { "zbl", metaValue_zbl },
            { "rw", "kinyarvanda" },
            { "kea", "kabuverdianu" },
            { "mic", "mikmak" },
            { "suk", "szukuma" },
            { "en_AU", "ausztr\u00e1l angol" },
            { "sa", "szanszkrit" },
            { "%%UCCOR", "Egyes\u00edtett helyes\u00edr\u00e1s" },
            { "sc", "szard\u00edniai" },
            { "sus", "szuszu" },
            { "sd", "szindhi" },
            { "se", "\u00e9szaki sz\u00e1mi" },
            { "min", "minangkabau" },
            { "sg", "szang\u00f3" },
            { "sh", "szerbhorv\u00e1t" },
            { "si", "szingal\u00e9z" },
            { "sux", "sum\u00e9r" },
            { "sk", "szlov\u00e1k" },
            { "sl", "szlov\u00e9n" },
            { "sm", "szamoai" },
            { "sn", "sona" },
            { "so", "szom\u00e1li" },
            { "type.nu.arab", "Arab-indiai sz\u00e1mjegyek" },
            { "sq", "alb\u00e1n" },
            { "sr", "szerb" },
            { "ss", "sziszuati" },
            { "type.cf.account", "K\u00f6nyvel\u00e9si p\u00e9nznemform\u00e1tum" },
            { "st", "d\u00e9li szeszot\u00f3" },
            { "Java", "J\u00e1vai" },
            { "su", "szundan\u00e9z" },
            { "%%NEDIS", "Natisone dialektus" },
            { "sv", "sv\u00e9d" },
            { "sw", "szuah\u00e9li" },
            { "type.nu.hantfin", "Hagyom\u00e1nyos k\u00ednai p\u00e9nz\u00fcgyi sz\u00e1mok" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamil" },
            { "142", "\u00c1zsia" },
            { "bua", "burj\u00e1t" },
            { "143", "K\u00f6z\u00e9p-\u00c1zsia" },
            { "te", "telugu" },
            { "145", "Nyugat-\u00c1zsia" },
            { "tg", "tadzsik" },
            { "th", "thai" },
            { "ti", "tigrinya" },
            { "bug", "bugin\u00e9z" },
            { "kfo", "koro" },
            { "en_CA", "kanadai angol" },
            { "tk", "t\u00fcrkm\u00e9n" },
            { "tl", "tagalog" },
            { "tn", "szecsu\u00e1ni" },
            { "to", "tongai" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "Jap\u00e1n sz\u00e1mok" },
            { "tr", "t\u00f6r\u00f6k" },
            { "ts", "conga" },
            { "swb", "comorei" },
            { "Cakm", "Csakma" },
            { "tt", "tat\u00e1r" },
            { "dyu", "diula" },
            { "tw", "twi" },
            { "ty", "tahiti" },
            { "%%BISKE", "San Giorgo/Bila t\u00e1jsz\u00f3l\u00e1s" },
            { "150", "Eur\u00f3pa" },
            { "151", "Kelet-Eur\u00f3pa" },
            { "154", "\u00c9szak-Eur\u00f3pa" },
            { "dzg", "dazaga" },
            { "155", "Nyugat-Eur\u00f3pa" },
            { "ug", "ujgur" },
            { "Ital", "R\u00e9gi olasz" },
            { "Kore", "Koreai" },
            { "Zyyy", "Meghat\u00e1rozatlan" },
            { "uk", "ukr\u00e1n" },
            { "type.ca.coptic", "Kopt napt\u00e1r" },
            { "ur", "urdu" },
            { "%%1994", "Szabv\u00e1nyos\u00edtott rezij\u00e1n helyes\u00edr\u00e1s" },
            { "xal", "kalm\u00fck" },
            { "zen", "zenaga" },
            { "uz", "\u00fczb\u00e9g" },
            { "kha", "kaszi" },
            { "%%1996", "1996-os n\u00e9met helyes\u00edr\u00e1s" },
            { "nds_NL", "als\u00f3sz\u00e1sz" },
            { "Sylo", "Sylheti nag\u00e1ri" },
            { "ve", "venda" },
            { "type.ca.roc", "K\u00ednai k\u00f6zt\u00e1rsas\u00e1gi napt\u00e1r" },
            { "vi", "vietn\u00e1mi" },
            { "kho", "kotan\u00e9z" },
            { "khq", "kojra-cs\u00edni" },
            { "key.hc", "\u00d3raform\u00e1tum (12 \u2013 24)" },
            { "%%TARASK", "Taraskijevica helyes\u00edr\u00e1s" },
            { "vo", "volap\u00fck" },
            { "syc", "klasszikus sz\u00edr" },
            { "Osma", "Oszm\u00e1n" },
            { "quc", "kicse" },
            { "gaa", "ga" },
            { "wa", "vallon" },
            { "gag", "gagauz" },
            { "syr", "sz\u00edr" },
            { "Grek", "G\u00f6r\u00f6g" },
            { "gan", "gan k\u00ednai" },
            { "Lydi", "L\u00eddiai" },
            { "Xsux", "\u00c9k\u00edr\u00e1sos sum\u00e9ro-akk\u00e1d" },
            { "wo", "volof" },
            { "zgh", "marokk\u00f3i tamazight" },
            { "ar_001", "modern szabv\u00e1nyos arab" },
            { "Cans", "Egyes\u00edtett kanadai \u0151slakos jelek" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "gay", "gajo" },
            { "Mong", "Mongol" },
            { "mnc", "mandzsu" },
            { "Latf", "Fraktur latin" },
            { "gba", "gbaja" },
            { "mni", "manipuri" },
            { "Latn", "Latin" },
            { "Latg", "Gael latin" },
            { "type.nu.hans", "Egyszer\u0171s\u00edtett k\u00ednai sz\u00e1mok" },
            { "type.nu.hant", "Hagyom\u00e1nyos k\u00ednai sz\u00e1mok" },
            { "xh", "xhosza" },
            { "type.nu.romanlow", "R\u00f3mai kisbet\u0171s sz\u00e1mok" },
            { "byn", "blin" },
            { "%%PAMAKA", "Pamaka dialektus" },
            { "Lyci", "L\u00edciai" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "Moon", "Moon" },
            { "moh", "mohawk" },
            { "kkj", "kak\u00f3" },
            { "%%1694ACAD", "Korai modern francia" },
            { "yi", "jiddis" },
            { "mos", "moszi" },
            { "Syrc", "Sz\u00edriai" },
            { "Dsrt", "Deseret" },
            { "yo", "joruba" },
            { "type.nu.traditional", "Hagyom\u00e1nyos sz\u00e1mok" },
            { "es_MX", "spanyol (mexik\u00f3i)" },
            { "Syrj", "Nyugat-sz\u00edriai" },
            { "ota", "ottom\u00e1n t\u00f6r\u00f6k" },
            { "Syre", "Estrangelo sz\u00edriai" },
            { "vai", "vai" },
            { "za", "zsuang" },
            { "Cari", "Kari" },
            { "kln", "kalendzsin" },
            { "zh", "k\u00ednai" },
            { "Bopo", "Bopomofo" },
            { "Perm", "\u00d3permikus" },
            { "key.lb", "Sort\u00f6r\u00e9s st\u00edlusa" },
            { "zu", "zulu" },
            { "type.co.phonebook", "Telefonk\u00f6nyv sorrend" },
            { "%%MONOTON", "Monoton" },
            { "Geor", "Gr\u00faz" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "Jap\u00e1n p\u00e9nz\u00fcgyi sz\u00e1mok" },
            { "Cham", "Cs\u00e1m" },
            { "gez", "geez" },
            { "Syrn", "Kelet-sz\u00edriai" },
            { "type.co.reformed", "\u00c1talak\u00edtott rendez\u00e9si elv" },
            { "Tglg", "Tagalog" },
            { "Egyd", "Egyiptomi demotikus" },
            { "Egyh", "Egyiptomi hieratikus" },
            { "%%ITIHASA", "Itihasa" },
            { "ebu", "embu" },
            { "Egyp", "Egyiptomi hieroglif\u00e1k" },
            { "Geok", "Gr\u00faz kucsuri" },
            { "zh_Hans", "egyszer\u0171s\u00edtett k\u00ednai" },
            { "koi", "komi-permj\u00e1k" },
            { "Hung", "\u00d3magyar" },
            { "kok", "konkani" },
            { "%%1901", "Hagyom\u00e1nyos n\u00e9met helyes\u00edr\u00e1s" },
            { "kos", "kosrei" },
            { "zh_Hant", "hagyom\u00e1nyos k\u00ednai" },
            { "Sund", "Szundan\u00e9z" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "Khmer sz\u00e1mjegyek" },
            { "ilo", "ilok\u00f3" },
            { "%%VALENCIA", "Valencia" },
            { "Cprt", "Ciprusi" },
            { "%%BAKU1926", "Egyes\u00edtett t\u00fcrkic latin \u00e1b\u00e9c\u00e9" },
            { "mua", "mundang" },
            { "type.nu.guru", "Gurmuki sz\u00e1mjegyek" },
            { "mul", "t\u00f6bbsz\u00f6r\u00f6s nyelvek" },
            { "%%PUTER", "Puter" },
            { "cad", "caddo" },
            { "key.ms", "M\u00e9rt\u00e9kegys\u00e9grendszer" },
            { "mus", "kr\u00edk" },
            { "Glag", "Glagolitikus" },
            { "gil", "ikiribati" },
            { "%%KKCOR", "Meghat\u00e1rozatlan helyes\u00edr\u00e1s" },
            { "Cher", "Cseroki" },
            { "car", "karib" },
            { "cay", "kajuga" },
            { "type.nu.tamldec", "Tamil sz\u00e1mjegyek" },
            { "krc", "karacs\u00e1j-balk\u00e1r" },
            { "inh", "ingus" },
            { "fa_AF", "dari" },
            { "krl", "karelai" },
            { "efi", "efik" },
            { "key.nu", "Sz\u00e1mok" },
            { "kru", "kuruh" },
            { "ksb", "sambala" },
            { "Telu", "Telugu" },
            { "ksf", "bafia" },
        };
        return data;
    }
}
