/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.piecewise.DefaultDomain1D;
import it.geosolutions.jaiext.piecewise.DomainElement1D;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1D;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.TransformationException;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;

public class GenericPiecewiseOpImage<T extends PiecewiseTransform1DElement>
extends ColormapOpImage {
    public static final String OPERATION_NAME = "GenericPiecewise";
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private final PiecewiseTransform1D<T> piecewise;
    protected boolean isByteData;
    private byte[][] lut;
    private double gapsValue = Double.NaN;
    private boolean hasGapsValue = false;
    private final boolean useLast;
    private final boolean hasNoData;
    private final boolean hasROI;
    private Range nodata;
    private ROI roi;
    private Rectangle roiBounds;
    private PlanarImage roiImage;
    private byte gapsValueByte;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private Integer bandIndex;

    public GenericPiecewiseOpImage(RenderedImage image, PiecewiseTransform1D<T> lic, ImageLayout layout, Integer bandIndex, ROI roi, Range nodata, RenderingHints hints, boolean cobbleSources) {
        super(image, layout, (Map)hints, cobbleSources);
        this.piecewise = lic;
        int numBands = this.sampleModel.getNumBands();
        if (bandIndex != null) {
            this.bandIndex = bandIndex;
        }
        boolean bl = this.isByteData = this.sampleModel.getTransferType() == 0;
        if (this.piecewise.hasDefaultValue()) {
            this.gapsValue = this.piecewise.getDefaultValue();
            this.hasGapsValue = true;
            this.gapsValueByte = ImageUtil.clampRoundByte((double)this.gapsValue);
        }
        boolean bl2 = this.hasNoData = nodata != null;
        if (this.hasNoData) {
            this.nodata = RangeFactory.convertToDoubleRange((Range)nodata);
        }
        boolean bl3 = this.hasROI = roi != null;
        if (this.hasROI) {
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        boolean bl4 = this.caseC = this.hasNoData && !this.hasROI;
        if (!this.caseA && !this.hasGapsValue) {
            throw new IllegalArgumentException("Unable to set input Gap valuein presence of NoData and ROI");
        }
        this.useLast = this.piecewise instanceof DefaultDomain1D;
        if (this.isByteData) {
            try {
                this.createLUT(numBands);
            }
            catch (TransformationException e) {
                RuntimeException re = new RuntimeException(e);
                throw re;
            }
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                ROI roiTile = this.roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        if (sources[0].getNumBands() != dest.getNumBands()) {
            throw new IllegalArgumentException("Sourc and Destination image must have the same Bands");
        }
        if (!this.hasROI || !roiDisjointTile) {
            if (this.isByteData) {
                this.computeRectByte(sources[0], dest, destRect, roiIter, roiContainsTile);
            } else {
                this.computeRectGeneral(sources[0], dest, destRect, roiIter, roiContainsTile);
            }
        } else {
            double[] background = new double[dest.getSampleModel().getNumBands()];
            Arrays.fill(background, this.gapsValue);
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])background);
        }
    }

    private void computeRectByte(Raster source, WritableRaster dest, Rectangle destRect, RandomIter roiIter, boolean roiContainsTile) {
        int bandNumber;
        int srcX = destRect.x;
        int srcY = destRect.y;
        int x0 = srcX;
        int y0 = srcY;
        WritableRectIter dstIter = RectIterFactory.createWritable((WritableRaster)dest, (Rectangle)destRect);
        RectIter srcIter = RectIterFactory.create((Raster)source, (Rectangle)destRect);
        if (!dstIter.finishedBands() && !srcIter.finishedBands()) {
            for (int i = 0; i < this.bandIndex; ++i) {
                dstIter.nextBand();
                srcIter.nextBand();
            }
        }
        if (this.hasROI) {
            bandNumber = 0;
            do {
                try {
                    dstIter.startLines();
                    srcIter.startLines();
                    if (!dstIter.finishedLines() && !srcIter.finishedLines()) {
                        do {
                            dstIter.startPixels();
                            srcIter.startPixels();
                            if (!dstIter.finishedPixels() && !srcIter.finishedPixels()) {
                                do {
                                    int in = srcIter.getSample() & 0xFF;
                                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                                        dstIter.setSample(this.gapsValue);
                                    } else {
                                        int out = 0xFF & this.lut[bandNumber][in];
                                        dstIter.setSample(out);
                                    }
                                    ++x0;
                                } while (!dstIter.nextPixelDone() && !srcIter.nextPixelDone());
                            }
                            ++y0;
                            x0 = srcX;
                        } while (!dstIter.nextLineDone() && !srcIter.nextLineDone());
                    }
                }
                catch (Exception cause) {
                    RasterFormatException exception = new RasterFormatException(cause.getLocalizedMessage());
                    exception.initCause(cause);
                    throw exception;
                }
                ++bandNumber;
                y0 = srcY;
                x0 = srcX;
            } while (this.bandIndex == -1 && dstIter.finishedBands() && srcIter.finishedBands());
        } else {
            bandNumber = 0;
            do {
                try {
                    dstIter.startLines();
                    srcIter.startLines();
                    if (!dstIter.finishedLines() && !srcIter.finishedLines()) {
                        do {
                            dstIter.startPixels();
                            srcIter.startPixels();
                            if (dstIter.finishedPixels() || srcIter.finishedPixels()) continue;
                            do {
                                int in = srcIter.getSample() & 0xFF;
                                int out = 0xFF & this.lut[bandNumber][in];
                                dstIter.setSample(out);
                            } while (!dstIter.nextPixelDone() && !srcIter.nextPixelDone());
                        } while (!dstIter.nextLineDone() && !srcIter.nextLineDone());
                    }
                }
                catch (Exception cause) {
                    RasterFormatException exception = new RasterFormatException(cause.getLocalizedMessage());
                    exception.initCause(cause);
                    throw exception;
                }
                ++bandNumber;
            } while (this.bandIndex == -1 && dstIter.finishedBands() && srcIter.finishedBands());
        }
    }

    private void computeRectGeneral(Raster source, WritableRaster dest, Rectangle destRect, RandomIter roiIter, boolean roiContainsTile) {
        int srcX = destRect.x;
        int srcY = destRect.y;
        int x0 = srcX;
        int y0 = srcY;
        PiecewiseTransform1DElement element = null;
        WritableRectIter dstIter = RectIterFactory.createWritable((WritableRaster)dest, (Rectangle)destRect);
        RectIter srcIter = RectIterFactory.create((Raster)source, (Rectangle)destRect);
        if (!dstIter.finishedBands() && !srcIter.finishedBands()) {
            for (int i = 0; i < this.bandIndex; ++i) {
                dstIter.nextBand();
                srcIter.nextBand();
            }
        }
        if (this.caseA || this.caseB && roiContainsTile) {
            do {
                try {
                    dstIter.startLines();
                    srcIter.startLines();
                    if (dstIter.finishedLines() || srcIter.finishedLines()) continue;
                    do {
                        dstIter.startPixels();
                        srcIter.startPixels();
                        if (dstIter.finishedPixels() || srcIter.finishedPixels()) continue;
                        do {
                            double value;
                            if ((element = this.domainSearch(element, value = srcIter.getSampleDouble())) != null) {
                                dstIter.setSample(element.transform(value));
                                continue;
                            }
                            if (this.hasGapsValue) {
                                dstIter.setSample(this.gapsValue);
                                continue;
                            }
                            throw new IllegalArgumentException("Unable to set input Gap value");
                        } while (!dstIter.nextPixelDone() && !srcIter.nextPixelDone());
                    } while (!dstIter.nextLineDone() && !srcIter.nextLineDone());
                }
                catch (Exception cause) {
                    RasterFormatException exception = new RasterFormatException(cause.getLocalizedMessage());
                    exception.initCause(cause);
                    throw exception;
                }
            } while (this.bandIndex == -1 && dstIter.finishedBands() && srcIter.finishedBands());
        } else if (this.caseB) {
            do {
                try {
                    dstIter.startLines();
                    srcIter.startLines();
                    if (!dstIter.finishedLines() && !srcIter.finishedLines()) {
                        do {
                            dstIter.startPixels();
                            srcIter.startPixels();
                            if (!dstIter.finishedPixels() && !srcIter.finishedPixels()) {
                                do {
                                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                                        dstIter.setSample(this.gapsValue);
                                    } else {
                                        double value = srcIter.getSampleDouble();
                                        if ((element = this.domainSearch(element, value)) != null) {
                                            dstIter.setSample(element.transform(value));
                                        } else if (this.hasGapsValue) {
                                            dstIter.setSample(this.gapsValue);
                                        } else {
                                            throw new IllegalArgumentException("Unable to set input Gap value");
                                        }
                                    }
                                    ++x0;
                                } while (!dstIter.nextPixelDone() && !srcIter.nextPixelDone());
                            }
                            ++y0;
                            x0 = srcX;
                        } while (!dstIter.nextLineDone() && !srcIter.nextLineDone());
                    }
                }
                catch (Exception cause) {
                    RasterFormatException exception = new RasterFormatException(cause.getLocalizedMessage());
                    exception.initCause(cause);
                    throw exception;
                }
                y0 = srcY;
                x0 = srcX;
            } while (this.bandIndex == -1 && dstIter.finishedBands() && srcIter.finishedBands());
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            do {
                try {
                    dstIter.startLines();
                    srcIter.startLines();
                    if (dstIter.finishedLines() || srcIter.finishedLines()) continue;
                    do {
                        dstIter.startPixels();
                        srcIter.startPixels();
                        if (dstIter.finishedPixels() || srcIter.finishedPixels()) continue;
                        do {
                            double value;
                            if (this.nodata.contains(value = srcIter.getSampleDouble())) {
                                dstIter.setSample(this.gapsValue);
                                continue;
                            }
                            if ((element = this.domainSearch(element, value)) != null) {
                                dstIter.setSample(element.transform(value));
                                continue;
                            }
                            if (this.hasGapsValue) {
                                dstIter.setSample(this.gapsValue);
                                continue;
                            }
                            throw new IllegalArgumentException("Unable to set input Gap value");
                        } while (!dstIter.nextPixelDone() && !srcIter.nextPixelDone());
                    } while (!dstIter.nextLineDone() && !srcIter.nextLineDone());
                }
                catch (Exception cause) {
                    RasterFormatException exception = new RasterFormatException(cause.getLocalizedMessage());
                    exception.initCause(cause);
                    throw exception;
                }
            } while (this.bandIndex == -1 && dstIter.finishedBands() && srcIter.finishedBands());
        } else {
            do {
                try {
                    dstIter.startLines();
                    srcIter.startLines();
                    if (!dstIter.finishedLines() && !srcIter.finishedLines()) {
                        do {
                            dstIter.startPixels();
                            srcIter.startPixels();
                            if (!dstIter.finishedPixels() && !srcIter.finishedPixels()) {
                                do {
                                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                                        dstIter.setSample(this.gapsValue);
                                    } else {
                                        double value = srcIter.getSampleDouble();
                                        if (this.nodata.contains(value)) {
                                            dstIter.setSample(this.gapsValue);
                                        } else if ((element = this.domainSearch(element, value)) != null) {
                                            dstIter.setSample(element.transform(value));
                                        } else if (this.hasGapsValue) {
                                            dstIter.setSample(this.gapsValue);
                                        } else {
                                            throw new IllegalArgumentException("Unable to set input Gap value");
                                        }
                                    }
                                    ++x0;
                                } while (!dstIter.nextPixelDone() && !srcIter.nextPixelDone());
                            }
                            ++y0;
                            x0 = srcX;
                        } while (!dstIter.nextLineDone() && !srcIter.nextLineDone());
                    }
                }
                catch (Exception cause) {
                    RasterFormatException exception = new RasterFormatException(cause.getLocalizedMessage());
                    exception.initCause(cause);
                    throw exception;
                }
                y0 = srcY;
                x0 = srcX;
            } while (this.bandIndex == -1 && dstIter.finishedBands() && srcIter.finishedBands());
        }
    }

    private PiecewiseTransform1DElement domainSearch(PiecewiseTransform1DElement last, double value) throws TransformationException {
        PiecewiseTransform1DElement transformElement;
        if (this.useLast) {
            if (last != null && last.contains(value)) {
                transformElement = last;
            } else {
                last = transformElement = (PiecewiseTransform1DElement)this.piecewise.findDomainElement(value);
            }
        } else {
            transformElement = (PiecewiseTransform1DElement)this.piecewise.findDomainElement(value);
        }
        return transformElement;
    }

    private void createLUT(int numBands) throws TransformationException {
        byte[][] data = new byte[numBands][];
        for (int band = 0; band < numBands; ++band) {
            data[band] = new byte[256];
            byte[] table = data[band];
            DomainElement1D lastPiecewiseElement = null;
            for (int value = 0; value < 256; ++value) {
                DomainElement1D piecewiseElement;
                boolean isNoData;
                boolean bl = isNoData = this.hasNoData && this.nodata.contains((byte)value);
                if (isNoData) {
                    table[value] = this.gapsValueByte;
                    continue;
                }
                if (this.useLast) {
                    if (lastPiecewiseElement != null && lastPiecewiseElement.contains(value)) {
                        piecewiseElement = lastPiecewiseElement;
                    } else {
                        lastPiecewiseElement = piecewiseElement = (PiecewiseTransform1DElement)this.piecewise.findDomainElement(value);
                    }
                } else {
                    piecewiseElement = (PiecewiseTransform1DElement)this.piecewise.findDomainElement(value);
                }
                if (piecewiseElement != null) {
                    table[value] = ImageUtil.clampRoundByte((double)piecewiseElement.transform(value));
                    continue;
                }
                if (this.hasGapsValue) {
                    table[value] = ImageUtil.clampRoundByte((double)this.gapsValue);
                    continue;
                }
                throw new IllegalArgumentException("Unable to set the Gap value");
            }
        }
        this.lut = data;
    }

    protected void transformColormap(byte[][] colormap) {
        for (int b = 0; b < 3; ++b) {
            byte[] map = colormap[b];
            byte[] luTable = this.lut[b >= this.lut.length ? 0 : b];
            int mapSize = map.length;
            for (int i = 0; i < mapSize; ++i) {
                map[i] = luTable[map[i] & 0xFF];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            GenericPiecewiseOpImage genericPiecewiseOpImage = this;
            synchronized (genericPiecewiseOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

