/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.util.color;

import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorValueRanges {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private float[] values = new float[0];
    private Color[] colors = new Color[0];
    private float minValue = 0.0f;
    private float maxValue = 0.0f;

    public ColorValueRanges() {
    }

    public ColorValueRanges(float[] values, Color[] colors) {
        this.values = values;
        this.colors = colors;
        this.minValue = values[0];
        this.maxValue = values[values.length - 1];
    }

    public ColorValueRanges(String colorRanges) {
        this.buildColorRangesFromString(colorRanges);
    }

    public void buildColorRangesFromString(String colorRanges) {
        String[] rangesArray = colorRanges.split(",");
        int rangesCount = rangesArray.length / 2;
        if (rangesCount < 2) {
            this.log.error("buildColorRangesFromString: the color-ranges parameter only contained one entry but at least two are needed.");
            return;
        }
        this.values = new float[rangesCount];
        this.colors = new Color[rangesCount];
        for (int i = 0; i < rangesCount; ++i) {
            this.values[i] = Float.parseFloat(rangesArray[i * 2].trim());
            this.colors[i] = ColorUtil.getColorFromString(rangesArray[i * 2 + 1].trim());
        }
        this.minValue = this.values[0];
        this.maxValue = this.values[this.values.length - 1];
    }

    public float[] getValues() {
        return this.values;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public Color getColorFromColorRanges(double value) {
        return this.getColorFromColorRanges((float)value);
    }

    public Color getColorFromColorRanges(float value) {
        int minIndex = 0;
        int maxIndex = 0;
        if (value <= this.values[0]) {
            return this.colors[0];
        }
        if (value >= this.values[this.values.length - 1]) {
            return this.colors[this.colors.length - 1];
        }
        for (int i = 0; i < this.values.length - 1; ++i) {
            if (!(value > this.values[i]) || !(value <= this.values[i + 1])) continue;
            minIndex = i;
            maxIndex = i + 1;
            break;
        }
        double slopeMin = this.values[minIndex];
        double slopeMax = this.values[maxIndex];
        double slopeDistance = slopeMax - slopeMin;
        double groundedSlope = (double)value - slopeMin;
        double factor = groundedSlope / slopeDistance;
        Color colorMin = this.colors[minIndex];
        float[] rgbaMin = new float[]{colorMin.getRed(), colorMin.getGreen(), colorMin.getBlue(), colorMin.getAlpha()};
        Color colorMax = this.colors[maxIndex];
        float[] rgbaMax = new float[]{colorMax.getRed(), colorMax.getGreen(), colorMax.getBlue(), colorMax.getAlpha()};
        float newRed = (float)(((double)colorMin.getRed() + (double)(colorMax.getRed() - colorMin.getRed()) * factor) / 255.0);
        float newGreen = (float)(((double)colorMin.getGreen() + (double)(colorMax.getGreen() - colorMin.getGreen()) * factor) / 255.0);
        float newBlue = (float)(((double)colorMin.getBlue() + (double)(colorMax.getBlue() - colorMin.getBlue()) * factor) / 255.0);
        float newAlpha = (float)(((double)colorMin.getAlpha() + (double)(colorMax.getAlpha() - colorMin.getAlpha()) * factor) / 255.0);
        return new Color(newRed, newGreen, newBlue, newAlpha);
    }
}

