/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.server;

import de.wideportal.maprender.request.RenderManager;
import de.wideportal.maprender.request.RenderRequestAllJobsProgress;
import de.wideportal.maprender.request.RenderRequestJobProgress;
import de.wideportal.maprender.request.RenderRequestZoomLevelProgress;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class StatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        response.setCharacterEncoding("utf-8");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        response.getWriter().println("<html>");
        response.getWriter().println("<head>");
        response.getWriter().println("<title>MapRender Status</title>");
        response.getWriter().println("<meta http-equiv='Cache-Control' content='no-cache, no-store, must-revalidate'>");
        response.getWriter().println("<meta http-equiv='Pragma' content='no-cache'>");
        response.getWriter().println("</head>");
        response.getWriter().println("<body>");
        response.getWriter().println("<h1 style='font-size: 14px;'>MapRender Status</h1>");
        RenderManager renderManager = RenderManager.getSingleton();
        RenderRequestAllJobsProgress progressMonitor = renderManager.getProgressMonitor();
        int jobs = progressMonitor.getJobs().size();
        if (jobs == 0) {
            response.getWriter().println("No jobs running");
        } else {
            response.getWriter().println("  <hr />");
            for (RenderRequestJobProgress jobProgress : progressMonitor.getJobs()) {
                String jobName = jobProgress.getJobName();
                boolean skipJob = jobProgress.isSkipJob();
                response.getWriter().println("  <div style='" + (skipJob ? "color: CCCCCC;" : "color: 000000;") + "'>");
                response.getWriter().println("    job: " + jobName + ": " + jobProgress.getTilesDone() + " / " + jobProgress.getTilesCount());
                response.getWriter().println("    <ul>");
                for (RenderRequestZoomLevelProgress zoomLevelProgress : jobProgress.getZoomLevelProgresses()) {
                    response.getWriter().println("      <li>");
                    response.getWriter().println("        zoom " + zoomLevelProgress.getZoom() + ": " + zoomLevelProgress.getTilesDone() + " / " + zoomLevelProgress.getTilesCount());
                    response.getWriter().println("      </li>");
                }
                response.getWriter().println("    </ul>");
                response.getWriter().println("  </div>");
                response.getWriter().println("  <hr />");
            }
        }
        response.getWriter().println("</body>");
        response.getWriter().println("</html>");
    }
}

