/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm.voids;

import de.wideportal.maprender.resources.srtm.voids.SrtmTileCell;
import de.wideportal.maprender.resources.srtm.voids.SrtmTileCellKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Set;

public class SrtmTileVoid
implements Serializable {
    private static final long serialVersionUID = -4115659853783372169L;
    private LinkedHashMap<SrtmTileCellKey, SrtmTileCell> outline = new LinkedHashMap();
    private LinkedHashMap<SrtmTileCellKey, SrtmTileCell> voids = new LinkedHashMap();
    private LinkedHashMap<SrtmTileCellKey, SrtmTileCell> correctedVoids = new LinkedHashMap();

    public boolean containsVoidCell(int x, int y) {
        SrtmTileCellKey key = new SrtmTileCellKey(x, y);
        return this.voids.containsKey(key);
    }

    public boolean containsVoidCell(SrtmTileCell cell) {
        return this.containsVoidCell(cell.getX(), cell.getY());
    }

    public boolean containsOutlineCell(int x, int y) {
        SrtmTileCellKey key = new SrtmTileCellKey(x, y);
        return this.outline.containsKey(key);
    }

    public boolean containsOutlineCell(SrtmTileCell cell) {
        return this.containsOutlineCell(cell.getX(), cell.getY());
    }

    public void addVoid(SrtmTileCell voidCell) {
        SrtmTileCellKey key = new SrtmTileCellKey(voidCell.getX(), voidCell.getY());
        this.voids.put(key, voidCell);
    }

    public void addCorrectedVoid(SrtmTileCell voidCell) {
        SrtmTileCellKey key = new SrtmTileCellKey(voidCell.getX(), voidCell.getY());
        this.correctedVoids.put(key, voidCell);
    }

    public void addOutline(SrtmTileCell outlineCell) {
        SrtmTileCellKey key = new SrtmTileCellKey(outlineCell.getX(), outlineCell.getY());
        this.outline.put(key, outlineCell);
    }

    public SrtmTileCell getCorrectedVoid(int x, int y) {
        return this.correctedVoids.get(new SrtmTileCellKey(x, y));
    }

    public Set<SrtmTileCellKey> getVoidKeySet() {
        return this.voids.keySet();
    }

    public ArrayList<SrtmTileCell> getVoidsAsList() {
        ArrayList<SrtmTileCell> cells = new ArrayList<SrtmTileCell>();
        for (SrtmTileCellKey key : this.voids.keySet()) {
            cells.add(this.voids.get(key));
        }
        return cells;
    }

    public ArrayList<SrtmTileCell> getDistanceSortedOutline(final int x, final int y) {
        ArrayList<SrtmTileCell> cells = new ArrayList<SrtmTileCell>();
        for (SrtmTileCellKey key : this.outline.keySet()) {
            cells.add(this.outline.get(key));
        }
        Comparator<SrtmTileCell> distanceComparator = new Comparator<SrtmTileCell>(){

            @Override
            public int compare(SrtmTileCell o1, SrtmTileCell o2) {
                float d2;
                float d1 = o1.getDistance(x, y);
                if (d1 == (d2 = o2.getDistance(x, y))) {
                    return 0;
                }
                return d1 < d2 ? -1 : 1;
            }
        };
        Collections.sort(cells, distanceComparator);
        return cells;
    }

    public String toString() {
        return "SrtmTileVoid[voids=" + this.voids + "]";
    }
}

