/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm.buffer;

import de.wideportal.maprender.renderer.buffer.FloatArrayBuffer;

public class MultipleValueCollectorBuffer
extends FloatArrayBuffer {
    private static final long serialVersionUID = 544900357418537432L;
    public static final int Z_INDEX_ADDED_VALUES = 0;
    public static final int Z_INDEX_VALUES_COUNT = 1;
    public static final int Z_INDEX_MIN_VALUE = 2;
    public static final int Z_INDEX_MAX_VALUE = 3;
    public static final int Z_INDEX_AVERAGE_VALUE = 4;

    protected MultipleValueCollectorBuffer(int xSize, int ySize, int zSize) {
        super(xSize, ySize, zSize);
    }

    public MultipleValueCollectorBuffer(int xSize, int ySize) {
        super(xSize, ySize, 5);
    }

    public void addValue(int x, int y, float value) {
        super.addValue(x, y, 0, value);
        super.addValue(x, y, 1, 1.0f);
        float valuesCount = super.getValue(x, y, 1);
        if (valuesCount == 1.0f) {
            super.setValue(x, y, 2, value);
            super.setValue(x, y, 3, value);
        } else {
            float oldMinValue = this.getMinValue(x, y);
            float oldMaxValue = this.getMaxValue(x, y);
            super.setValue(x, y, 2, Math.min(oldMinValue, value));
            super.setValue(x, y, 3, Math.min(oldMaxValue, value));
        }
        float addedValues = super.getValue(x, y, 0);
        super.setValue(x, y, 4, addedValues / valuesCount);
    }

    public float getAveragedValue(int x, int y) {
        return super.getValue(x, y, 4);
    }

    public float getMaxValue(int x, int y) {
        return super.getValue(x, y, 3);
    }

    public float getMinValue(int x, int y) {
        return super.getValue(x, y, 2);
    }

    @Override
    public void logBuffer(int z, int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer ");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                float value = this.buffer[y][x][z];
                String roundedValue = String.format("%.5f", Float.valueOf(value));
                String lengthFilledValue = String.format("%1$10s", roundedValue);
                rowBuffy.append(lengthFilledValue);
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }
}

