/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm;

import de.wideportal.maprender.resources.srtm.SrtmTile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrtmTileLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String folder;
    private String filePattern;
    private boolean zipped;
    private boolean mockMissingTiles;
    private boolean removeVoids;
    private int tileSizeForMock;

    public SrtmTileLoader(String folder, String filePattern, Boolean zipped, Boolean mockMissingTiles, Integer tileSizeForMock, Boolean removeVoids) {
        this.folder = folder;
        this.filePattern = filePattern;
        this.folder = this.folder.replaceAll("\\\\\\\\", "/");
        this.folder = this.folder.replaceAll("\\\\", "/");
        if (!this.folder.endsWith("/")) {
            this.folder = this.folder + "/";
        }
        this.zipped = zipped != null ? zipped : false;
        this.mockMissingTiles = mockMissingTiles != null ? mockMissingTiles : false;
        this.tileSizeForMock = tileSizeForMock != null ? tileSizeForMock : -1;
        this.removeVoids = removeVoids != null ? removeVoids : false;
    }

    public SrtmTile loadTile(SrtmTile unloadedTile) {
        int lon = unloadedTile.getLon();
        int lat = unloadedTile.getLat();
        unloadedTile.setVoidless(!this.removeVoids);
        String northSouth = "";
        if (lat >= 0) {
            northSouth = "N";
        } else {
            northSouth = "S";
            lat = -lat;
        }
        String eastWest = "";
        if (lon >= 0) {
            eastWest = "E";
        } else {
            eastWest = "W";
            lon = -lon;
        }
        String latFormatted = this.fillNumber(lat, 2);
        String lonFormatted = this.fillNumber(lon, 3);
        String tileName = this.filePattern.replaceAll("\\[lat\\]", latFormatted);
        tileName = tileName.replaceAll("\\[lon\\]", lonFormatted);
        tileName = tileName.replaceAll("\\[NS\\]", northSouth);
        tileName = tileName.replaceAll("\\[EW\\]", eastWest);
        File srtmFile = new File(this.folder + tileName);
        if (!srtmFile.exists()) {
            if (this.mockMissingTiles) {
                this.log.info("loadTile: mocking missing SRTM tile file: " + tileName);
                unloadedTile.setMockedRawBuffer(this.tileSizeForMock, tileName);
                this.log.debug("loadTile: mocked missing tile file");
                return unloadedTile;
            }
            this.log.warn("loadTile: the required SRTM tile file does not exist: " + srtmFile.getAbsolutePath());
            return null;
        }
        this.log.info("loadTile: loading raw srtm tile " + tileName);
        ShortBuffer sb = this.readerSrtmFile(srtmFile);
        if (sb == null) {
            this.log.warn("loadTile: the required SRTM tile file could not be loaded, buffer was null: " + srtmFile.getAbsolutePath());
            return null;
        }
        unloadedTile.setRawBuffer(sb, tileName);
        this.log.debug("loadTile: loaded srtm tile " + tileName);
        return unloadedTile;
    }

    private String fillNumber(int number, int length) {
        String result = String.format("%0" + length + "d", number);
        return result;
    }

    private ShortBuffer readerSrtmFile(File srtmFile) {
        if (this.zipped) {
            return this.readerSrtmFileZip(srtmFile);
        }
        return this.readerSrtmFilePlain(srtmFile);
    }

    private ShortBuffer readerSrtmFilePlain(File srtmFile) {
        ShortBuffer result = null;
        if (srtmFile.exists()) {
            try (FileInputStream fis = new FileInputStream(srtmFile);
                 FileChannel fc = fis.getChannel();){
                ByteBuffer bb = ByteBuffer.allocateDirect((int)fc.size());
                while (bb.remaining() > 0) {
                    fc.read(bb);
                }
                bb.flip();
                result = bb.order(ByteOrder.BIG_ENDIAN).asShortBuffer();
                bb.clear();
            }
            catch (Exception e) {
                this.log.error("readerSrtmFilePlain: could not load tile file: " + srtmFile, (Throwable)e);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ShortBuffer readerSrtmFileZip(File srtmFile) {
        ShortBuffer result = null;
        if (!srtmFile.exists()) return result;
        try (FileInputStream fis = new FileInputStream(srtmFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream stream = new ZipInputStream(bis);){
            ZipEntry entry = null;
            entry = stream.getNextEntry();
            if (entry == null) return result;
            byte[] allBytes = stream.readAllBytes();
            ByteBuffer bb = ByteBuffer.allocateDirect(allBytes.length);
            for (int i = 0; i < allBytes.length; ++i) {
                bb.put(allBytes[i]);
            }
            bb.flip();
            result = bb.order(ByteOrder.BIG_ENDIAN).asShortBuffer();
            bb.clear();
            ShortBuffer shortBuffer = result;
            return shortBuffer;
        }
        catch (Exception e) {
            this.log.error("readerSrtmFileZip: could not load tile file: " + srtmFile, (Throwable)e);
        }
        return result;
    }
}

