/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.sqlitedb;

import de.wideportal.maprender.resources.sqlitedb.AbstractSqLiteDbAccessor;
import de.wideportal.maprender.resources.sqlitedb.AbstractSqLiteDbConnector;
import de.wideportal.maprender.resources.sqlitedb.SqLiteDbTableInfo;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteErrorCode;
import org.sqlite.SQLiteException;

public class SqLiteDbAccessor
extends AbstractSqLiteDbAccessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean dbIsInitialized = false;
    private boolean isMetadataInitialized = false;

    public SqLiteDbAccessor(AbstractSqLiteDbConnector connectorProvider) {
        super(connectorProvider);
    }

    private void createTableAndroidMetadata() {
        String createSql = "CREATE TABLE android_metadata (locale TEXT);";
        this.executeSql(createSql);
    }

    private void createTableInfo() {
        String createSql = "CREATE TABLE info (minzoom INTEGER,maxzoom INTEGER,center_x DOUBLE,center_y DOUBLE,zooms TEXT,provider INTEGER);";
        this.executeSql(createSql);
    }

    private void createTableTiles() {
        String createSql = "CREATE TABLE tiles (x INTEGER,y INTEGER,z INTEGER,s INTEGER,image BYTE,PRIMARY KEY (x, y, z));";
        this.executeSql(createSql);
    }

    public SqLiteDbTableInfo getTableInfo() {
        String createSql = "SELECT minzoom, maxzoom, center_x, center_y, zooms, provider FROM info;";
        try {
            ResultSet resultSet = this.executeQuery(createSql);
            if (resultSet != null && !resultSet.isClosed() && resultSet.next()) {
                SqLiteDbTableInfo info = new SqLiteDbTableInfo();
                info.setMinZoom(resultSet.getInt("minzoom"));
                info.setMaxZoom(resultSet.getInt("maxzoom"));
                info.setCenterX(resultSet.getDouble("center_x"));
                info.setCenterY(resultSet.getDouble("center_y"));
                info.setZooms(resultSet.getString("zooms"));
                info.setProvider(resultSet.getInt("provider"));
                return info;
            }
        }
        catch (SQLException e) {
            this.log.error("getTableInfo: could not get table info", (Throwable)e);
        }
        return null;
    }

    @Override
    public void initTablesIfNecessary() {
        if (!this.dbIsInitialized) {
            boolean tableTilesExists;
            boolean tableInfoExists;
            this.log.info("initTablesIfNecessary: creating sqlite tables");
            this.setPragmas();
            boolean tableAndroidMetadataExists = this.doesTableExist("android_metadata");
            if (!tableAndroidMetadataExists) {
                this.createTableAndroidMetadata();
            }
            if (!(tableInfoExists = this.doesTableExist("info"))) {
                this.createTableInfo();
            }
            if (!(tableTilesExists = this.doesTableExist("tiles"))) {
                this.createTableTiles();
            }
            this.dbIsInitialized = true;
            this.log.info("initTablesIfNecessary: created sqlite tables");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addTile(int x, int y, int zoom, int timestamp, byte[] imageBytes) {
        Connection connection = this.connectorProvider.getConnection();
        String sqlMetadata = "INSERT INTO tiles(x,y,z,s,image) VALUES(?,?,?,?,?);";
        try {
            if (connection == null || connection.isClosed()) return;
            PreparedStatement pstmt = connection.prepareStatement(sqlMetadata);
            pstmt.setInt(1, x);
            pstmt.setInt(2, y);
            pstmt.setInt(3, zoom);
            pstmt.setInt(4, timestamp);
            pstmt.setBytes(5, imageBytes);
            pstmt.executeUpdate();
            pstmt.close();
            return;
        }
        catch (SQLException e) {
            if (e instanceof SQLiteException) {
                SQLiteException sqe = (SQLiteException)e;
                if (!sqe.getResultCode().equals((Object)SQLiteErrorCode.SQLITE_CONSTRAINT_UNIQUE)) return;
            }
            this.log.error("addTile: an sql exception occured", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTile(int x, int y, int zoom) {
        byte[] byteArray;
        block20: {
            Connection connection = this.connectorProvider.getConnection();
            String sqlMetadata = "SELECT image FROM tiles WHERE x=? AND y=? AND z=?;";
            byteArray = null;
            Statement pstmt = null;
            try {
                if (connection == null || connection.isClosed()) break block20;
                pstmt = connection.prepareStatement(sqlMetadata);
                pstmt.setInt(1, x);
                pstmt.setInt(2, y);
                pstmt.setInt(3, zoom);
                ResultSet resultSet = pstmt.executeQuery();
                while (resultSet.next()) {
                    try {
                        InputStream input = resultSet.getBinaryStream("image");
                        try {
                            byteArray = new byte[input.available()];
                            input.read(byteArray);
                        }
                        finally {
                            if (input == null) continue;
                            input.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.error("getTile: Exception occured while trying to read image blob from SQLiteDB", (Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                this.log.error("getTile: an sql exception occured", (Throwable)e);
            }
            finally {
                try {
                    if (pstmt != null && !pstmt.isClosed()) {
                        pstmt.close();
                    }
                }
                catch (SQLException e) {
                    this.log.error("getTile: Could not close prepared statement", (Throwable)e);
                }
            }
        }
        return byteArray;
    }

    public void initMetadataIfNecessary(String locale, int minZoom, int maxZoom, double centerX, double centerY, String zooms, int provider) {
        if (!this.isMetadataInitialized) {
            this.log.info("initTablesIfNecessary: writing sqlite metadata");
            Connection connection = this.connectorProvider.getConnection();
            this.executeSql("DELETE FROM android_metadata;");
            String sqlMetadata = "INSERT INTO android_metadata(locale) VALUES(?);";
            try {
                if (connection != null && !connection.isClosed()) {
                    PreparedStatement pstmt = connection.prepareStatement(sqlMetadata);
                    pstmt.setString(1, locale);
                    pstmt.executeUpdate();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.error("initMetadataIfNecessary: an sql exception occured", (Throwable)e);
            }
            this.executeSql("DELETE FROM info;");
            String sqlInfo = "INSERT INTO info(minzoom,maxzoom,center_x,center_y,zooms,provider) VALUES (?,?,?,?,?,?);";
            try {
                if (connection != null && !connection.isClosed()) {
                    PreparedStatement pstmt = connection.prepareStatement(sqlInfo);
                    pstmt.setInt(1, minZoom);
                    pstmt.setInt(2, maxZoom);
                    pstmt.setDouble(3, centerX);
                    pstmt.setDouble(4, centerY);
                    pstmt.setString(5, zooms);
                    pstmt.setInt(6, provider);
                    pstmt.executeUpdate();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.error("initMetadataIfNecessary: an sql exception occured", (Throwable)e);
            }
            this.isMetadataInitialized = true;
            this.log.info("initTablesIfNecessary: wrote sqlite metadata");
        }
    }

    public void deleteExistingTiles() {
        this.log.info("cleanExistingTiles: deleting old tiles");
        this.executeSql("DELETE FROM tiles;");
        this.log.info("cleanExistingTiles: deleted old tiles");
    }
}

