/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.sqlitedb;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.resources.AbstractConnectableResource;
import de.wideportal.maprender.resources.file.FileAccessor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteConfig;
import org.sqlite.javax.SQLiteConnectionPoolDataSource;

public abstract class AbstractSqLiteDbConnector
extends FileAccessor
implements AbstractConnectableResource {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected String file;
    protected Connection connection = null;
    protected boolean isConfigured = false;

    public AbstractSqLiteDbConnector(RenderConfiguration configuration) {
        this.file = this.getFileFromConfiguration(configuration);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getFile() {
        return this.file;
    }

    protected abstract String getFileFromConfiguration(RenderConfiguration var1);

    public boolean isConfigured() {
        return this.isConfigured;
    }

    @Override
    public void connect() throws Exception {
        String url = "jdbc:sqlite:" + this.file;
        this.log.info("connect: trying to connect to sqlite db: " + url);
        try {
            SQLiteConfig config = new SQLiteConfig();
            config.setJournalMode(SQLiteConfig.JournalMode.OFF);
            config.setCacheSize(10);
            config.setDefaultCacheSize(10);
            config.setPageSize(2048);
            SQLiteConnectionPoolDataSource dataSource = new SQLiteConnectionPoolDataSource();
            dataSource.setUrl(url);
            dataSource.setConfig(config);
            this.connection = dataSource.getConnection();
            if (this.connection != null) {
                this.connection.setAutoCommit(false);
                DatabaseMetaData meta = this.connection.getMetaData();
                this.log.debug("connect: The driver name is " + meta.getDriverName());
                this.log.info("connect: connected");
            }
        }
        catch (SQLException e) {
            this.log.error("connect: could not connect due to an error");
            if (this.connection != null) {
                try {
                    if (!this.connection.isClosed()) {
                        this.connection.close();
                    }
                    this.connection = null;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public void disconnect() {
        this.log.info("disconnect: trying to disconnect from sqlite db: " + this.file);
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                try {
                    this.connection.commit();
                }
                catch (Exception pe) {
                    this.log.warn("disconnect: could not call commit() due to error", (Throwable)pe);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException pe) {
                    // empty catch block
                }
                try {
                    this.connection.endRequest();
                }
                catch (Exception pe) {
                    this.log.warn("disconnect: could not call endRequest() due to error", (Throwable)pe);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException pe) {
                    // empty catch block
                }
                this.connection.close();
            }
            this.connection = null;
            this.log.info("disconnect: disconnect");
        }
        catch (SQLException e) {
            this.log.warn("disconnect: could not disconnect due to error", (Throwable)e);
        }
    }
}

