/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.sqlitedb;

import de.wideportal.maprender.resources.sqlitedb.AbstractSqLiteDbConnector;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqLiteDbAccessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected AbstractSqLiteDbConnector connectorProvider;

    public AbstractSqLiteDbAccessor(AbstractSqLiteDbConnector connectorProvider) {
        this.connectorProvider = connectorProvider;
    }

    protected void executeSql(String sql) {
        Connection connection = this.connectorProvider.getConnection();
        try {
            if (connection != null && !connection.isClosed()) {
                Statement statement = connection.createStatement();
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            this.log.error("executeSql: an sql exception occured", (Throwable)e);
        }
    }

    protected ResultSet executeQuery(String sqlQuery) {
        Connection connection = this.connectorProvider.getConnection();
        try {
            if (connection != null && !connection.isClosed()) {
                Statement statement = connection.createStatement();
                return statement.executeQuery(sqlQuery);
            }
        }
        catch (SQLException e) {
            this.log.error("executeSql: an sql exception occured", (Throwable)e);
        }
        return null;
    }

    protected void setPragmas() {
    }

    protected boolean doesTableExist(String tableName) {
        String tableSelector = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "';";
        try {
            ResultSet tableResponse = this.executeQuery(tableSelector);
            if (tableResponse != null) {
                int rowcount = 0;
                while (tableResponse.next()) {
                    ++rowcount;
                }
                if (rowcount >= 1) {
                    return true;
                }
            }
        }
        catch (SQLException e) {
            this.log.error("doesTableExist: an sql exception occured", (Throwable)e);
        }
        return false;
    }

    public abstract void initTablesIfNecessary();
}

