/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.output.format;

import de.wideportal.maprender.config.xml.RenderConfigurationProcessingProjection;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.output.format.AlbersTiles;
import de.wideportal.maprender.resources.output.format.MollweideTiles;
import de.wideportal.maprender.resources.output.format.SlippyMapTiles;

public class OutputFormatFactory {
    private static OutputFormatFactory singleton;

    private OutputFormatFactory() {
    }

    public static OutputFormatFactory getInstance() {
        if (singleton == null) {
            singleton = new OutputFormatFactory();
        }
        return singleton;
    }

    public AbstractMapTileOutput getMapTileOutputter(RenderConfigurationProcessingProjection projection) {
        if (projection == null) {
            projection = new RenderConfigurationProcessingProjection();
        }
        if ("slippymap".equalsIgnoreCase(projection.getName())) {
            return new SlippyMapTiles();
        }
        if ("mollweide".equalsIgnoreCase(projection.getName())) {
            MollweideTiles mollweideTiles = new MollweideTiles();
            mollweideTiles.setOffsetLat(projection.getOffsetLat());
            mollweideTiles.setOffsetLon(projection.getOffsetLon());
            return mollweideTiles;
        }
        if ("albers".equalsIgnoreCase(projection.getName())) {
            AlbersTiles albersTiles = new AlbersTiles(projection.getLonOrigin(), projection.getTopLatParallel(), projection.getBottomLatParallel());
            return albersTiles;
        }
        return new SlippyMapTiles();
    }
}

