/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.output.format;

import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;

public abstract class AbstractSlippyMapTileOutput
extends AbstractMapTileOutput {
    public static final double TILE_SIZE = 256.0;
    public static final double EARTH_RADIUS = 6378137.0;
    public static final double EARTH_CIRCUMFENCE = 4.007501668557849E7;
    public static final double SQRT2 = Math.sqrt(2.0);

    @Override
    public int getTileSize() {
        return 256;
    }

    @Override
    public double getScaleDenominator(double zoom, double latDegree) {
        double[] scaleDenominatorsForZoom = new double[]{5.59082264E8, 2.79541132E8, 1.39770566E8, 6.9885283E7, 3.4942642E7, 1.7471321E7, 8735660.0, 4367830.0, 2183915.0, 1091958.0, 545979.0, 272989.0, 136495.0, 68247.0, 34124.0, 17062.0, 8531.0, 4265.0, 2133.0, 1066.0, 533.0};
        double scaleDenominator = scaleDenominatorsForZoom[(int)zoom];
        return scaleDenominator;
    }

    @Override
    public double getMaxPixels(double zoom) {
        return 256.0 * (double)(1 << (int)zoom);
    }

    @Override
    public double getPixelsPerTile(double zoom) {
        return 256.0;
    }

    @Override
    public double getTileCountPerAxis(double zoom) {
        return this.getMaxPixels(zoom) / 256.0;
    }
}

