/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.lglbw;

import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.lglbw.LglBwTile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LglBwTileLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String folder;
    private String filePattern;
    private boolean mockMissingTiles;
    private int tileSizeForMock;

    public LglBwTileLoader(String folder, String filePattern, Boolean mockMissingTiles, Integer tileSizeForMock) {
        this.folder = folder;
        this.filePattern = filePattern;
        this.folder = this.folder.replaceAll("\\\\\\\\", "/");
        this.folder = this.folder.replaceAll("\\\\", "/");
        if (!this.folder.endsWith("/")) {
            this.folder = this.folder + "/";
        }
        this.mockMissingTiles = mockMissingTiles != null ? mockMissingTiles : false;
        this.tileSizeForMock = tileSizeForMock != null ? tileSizeForMock : -1;
    }

    public LglBwTile loadTile(LglBwTile unloadedTile) {
        String tileName = this.getTileFileName(unloadedTile);
        String tileNameWithoutEnding = tileName.substring(0, tileName.indexOf("."));
        File lglBwTile = this.getLglBwFile(tileName);
        if (lglBwTile == null || !lglBwTile.exists()) {
            if (this.mockMissingTiles) {
                this.log.info("loadTile: mocking missing LglBw tile file: " + tileName);
                unloadedTile.setMockedRawBuffer(this.tileSizeForMock, tileName);
                this.log.debug("loadTile: mocked missing tile file");
                return unloadedTile;
            }
            this.log.warn("loadTile: the required LglBw tile file does not exist: " + lglBwTile.getAbsolutePath());
            return null;
        }
        this.log.debug("loadTile: loading raw LglBw tile " + lglBwTile.getName());
        BufferedImage bufferedImage = this.readerLglBwFile(lglBwTile, tileNameWithoutEnding);
        if (bufferedImage == null) {
            this.log.warn("loadTile: the required LglBw tile file could not be loaded, buffer was null: " + lglBwTile.getAbsolutePath());
            return null;
        }
        unloadedTile.setRawBuffer(bufferedImage, tileName);
        lglBwTile = null;
        bufferedImage = null;
        this.log.debug("loadTile: loaded LglBw tile " + tileName);
        return unloadedTile;
    }

    private String getTileFileName(ITile unloadedTile) {
        int northing = unloadedTile.getLat();
        int easting = unloadedTile.getLon();
        String tileName = this.filePattern.replaceAll("\\[easting\\]", "" + easting);
        tileName = tileName.replaceAll("\\[northing\\]", "" + northing);
        return tileName;
    }

    private File getLglBwFile(String tileFileName) {
        File tileFileWithPossibleWildcards = new File(this.folder + tileFileName);
        File parentFolder = tileFileWithPossibleWildcards.getParentFile();
        File[] foundFiles = parentFolder.listFiles(file -> FilenameUtils.wildcardMatch((String)file.getName(), (String)tileFileName));
        if (foundFiles != null && foundFiles.length > 0) {
            return foundFiles[0];
        }
        this.log.info("getLglBwFile: file not found: " + tileFileName);
        return null;
    }

    public boolean isTileFileExisting(ITile unloadedTile) {
        String tileName = this.getTileFileName(unloadedTile);
        File lglBwFile = this.getLglBwFile(tileName);
        return lglBwFile != null && lglBwFile.exists();
    }

    private BufferedImage readerLglBwFile(File lblBwFile, String latLonFilename) {
        return this.readerLglBwFilePlain(lblBwFile);
    }

    private BufferedImage readerLglBwFilePlain(File lblBwFile) {
        BufferedImage result = null;
        if (lblBwFile.exists()) {
            try {
                result = ImageIO.read(lblBwFile);
                GeoTiffReader reader = new GeoTiffReader((Object)lblBwFile);
                GridCoverage2D coverage = reader.read(null);
                RenderedImage renderedImage = coverage.getRenderedImage();
                if (renderedImage instanceof BufferedImage) {
                    result = (BufferedImage)renderedImage;
                } else {
                    ColorModel cm = renderedImage.getColorModel();
                    WritableRaster raster = cm.createCompatibleWritableRaster(renderedImage.getWidth(), renderedImage.getHeight());
                    boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    String[] keys = renderedImage.getPropertyNames();
                    if (keys != null) {
                        for (int i = 0; i < keys.length; ++i) {
                            properties.put(keys[i], renderedImage.getProperty(keys[i]));
                        }
                    }
                    result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
                    renderedImage.copyData(raster);
                }
            }
            catch (Exception e) {
                this.log.error("readerLglBwFilePlain: could not load tile file: " + lblBwFile, (Throwable)e);
            }
        }
        return result;
    }
}

