/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.lglbw;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileCache;
import de.wideportal.maprender.resources.lglbw.LglBwHelper;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LglBwTile
implements ITile {
    private static final long serialVersionUID = 3245202540688387804L;
    public static final int BORDER_WIDTH = 1;
    public static final float VOID_VALUE = -32768.0f;
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int W = 3;
    public static final int C = 4;
    public static final int E = 5;
    public static final int SW = 6;
    public static final int S = 7;
    public static final int SE = 8;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private float[][] rawBuffer;
    private BoundingBox latLonBBox;
    private int easting;
    private int northing;
    private int lglBwTileSize;
    private int heightDiffThreshold;
    private int heightPointDiffThreshold;
    private boolean loaded = false;
    private boolean flattened = false;
    private boolean mocked = false;
    private String fileName = null;

    public LglBwTile(int lon, int lat, int heightDiffThreshold, int heightPointDiffThreshold) {
        this.latLonBBox = LglBwHelper.getLatLonBBoxFromEastingNorthing(lon, lat, 1000.0);
        this.easting = lon;
        this.northing = lat;
        this.heightDiffThreshold = heightDiffThreshold;
        this.heightPointDiffThreshold = heightPointDiffThreshold;
    }

    @Override
    public boolean containsCell(double lon, double lat) {
        return this.latLonBBox.bottom <= lat && this.latLonBBox.top > lat && this.latLonBBox.left <= lon && this.latLonBBox.right > lon;
    }

    @Override
    public float[][] getRawBuffer() {
        return this.rawBuffer;
    }

    @Override
    public float[][] getFlattenedBuffer() {
        return this.rawBuffer;
    }

    @Override
    public void setMockedRawBuffer(int tileSizeForMock, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = new float[tileSizeForMock][tileSizeForMock];
        this.lglBwTileSize = tileSizeForMock;
        this.loaded = true;
        this.flattened = true;
        this.mocked = true;
    }

    @Override
    public void setRawBuffer(float[][] rawBuffer, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = rawBuffer;
        this.lglBwTileSize = rawBuffer.length;
        this.loaded = true;
    }

    public void setRawBuffer(BufferedImage bufferedImage, String fileName) {
        this.fileName = fileName;
        this.rawBuffer = this.convertToArray(bufferedImage);
        this.lglBwTileSize = this.rawBuffer.length;
        this.loaded = true;
    }

    private float[][] convertToArray(BufferedImage bufferedImage) {
        Raster raster = bufferedImage.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int size = Math.max(width, height);
        float[][] result = new float[size][size];
        double ratioX = (double)width / (double)size;
        double ratioY = (double)height / (double)size;
        float[] valuePixel = new float[5];
        float[][] stretched = new float[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int x = (int)((double)i * ratioX);
                int y = (int)((double)j * ratioY);
                valuePixel = raster.getPixel(x, y, valuePixel);
                stretched[i][j] = valuePixel[0];
            }
        }
        result = stretched;
        return result;
    }

    @Override
    public int getLat() {
        return this.northing;
    }

    @Override
    public void setLat(int northing) {
        this.northing = northing;
    }

    @Override
    public int getLon() {
        return this.easting;
    }

    @Override
    public void setLon(int easting) {
        this.easting = easting;
    }

    @Override
    public int getTileSize() {
        return this.lglBwTileSize;
    }

    @Override
    public boolean isMocked() {
        return this.mocked;
    }

    @Override
    public void setMocked(boolean mocked) {
        this.mocked = mocked;
    }

    @Override
    public boolean isFlattened() {
        return this.flattened;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.latLonBBox;
    }

    @Override
    public int getHeightDiffThreshold() {
        return this.heightDiffThreshold;
    }

    @Override
    public void setHeightDiffThreshold(int heightDiffThreshold) {
        this.heightDiffThreshold = heightDiffThreshold;
    }

    @Override
    public int getHeightPointDiffThreshold() {
        return this.heightPointDiffThreshold;
    }

    @Override
    public void setHeightPointDiffThreshold(int heightPointDiffThreshold) {
        this.heightPointDiffThreshold = heightPointDiffThreshold;
    }

    @Override
    public ITile[] getSurroundingTiles(ITileCache lglBwTileCache) {
        ITile[] tiles = new LglBwTile[9];
        int counter = 0;
        for (int latShift = 1; latShift >= -1; --latShift) {
            for (int lonShift = -1; lonShift <= 1; ++lonShift) {
                LglBwTile currentTile = (LglBwTile)this.getSurroundingTile(lglBwTileCache, lonShift, latShift);
                tiles[counter] = currentTile;
                ++counter;
            }
        }
        return tiles;
    }

    @Override
    public ITile getSurroundingTile(ITileCache lglBwTileCache, int lonShift, int latShift) {
        ITile currentTile = lglBwTileCache.getCachedTile(this.easting + lonShift, this.northing + latShift, this.heightDiffThreshold, this.heightPointDiffThreshold);
        if (!currentTile.isLoaded()) {
            lglBwTileCache.loadTile(currentTile, this.heightDiffThreshold);
        }
        return currentTile;
    }

    @Override
    public HeightCollectorTile renderIntoCollector(int zoom, int xTileIndex, int yTileIndex, RenderRequest renderRequest, HeightCollectorTile collector, AbstractMapTileOutput tileOutputter, ITileCache tileCache) {
        this.log.debug("renderIntoCollector: start rendering LglBw tile " + this.fileName + " into collector tile: " + this.latLonBBox.toString());
        if (this.loaded) {
            int topNorthingDiff;
            int bottomNorthingDiff;
            int rightEastingDiff;
            int leftIndex = 0;
            int rightIndex = this.lglBwTileSize - 1;
            int bottomIndex = 0;
            int topIndex = this.lglBwTileSize - 1;
            BoundingBox collectorLatLonBox = collector.getLatLonCollectFromBox();
            Point collectorLeftBottom = LglBwHelper.getEastingNorthingFromLatLon(collectorLatLonBox.getLeft(), collectorLatLonBox.getBottom(), 1.0);
            Point collectorRightTop = LglBwHelper.getEastingNorthingFromLatLon(collectorLatLonBox.getRight(), collectorLatLonBox.getTop(), 1.0);
            int leftEastingDiff = (int)((double)this.easting * 1000.0 - collectorLeftBottom.x);
            if (leftEastingDiff < 0) {
                leftIndex = (int)((double)(-leftEastingDiff * this.lglBwTileSize) / 1000.0);
            }
            if ((rightEastingDiff = (int)(collectorRightTop.x - (double)(this.easting + 1) * 1000.0)) < 0) {
                rightIndex = this.lglBwTileSize - (int)((double)(-rightEastingDiff * this.lglBwTileSize) / 1000.0);
            }
            if ((bottomNorthingDiff = (int)((double)this.northing * 1000.0 - collectorLeftBottom.y)) < 0) {
                bottomIndex = (int)((double)(-bottomNorthingDiff * this.lglBwTileSize) / 1000.0);
            }
            if ((topNorthingDiff = (int)(collectorRightTop.y - (double)(this.northing + 1) * 1000.0)) < 0) {
                topIndex = this.lglBwTileSize - (int)((double)(-topNorthingDiff * this.lglBwTileSize) / 1000.0);
            }
            if (leftIndex < 0) {
                leftIndex = 0;
            }
            if (topIndex > this.lglBwTileSize - 1) {
                topIndex = this.lglBwTileSize - 1;
            }
            if (rightIndex > this.lglBwTileSize - 1) {
                rightIndex = this.lglBwTileSize - 1;
            }
            if (bottomIndex < 0) {
                bottomIndex = 0;
            }
            for (int y = bottomIndex; y < topIndex; ++y) {
                for (int x = leftIndex; x < rightIndex; ++x) {
                    float value = this.rawBuffer[x][this.lglBwTileSize - 1 - y];
                    BoundingBox cellBBox = LglBwHelper.getLatLonBBoxFromEastingNorthing((double)this.easting * 1000.0 + (double)x * 1000.0 / (double)this.lglBwTileSize, (double)this.northing * 1000.0 + ((double)y + 20.0 / (double)this.lglBwTileSize) * 1000.0 / (double)this.lglBwTileSize, 1.0);
                    double cellLeft = cellBBox.getLeft();
                    double cellRight = cellBBox.getRight();
                    double cellTop = cellBBox.getTop();
                    double cellBottom = cellBBox.getBottom();
                    collector.addValueSimple(cellLeft, cellTop, cellRight, cellBottom, zoom, value, tileOutputter);
                }
            }
        }
        this.log.debug("renderIntoCollector: finished renderering LglBw tile " + this.fileName + " into collector tile");
        return collector;
    }

    @Override
    public void flatten(int zoom, int xTileIndex, int yTileIndex, RenderRequest renderRequest) {
    }

    public boolean equals(Object other) {
        if (!this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        LglBwTile otherTile = (LglBwTile)other;
        return this.easting == otherTile.easting && this.northing == otherTile.northing && this.heightDiffThreshold == otherTile.heightDiffThreshold;
    }

    @Override
    public void logBufferFlattened() {
        for (int y = 0; y < this.rawBuffer.length; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = 0; x < this.rawBuffer[y].length; ++x) {
                float value = this.rawBuffer[y][x];
                if (value != 0.0f) {
                    rowBuffy.append("1");
                    continue;
                }
                rowBuffy.append("0");
            }
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        return "LglBwTile[lon=" + this.easting + ", lat=" + this.northing + ", loaded=" + this.loaded + ", heightDiffThreshold=" + this.heightDiffThreshold + ", size=[" + this.rawBuffer.length + "][" + this.rawBuffer[0].length + "]]";
    }
}

