/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.lglbw;

import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageMetadata;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataController;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;

public class LglBwTestClass {
    public void test() {
        try {
            File imageFile = new File("/home/hola/Entwicklung/Projects/Maprender/data/input/lgl-bw/dgm025_32_459_5416_2_bw/dgm025_32_459_5416_1_bw_2020.tif");
            GeoTiffReader reader2 = new GeoTiffReader((Object)imageFile);
            GridCoverage2D coverage = reader2.read(null);
            Raster raster2 = coverage.getRenderedImage().getData();
            double maxValue2 = 0.0;
            double[] inputArray2 = new double[10];
            for (int i = 0; i < raster2.getHeight(); ++i) {
                for (int j = 0; j < raster2.getWidth(); ++j) {
                    double[] pixel = raster2.getPixel(i, j, inputArray2);
                    for (int k = 0; k < pixel.length; ++k) {
                        maxValue2 = Math.max(maxValue2, pixel[k]);
                    }
                }
            }
            System.out.println("######################## maxValue2 " + maxValue2);
            BufferedImage tiff = ImageIO.read(imageFile);
            tiff.toString();
            System.out.println("######################## width: " + tiff.getWidth());
            System.out.println("######################## height: " + tiff.getHeight());
            ImageInputStream iis = ImageIO.createImageInputStream(imageFile);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            IIOMetadata genericMetadata = null;
            TIFFImageMetadata tiffMetadata = null;
            ImageReader reader = null;
            while (readers.hasNext()) {
                ImageReader currentReader = readers.next();
                if (!(currentReader instanceof TIFFImageReader)) continue;
                reader = currentReader;
                reader.setInput(iis, true);
                genericMetadata = reader.getImageMetadata(0);
            }
            if (genericMetadata instanceof TIFFImageMetadata) {
                tiffMetadata = (TIFFImageMetadata)genericMetadata;
                String[] metadataFormatNames = tiffMetadata.getMetadataFormatNames();
                IIOMetadataController iIOMetadataController = tiffMetadata.getController();
            }
            Entry tileOffsets = tiffMetadata.getTIFFField(324);
            Entry tileByteCounts = tiffMetadata.getTIFFField(325);
            Iterator<IIOImage> allImages = reader.readAll(null);
            while (allImages.hasNext()) {
                System.out.println("######################## allImages");
                IIOImage iioImage = allImages.next();
                RenderedImage renderedImage = iioImage.getRenderedImage();
                if (renderedImage instanceof BufferedImage) {
                    System.out.println("######################## renderedImage");
                    BufferedImage buffImage = (BufferedImage)renderedImage;
                    ColorModel colorModel = buffImage.getColorModel();
                    System.out.println("######################## colorModel " + colorModel.toString());
                    Raster raster = buffImage.getData();
                    int height = buffImage.getHeight();
                    System.out.println("######################## height " + height);
                    double[] inputArray = new double[10];
                    System.out.println("######################## raster.getNumBands() " + raster.getNumBands());
                    System.out.println("######################## raster.getNumDataElements() " + raster.getNumDataElements());
                    System.out.println("######################## raster.getSampleModel() " + raster.getSampleModel());
                    double maxValue = 0.0;
                    StringBuilder strBuilder = new StringBuilder();
                    for (int i = 0; i < raster.getHeight(); ++i) {
                        for (int j = 0; j < raster.getWidth(); ++j) {
                            double[] pixel = raster.getPixel(i, j, inputArray);
                            for (int k = 0; k < pixel.length; ++k) {
                                maxValue = Math.max(maxValue, pixel[k]);
                            }
                        }
                    }
                    System.out.println("######################## maxValue " + maxValue);
                    buffImage.toString();
                }
                Raster raster = iioImage.getRaster();
            }
            tiffMetadata.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

