/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.lglbw;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;

public class LglBwHelper {
    public static final double LGLBW_TILE_INDEX_MULTIPLIER = 1000.0;
    public static final double LGLBW_TILE_SIZE = 4000.0;
    private static CRSFactory crsFactory = new CRSFactory();
    private static CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
    private static CoordinateReferenceSystem latLonCRS = crsFactory.createFromName("EPSG:4326");
    private static CoordinateReferenceSystem eastingNorthingCRS = crsFactory.createFromName("EPSG:25832");
    private static CoordinateTransform transformLatLonToEastingNorthing = ctFactory.createTransform(latLonCRS, eastingNorthingCRS);
    private static CoordinateTransform transformEastingNorthingToLatLon = ctFactory.createTransform(eastingNorthingCRS, latLonCRS);

    public static Point getEastingNorthingFromLatLon(double lon, double lat, double sizeFactor) {
        ProjCoordinate latLonCoord = new ProjCoordinate(lon, lat);
        ProjCoordinate utmCoord = new ProjCoordinate();
        transformLatLonToEastingNorthing.transform(latLonCoord, utmCoord);
        return new Point(Math.floor(utmCoord.x / sizeFactor), Math.floor(utmCoord.y / sizeFactor));
    }

    public static Point getLatLonFromEastingNorthing(int easting, int northing, double sizeFactor) {
        ProjCoordinate latLonCoord = new ProjCoordinate();
        ProjCoordinate utmCoord = new ProjCoordinate((double)easting * sizeFactor, (double)northing * sizeFactor);
        transformEastingNorthingToLatLon.transform(utmCoord, latLonCoord);
        return new Point(latLonCoord.x, latLonCoord.y);
    }

    public static BoundingBox getLatLonBBoxFromEastingNorthing(double easting, double northing, double sizeFactor) {
        return LglBwHelper.getLatLonBBoxFromEastingNorthing((int)easting, (int)northing, sizeFactor);
    }

    public static BoundingBox getLatLonBBoxFromEastingNorthing(int easting, int northing, double sizeFactor) {
        ProjCoordinate latLonLeftBottomCoord = new ProjCoordinate();
        ProjCoordinate latLonRightTopCoord = new ProjCoordinate();
        ProjCoordinate utmLeftBottomCoord = new ProjCoordinate((double)easting * sizeFactor, (double)northing * sizeFactor);
        ProjCoordinate utmRightTopCoord = new ProjCoordinate((double)(easting + 1) * sizeFactor, (double)(northing + 1) * sizeFactor);
        transformEastingNorthingToLatLon.transform(utmLeftBottomCoord, latLonLeftBottomCoord);
        transformEastingNorthingToLatLon.transform(utmRightTopCoord, latLonRightTopCoord);
        return new BoundingBox(latLonLeftBottomCoord.x, latLonLeftBottomCoord.y, latLonRightTopCoord.x, latLonRightTopCoord.y);
    }
}

