/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.lglbw;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LglBwExtractDownloadZips {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("LglBwExtractDownloadZips: a tool to extract the tiles of LglBW ZIP files.");
            System.out.println("    Mandatory config parameters:");
            System.out.println("    -in <input-directory> : the directory containing the downloaded ZIP files");
            System.out.println("    -out <output-directory> : the directory to write the extracted tiles to");
            return;
        }
        Optional<String> inputDirectory = LglBwExtractDownloadZips.getConfig("-in", args);
        if (!inputDirectory.isPresent()) {
            System.out.println("    Mandatory config parameter missing: -in <input-directory> ");
            return;
        }
        Optional<String> outputDirectory = LglBwExtractDownloadZips.getConfig("-out", args);
        if (!outputDirectory.isPresent()) {
            System.out.println("    Mandatory config parameter missing: -out <output-directory> ");
            return;
        }
        LglBwExtractDownloadZips.extractDownloadedZips(inputDirectory.get(), outputDirectory.get());
    }

    private static Optional<String> getConfig(String identifier, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!identifier.equals(args[i]) || i >= args.length - 1) continue;
            String result = args[i + 1];
            if (result == null || result.isBlank()) {
                return Optional.empty();
            }
            if (result.trim().startsWith("-")) {
                System.out.println("Identifier '" + identifier + "' was directly followed by the next identifier without a provided value");
                return Optional.empty();
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private static void extractDownloadedZips(String inputDirectoryString, String outputDirectoryString) {
        File[] files;
        File inputDirectory;
        File outputDirectory;
        if (outputDirectoryString.endsWith(File.separator)) {
            outputDirectoryString = outputDirectoryString.substring(0, outputDirectoryString.length() - 1);
        }
        if (!(outputDirectory = new File(outputDirectoryString)).exists()) {
            outputDirectory.mkdirs();
        }
        if (!outputDirectory.isDirectory()) {
            System.out.println("The given -out configuration is not a directory.");
        }
        if (!(inputDirectory = new File(inputDirectoryString)).exists()) {
            inputDirectory.mkdirs();
        }
        if (!inputDirectory.isDirectory()) {
            System.out.println("The given -in configuration is not a directory.");
        }
        int tileCounter = 0;
        for (File inputFile : files = inputDirectory.listFiles()) {
            if (inputFile.isDirectory() || !inputFile.getName().endsWith(".zip")) continue;
            System.out.println("    Extracting ZIP: " + inputFile.getAbsolutePath());
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(inputFile));){
                ZipEntry entry;
                byte[] buffer = new byte[1024];
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.getName().endsWith(".tif")) {
                        String entryName = entry.getName();
                        String[] entryFileNameParts = entry.getName().split(File.separator);
                        if (entryFileNameParts.length > 1) {
                            entryName = entryFileNameParts[entryFileNameParts.length - 1];
                        }
                        System.out.println("        Entry: " + entryName);
                        File extratedFile = new File(outputDirectoryString + File.separator + entryName);
                        try (FileOutputStream fos = new FileOutputStream(extratedFile);){
                            int length;
                            while ((length = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, length);
                            }
                        }
                    }
                    ++tileCounter;
                }
            }
            catch (Exception e) {
                System.out.println("Could not export ZIP file: " + inputFile.getAbsolutePath());
                e.printStackTrace();
            }
        }
        System.out.println("    Finished extraction of " + tileCounter + " tiles.");
    }
}

