/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.jaxa;

import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.jaxa.JaxaTile;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxaTileLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String folder;
    private String filePattern;
    private boolean zipped;
    private boolean mockMissingTiles;
    private int tileSizeForMock;

    public JaxaTileLoader(String folder, String filePattern, Boolean zipped, Boolean mockMissingTiles, Integer tileSizeForMock) {
        this.folder = folder;
        this.filePattern = filePattern;
        this.folder = this.folder.replaceAll("\\\\\\\\", "/");
        this.folder = this.folder.replaceAll("\\\\", "/");
        if (!this.folder.endsWith("/")) {
            this.folder = this.folder + "/";
        }
        this.zipped = zipped != null ? zipped : false;
        this.mockMissingTiles = mockMissingTiles != null ? mockMissingTiles : false;
        this.tileSizeForMock = tileSizeForMock != null ? tileSizeForMock : -1;
    }

    public JaxaTile loadTile(JaxaTile unloadedTile) {
        String tileName = this.getTileFileName(unloadedTile);
        String tileNameWithoutEnding = tileName.substring(0, tileName.indexOf("."));
        File jaxaFile = this.getJaxaFile(tileName);
        if (!jaxaFile.exists()) {
            if (this.mockMissingTiles) {
                this.log.info("loadTile: mocking missing JAXA tile file: " + tileName);
                unloadedTile.setMockedRawBuffer(this.tileSizeForMock, tileName);
                this.log.debug("loadTile: mocked missing tile file");
                return unloadedTile;
            }
            this.log.warn("loadTile: the required JAXA tile file does not exist: " + jaxaFile.getAbsolutePath());
            return null;
        }
        this.log.info("loadTile: loading raw JAXA tile " + tileName);
        BufferedImage bufferedImage = this.readerJaxaFile(jaxaFile, tileNameWithoutEnding);
        if (bufferedImage == null) {
            this.log.warn("loadTile: the required JAXA tile file could not be loaded, buffer was null: " + jaxaFile.getAbsolutePath());
            return null;
        }
        unloadedTile.setRawBuffer(bufferedImage, tileName);
        jaxaFile = null;
        bufferedImage = null;
        this.log.debug("loadTile: loaded JAXA tile " + tileName);
        return unloadedTile;
    }

    private String getTileFileName(ITile unloadedTile) {
        int lon = unloadedTile.getLon();
        int lat = unloadedTile.getLat();
        String northSouth = "";
        if (lat >= 0) {
            northSouth = "N";
        } else {
            northSouth = "S";
            lat = -lat;
        }
        String eastWest = "";
        if (lon >= 0) {
            eastWest = "E";
        } else {
            eastWest = "W";
            lon = -lon;
        }
        String latFormatted = this.fillNumber(lat, 3);
        String lonFormatted = this.fillNumber(lon, 3);
        String tileName = this.filePattern.replaceAll("\\[lat\\]", latFormatted);
        tileName = tileName.replaceAll("\\[lon\\]", lonFormatted);
        tileName = tileName.replaceAll("\\[NS\\]", northSouth);
        tileName = tileName.replaceAll("\\[EW\\]", eastWest);
        return tileName;
    }

    private File getJaxaFile(String tileFileName) {
        return new File(this.folder + tileFileName);
    }

    public boolean isTileFileExisting(ITile unloadedTile) {
        String tileName = this.getTileFileName(unloadedTile);
        File jaxaFile = this.getJaxaFile(tileName);
        return jaxaFile.exists();
    }

    private String fillNumber(int number, int length) {
        String result = String.format("%0" + length + "d", number);
        return result;
    }

    private BufferedImage readerJaxaFile(File jaxaFile, String latLonFilename) {
        if (this.zipped) {
            return this.readerJaxaFileZip(jaxaFile, latLonFilename);
        }
        return this.readerJaxaFilePlain(jaxaFile);
    }

    private BufferedImage readerJaxaFilePlain(File jaxaFile) {
        BufferedImage result = null;
        if (jaxaFile.exists()) {
            try {
                result = ImageIO.read(jaxaFile);
            }
            catch (Exception e) {
                this.log.error("readerJaxaFilePlain: could not load tile file: " + jaxaFile, (Throwable)e);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BufferedImage readerJaxaFileZip(File jaxaFile, String latLonFilename) {
        BufferedImage result = null;
        if (!jaxaFile.exists()) return result;
        try (FileInputStream fis = new FileInputStream(jaxaFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream stream = new ZipInputStream(bis);){
            ZipEntry entry = null;
            while ((entry = stream.getNextEntry()) != null) {
                String fileEnding;
                String entryLowercase = entry.getName().toLowerCase();
                if (!entryLowercase.endsWith(fileEnding = latLonFilename.toLowerCase() + "_dsm.tif")) continue;
                byte[] allBytes = stream.readAllBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(allBytes);
                try {
                    result = ImageIO.read(bais);
                    return result;
                }
                finally {
                    bais.close();
                    return result;
                }
            }
        }
        catch (Exception e) {
            this.log.error("readerJaxaFileZip: could not load tile file: " + jaxaFile, (Throwable)e);
        }
        return result;
    }
}

