/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.gebco;

import de.wideportal.maprender.resources.gebco.GebcoTile;
import de.wideportal.maprender.resources.height.ITile;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GebcoTileLoader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String folder;
    private String filePattern;
    private boolean zipped;
    private boolean mockMissingTiles;
    private int tileSizeForMock;

    public GebcoTileLoader(String folder, String filePattern, Boolean zipped, Boolean mockMissingTiles, Integer tileSizeForMock) {
        this.folder = folder;
        this.filePattern = filePattern;
        this.folder = this.folder.replaceAll("\\\\\\\\", "/");
        this.folder = this.folder.replaceAll("\\\\", "/");
        if (!this.folder.endsWith("/")) {
            this.folder = this.folder + "/";
        }
        this.zipped = zipped != null ? zipped : false;
        this.mockMissingTiles = mockMissingTiles != null ? mockMissingTiles : false;
        this.tileSizeForMock = tileSizeForMock != null ? tileSizeForMock : -1;
    }

    public GebcoTile loadTile(GebcoTile unloadedTile) {
        String tileName = this.getTileFileName(unloadedTile);
        String tileNameWithoutEnding = tileName.substring(0, tileName.indexOf("."));
        File gebcoFile = this.getGebcoFile(tileName);
        if (!gebcoFile.exists()) {
            if (this.mockMissingTiles) {
                this.log.info("loadTile: mocking missing Gebco tile file: " + tileName);
                unloadedTile.setMockedRawBuffer(this.tileSizeForMock, tileName);
                this.log.debug("loadTile: mocked missing tile file");
                return unloadedTile;
            }
            this.log.warn("loadTile: the required Gebco tile file does not exist: " + gebcoFile.getAbsolutePath());
            return null;
        }
        this.log.debug("loadTile: loading raw Gebco tile " + tileName);
        BufferedImage bufferedImage = this.readerJaxaFile(gebcoFile, tileNameWithoutEnding);
        if (bufferedImage == null) {
            this.log.warn("loadTile: the required Gebco tile file could not be loaded, buffer was null: " + gebcoFile.getAbsolutePath());
            return null;
        }
        unloadedTile.setRawBuffer(bufferedImage, tileName);
        gebcoFile = null;
        bufferedImage = null;
        this.log.info("loadTile: loaded Gebco tile " + tileName);
        return unloadedTile;
    }

    private String getTileFileName(ITile unloadedTile) {
        int lon = unloadedTile.getLon();
        int lat = unloadedTile.getLat();
        String north = "";
        String south = "";
        if (lat >= 0) {
            north = "90.0";
            south = "0.0";
        } else {
            north = "0.0";
            south = "-90.0";
        }
        String east = "";
        String west = "";
        if (lon < -180) {
            lon += 360;
        } else if (lon > 180) {
            lon -= 360;
        }
        if (lon >= -180 && lon < -90) {
            west = "-180.0";
            east = "-90.0";
        } else if (lon >= -90 && lon < 0) {
            west = "-90.0";
            east = "0.0";
        } else if (lon >= 0 && lon < 90) {
            west = "0.0";
            east = "90.0";
        } else if (lon >= 90 && lon < 180) {
            west = "90.0";
            east = "180.0";
        }
        String tileName = this.filePattern.replaceAll("\\[east\\]", east);
        tileName = tileName.replaceAll("\\[west\\]", west);
        tileName = tileName.replaceAll("\\[north\\]", north);
        tileName = tileName.replaceAll("\\[south\\]", south);
        return tileName;
    }

    private File getGebcoFile(String tileFileName) {
        return new File(this.folder + tileFileName);
    }

    public boolean isTileFileExisting(ITile unloadedTile) {
        String tileName = this.getTileFileName(unloadedTile);
        File gebcoFile = this.getGebcoFile(tileName);
        return gebcoFile.exists();
    }

    private BufferedImage readerJaxaFile(File gebcoFile, String latLonFilename) {
        if (this.zipped) {
            return this.readerGebcoFileZip(gebcoFile, latLonFilename);
        }
        return this.readerGebcoFilePlain(gebcoFile);
    }

    private BufferedImage readerGebcoFilePlain(File gebcoFile) {
        BufferedImage result = null;
        if (gebcoFile.exists()) {
            try {
                result = ImageIO.read(gebcoFile);
            }
            catch (Exception e) {
                this.log.error("readerGebcoFilePlain: could not load tile file: " + gebcoFile, (Throwable)e);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BufferedImage readerGebcoFileZip(File gebcoFile, String latLonFilename) {
        BufferedImage result = null;
        if (!gebcoFile.exists()) return result;
        try (FileInputStream fis = new FileInputStream(gebcoFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream stream = new ZipInputStream(bis);){
            ZipEntry entry = null;
            while ((entry = stream.getNextEntry()) != null) {
                String fileEnding;
                String entryLowercase = entry.getName().toLowerCase();
                if (!entryLowercase.endsWith(fileEnding = latLonFilename.toLowerCase() + "_dsm.tif")) continue;
                byte[] allBytes = stream.readAllBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(allBytes);
                try {
                    result = ImageIO.read(bais);
                    return result;
                }
                finally {
                    bais.close();
                    return result;
                }
            }
        }
        catch (Exception e) {
            this.log.error("readerGebcoFileZip: could not load tile file: " + gebcoFile, (Throwable)e);
        }
        return result;
    }
}

