/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.ftp;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationDataTargets;
import de.wideportal.maprender.config.xml.RenderConfigurationFtp;
import de.wideportal.maprender.resources.AbstractConnectableResource;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnector
implements AbstractConnectableResource {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderConfiguration configuration;
    private String server;
    private int port;
    private String username;
    private String password;
    private boolean useSftp = false;
    private boolean isUsable = false;
    private FTPClient ftp;
    private FTPSClient ftps;

    public FtpConnector(RenderConfiguration configuration) {
        this.configuration = configuration;
        this.getConfiguration();
    }

    private void getConfiguration() {
        RenderConfigurationFtp ftpConfig;
        RenderConfigurationDataTargets dataTargets = this.configuration.getMaprenderConfiguration().getDatatargets();
        if (dataTargets != null && (ftpConfig = dataTargets.getFtp()) != null) {
            this.server = ftpConfig.getServer();
            this.port = Integer.parseInt(ftpConfig.getPort());
            this.username = ftpConfig.getUsername();
            this.password = ftpConfig.getPassword();
            this.useSftp = ftpConfig.getSftp();
            if (this.isSet(this.server) && this.isSet(this.username) && this.isSet(this.password) && this.port > 0 && this.port <= 65535) {
                this.isUsable = true;
            }
        }
    }

    public FTPClient getClient() {
        if (this.ftps != null) {
            return this.ftps;
        }
        if (this.ftp != null) {
            return this.ftp;
        }
        return null;
    }

    public boolean isUsable() {
        return this.isUsable;
    }

    @Override
    public void connect() throws Exception {
        this.log.info("connect: trying to connect to ftp server: " + this.server + ":" + this.port);
        if (this.useSftp) {
            this.connectSftp();
        } else {
            this.connectFtp();
        }
    }

    public void connectFtp() throws Exception {
        this.log.info("connectFtp: trying to connect with normal FTP");
        this.ftp = new FTPClient();
        this.ftp.setControlKeepAliveReplyTimeout(5000);
        this.ftp.setControlKeepAliveTimeout(5L);
        this.ftp.setDataTimeout(5000);
        this.ftp.setDefaultTimeout(120000);
        try {
            this.ftp.connect(this.server, this.port);
            this.ftp.enterLocalPassiveMode();
            int reply = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftp.disconnect();
                this.log.error("connectFtp: could not connect to server. Server responded with code: " + reply + ". See FTPReply for codes.");
                this.isUsable = false;
                return;
            }
            boolean loginSuccess = this.ftp.login(this.username, this.password);
            if (loginSuccess) {
                this.log.info("connectFtp: successfully login to server with username: " + this.username);
                this.isUsable = true;
            } else {
                this.log.error("connectFtp: login was not successfull with username: " + this.username);
                this.isUsable = false;
            }
            this.ftp.setControlKeepAliveReplyTimeout(5000);
            this.ftp.setControlKeepAliveTimeout(5L);
            this.ftp.setDataTimeout(5000);
            this.ftp.setKeepAlive(true);
            this.ftp.setSoTimeout(120000);
            this.ftp.setFileType(2, 2);
            this.ftp.setFileTransferMode(2);
        }
        catch (IOException e) {
            this.log.error("connectFtp: an exception occured when trying to login to ftp server.");
            this.isUsable = false;
            throw e;
        }
    }

    public void connectSftp() throws Exception {
        this.log.info("connectSftp: trying to connect with secure FTP");
        this.ftps = new FTPSClient();
        this.ftps.setControlKeepAliveReplyTimeout(5000);
        this.ftps.setControlKeepAliveTimeout(5L);
        this.ftps.setDataTimeout(5000);
        this.ftps.setDefaultTimeout(120000);
        try {
            this.ftps.connect(this.server, this.port);
            this.ftps.enterLocalPassiveMode();
            int reply = this.ftps.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftps.disconnect();
                this.log.error("connectSftp: could not connect to server. Server responded with code: " + reply + ". See FTPReply for codes.");
                this.isUsable = false;
                return;
            }
            boolean loginSuccess = this.ftps.login(this.username, this.password);
            if (loginSuccess) {
                this.log.info("connectSftp: successfully login to server with username: " + this.username);
                this.isUsable = true;
            } else {
                this.log.error("connectSftp: login was not successfull with username: " + this.username);
                this.isUsable = false;
            }
            this.ftps.setControlKeepAliveReplyTimeout(5000);
            this.ftps.setControlKeepAliveTimeout(5L);
            this.ftps.setDataTimeout(5000);
            this.ftps.setKeepAlive(true);
            this.ftps.setSoTimeout(120000);
            this.ftps.setFileType(2, 2);
            this.ftps.setFileTransferMode(2);
        }
        catch (IOException e) {
            this.log.error("connectSftp: an exception occured when trying to login to ftp server.");
            this.isUsable = false;
            throw e;
        }
    }

    @Override
    public void disconnect() {
        this.log.info("disconnect: trying to disconnect from ftp server");
        try {
            if (this.useSftp) {
                if (this.ftps != null && this.ftps.isConnected()) {
                    this.ftps.disconnect();
                }
            } else if (this.ftp != null && this.ftp.isConnected()) {
                this.ftp.disconnect();
            }
            this.log.info("disconnect: disconnected from ftp server");
        }
        catch (Exception e) {
            this.log.error("disconnect: an exception occured when trying to disconnect from server", (Throwable)e);
        }
        this.isUsable = false;
    }

    private boolean isSet(String value) {
        return value != null && !value.trim().isEmpty();
    }
}

