/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.fonts;

import de.wideportal.maprender.config.xml.osm.OsmFontSet;
import de.wideportal.maprender.config.xml.osm.accessor.IOsmTextAccessor;
import de.wideportal.maprender.request.RenderRequest;
import java.awt.Font;
import java.util.Map;
import java.util.Optional;

public class FontContext {
    Optional<OsmFontSet> optionalFontSet;
    Map<String, Font> loadedFonts;
    Optional<String> fontsetName;
    Optional<String> faceName;
    int faceStyle;
    double fontSize;

    public FontContext(RenderRequest renderRequest, IOsmTextAccessor textSymbolizer) {
        this.loadedFonts = renderRequest.getRenderConfiguration().getLoadedFonts();
        this.fontsetName = textSymbolizer.getFontsetName();
        this.fontSize = textSymbolizer.getSize();
        this.faceName = textSymbolizer.getFaceName();
        this.faceStyle = textSymbolizer.getFaceStyle();
        this.optionalFontSet = renderRequest.getOsmMap().findFontSet(this.fontsetName);
    }

    private FontContext(FontContext other) {
        this.loadedFonts = other.getLoadedFonts();
        this.fontsetName = other.getFontsetName();
        this.faceName = other.getFaceName();
        this.fontSize = other.fontSize;
        this.faceStyle = other.getFaceStyle();
        this.optionalFontSet = other.getOptionalFontSet();
    }

    public FontContext(FontContext other, double fontSize) {
        this.loadedFonts = other.getLoadedFonts();
        this.fontsetName = other.getFontsetName();
        this.faceName = other.getFaceName();
        this.fontSize = fontSize;
        this.faceStyle = other.getFaceStyle();
        this.optionalFontSet = other.getOptionalFontSet();
    }

    public Map<String, Font> getLoadedFonts() {
        return this.loadedFonts;
    }

    public Optional<String> getFontsetName() {
        return this.fontsetName;
    }

    public Optional<String> getFaceName() {
        return this.faceName;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public int getFaceStyle() {
        return this.faceStyle;
    }

    public void setFaceStyle(int faceStyle) {
        this.faceStyle = faceStyle;
    }

    public Optional<OsmFontSet> getOptionalFontSet() {
        return this.optionalFontSet;
    }

    public FontContext clone() {
        return new FontContext(this);
    }
}

