/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.file;

import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.file.FileAccessor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoader
extends FileAccessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public Optional<BufferedImage> loadOsmTile(RenderRequest renderRequest, String baseFolder) {
        return this.loadOsmTile(renderRequest, baseFolder, true);
    }

    public Optional<BufferedImage> loadOsmTile(RenderRequest renderRequest, String baseFolder, boolean verbose) {
        this.log.debug("loadOsmTile: baseFolder=" + baseFolder + ", zoom=" + renderRequest.getZoomInfo().getZoom() + " / tileIndex=" + renderRequest.getTileIndex() + " / bbox" + renderRequest.getBoundingBoxLatLon());
        int zoom = (int)renderRequest.getZoomInfo().getZoom();
        int xIndex = (int)renderRequest.getTileIndex().getX();
        int yIndex = (int)renderRequest.getTileIndex().getY();
        String fileType = "png";
        Optional<File> optionalYFile = this.getFile(baseFolder, zoom, xIndex, yIndex, fileType, false);
        if (!optionalYFile.isPresent()) {
            if (verbose) {
                this.log.error("loadOsmTile: file is not accessible. Cannot load tile. Base folder is: " + baseFolder + ", zoom=" + zoom + ", x=" + xIndex + ", y=" + yIndex);
            }
            return Optional.empty();
        }
        File yFile = optionalYFile.get();
        if (!yFile.exists()) {
            fileType = "jpg";
            optionalYFile = this.getFile(baseFolder, zoom, xIndex, yIndex, fileType, false);
            yFile = optionalYFile.get();
        }
        if (!yFile.exists()) {
            fileType = "bmp";
            optionalYFile = this.getFile(baseFolder, zoom, xIndex, yIndex, fileType, false);
            yFile = optionalYFile.get();
        }
        if (!yFile.exists()) {
            if (verbose) {
                this.log.error("loadOsmTile: No fitting image file (png, jpg, bmp) found: " + yFile.getAbsolutePath());
            }
            return Optional.empty();
        }
        Optional<Object> result = Optional.empty();
        try {
            result = Optional.ofNullable(ImageIO.read(yFile));
            if (!result.isPresent() && verbose) {
                this.log.error("loadOsmTile: could not read image file: " + yFile.getAbsolutePath() + ", canRead=" + yFile.canRead());
            }
        }
        catch (Exception e) {
            this.log.error("loadOsmTile: could not read image file: " + yFile.getAbsolutePath() + ", canRead=" + yFile.canRead(), (Throwable)e);
        }
        return result;
    }

    public Optional<BufferedImage> loadOsmTile(String fileString) {
        File osmTileFile = new File(fileString);
        if (!osmTileFile.exists()) {
            this.log.error("loadOsmTile: file is not accessible. Cannot load tile. File is: " + fileString);
            return Optional.empty();
        }
        Optional<BufferedImage> result = Optional.empty();
        try {
            result = Optional.ofNullable(ImageIO.read(osmTileFile));
        }
        catch (Exception e) {
            this.log.error("loadOsmTile: could not read image file: " + osmTileFile.getAbsolutePath() + ", canRead=" + osmTileFile.canRead(), (Throwable)e);
        }
        return result;
    }
}

