/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderRequestZoomLevelProgress {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private long tilesCount = 0L;
    private long tilesDone = 0L;
    private long tilesFailed = 0L;
    private long tilesDoneAtStart = 0L;
    private int zoom = 0;

    public RenderRequestZoomLevelProgress(int zoom, long tilesCount) {
        this.zoom = zoom;
        this.tilesCount = tilesCount;
    }

    public long getTilesCount() {
        return this.tilesCount;
    }

    public void setTilesCount(long tilesCount) {
        this.tilesCount = tilesCount;
    }

    public boolean isDone() {
        return this.tilesCount <= this.tilesDone + this.tilesFailed;
    }

    public void addTileDone() {
        ++this.tilesDone;
    }

    public void addTileFailed() {
        ++this.tilesFailed;
    }

    public void addTilesDone(long tilesCount) {
        this.tilesDone += tilesCount;
    }

    public void addTilesFailed(long tilesFailed) {
        this.tilesFailed += tilesFailed;
    }

    public long getTilesDoneAtStart() {
        return this.tilesDoneAtStart;
    }

    public void setTilesDoneAtStart(long tilesDoneAtStart) {
        this.tilesDoneAtStart = tilesDoneAtStart;
    }

    public long getTilesDone() {
        return this.tilesDone;
    }

    public long getTilesFailed() {
        return this.tilesFailed;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public String toString() {
        return "RenderRequestZoomLevelProgress[zoom=" + this.zoom + ", tilesCount=" + this.tilesCount + ", tilesDone=" + this.tilesDone + ", tilesFailed=" + this.tilesFailed + ", tilesDoneAtStart=" + this.tilesDoneAtStart + "]";
    }
}

