/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.datasource.IRenderDatasource;
import de.wideportal.maprender.metrics.PerformanceMetrics;
import de.wideportal.maprender.request.RenderManager;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.request.RenderRequestAllJobsProgress;
import de.wideportal.maprender.request.RenderRequestLinkedBlockingQueue;
import de.wideportal.maprender.request.RenderRequestThread;
import de.wideportal.maprender.request.RenderRequestThreadBalancer;
import de.wideportal.maprender.request.RenderRequestThreadPoolExecutor;
import de.wideportal.maprender.resources.ConnectableResourceManager;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderRequestThreadManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderRequestThreadPoolExecutor threadPoolExecutor;
    private RenderRequestLinkedBlockingQueue<Runnable> blockingQueue;
    private IRenderDatasource datasource;
    private ConnectableResourceManager connectableResourceManager;
    private RenderManager allThreadsFinishedCallback;
    private PerformanceMetrics performanceMetrics;
    private RenderRequestAllJobsProgress progressMonitor;
    private RenderRequestThreadBalancer renderRequestThreadBalancer;
    boolean isThreadCountAutoDetectionConfigured = false;
    private long threadCompletedCounter = 0L;

    public RenderRequestThreadManager(RenderConfiguration configuration, IRenderDatasource datasource, ConnectableResourceManager connectableResourceManager, PerformanceMetrics performanceMetrics, RenderManager allThreadsFinishedCallback, RenderRequestAllJobsProgress progressMonitor) {
        this.datasource = datasource;
        this.connectableResourceManager = connectableResourceManager;
        this.allThreadsFinishedCallback = allThreadsFinishedCallback;
        this.performanceMetrics = performanceMetrics;
        this.progressMonitor = progressMonitor;
        this.renderRequestThreadBalancer = new RenderRequestThreadBalancer();
        int threadCount = 1;
        if (configuration.getMaprenderConfiguration().getProcessing() != null && configuration.getMaprenderConfiguration().getProcessing().getThreads() != null && (threadCount = configuration.getMaprenderConfiguration().getProcessing().getThreads().intValue()) == 0) {
            this.isThreadCountAutoDetectionConfigured = true;
            threadCount = 1;
        }
        this.log.info("RenderRequestThreadManager: initialized with threadCount=" + threadCount);
        this.blockingQueue = new RenderRequestLinkedBlockingQueue(threadCount);
        this.threadPoolExecutor = new RenderRequestThreadPoolExecutor(threadCount, threadCount, 10000L, TimeUnit.MILLISECONDS, this.blockingQueue);
        this.threadPoolExecutor.setThreadManager(this);
        this.threadPoolExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    RenderRequestThreadManager.this.log.error("RenderRequestThreadPool: interrupted", (Throwable)e);
                }
            }
        });
    }

    public void addRenderRequestToQueue(RenderRequest renderRequest) {
        RenderRequestThread renderRequestThread = new RenderRequestThread(renderRequest, this.performanceMetrics);
        this.threadPoolExecutor.execute(renderRequestThread);
    }

    public void notifiyThreadFinished(double zoom, int activeThreadCount, long duration) {
        int currentParallelThreadsCount;
        int newParallelThreadCount;
        ++this.threadCompletedCounter;
        if (this.isThreadCountAutoDetectionConfigured && (newParallelThreadCount = this.renderRequestThreadBalancer.recalculateParallelThreadCount(currentParallelThreadsCount = this.blockingQueue.getCapacity(), this.threadCompletedCounter, zoom, duration)) != currentParallelThreadsCount) {
            this.log.debug("notifiyThreadFinished: recalculated parallel thread count: " + currentParallelThreadsCount + " -> " + newParallelThreadCount);
            this.setMaxParallelThreadCount(newParallelThreadCount);
            this.performanceMetrics.setDynamicParallelThreadCount(newParallelThreadCount);
        }
        if (this.progressMonitor.isAllDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.threadPoolExecutor.shutdown();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.allThreadsFinishedCallback.allThreadsFinishedCallback(this.datasource, this.connectableResourceManager, this.performanceMetrics);
        }
    }

    public void setMaxParallelThreadCount(int maxParallelThreadCount) {
        this.blockingQueue.setCapacity(maxParallelThreadCount);
    }

    public int getCurrentMaxParallelThreadCount() {
        return this.blockingQueue.getCapacity();
    }

    public void forceShutdown() {
        this.threadPoolExecutor.shutdown();
        this.allThreadsFinishedCallback.allThreadsFinishedCallback(this.datasource, this.connectableResourceManager, this.performanceMetrics);
    }
}

