/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderRequestThreadBalancer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MORE = 1;
    private static final int SAME = 0;
    private static final int LESS = -1;
    private static final int SKIPPED = -2;
    private long threadCompletedCounter = 0L;
    private long lastThreadCountReconfigurationCounter = 0L;
    private double currentZoom = 0.0;
    private long lastRecalculateTimestamp = System.currentTimeMillis();
    private double lastRecalculateThreadsPerSecond = 0.0;
    private int lastRecalculateChange = 0;

    public int recalculateParallelThreadCount(int currentParallelThreadsCount, long threadCompletedCounter, double zoom, long currentThreadDuration) {
        this.threadCompletedCounter = threadCompletedCounter;
        if (zoom > this.currentZoom) {
            this.currentZoom = zoom;
            return currentParallelThreadsCount;
        }
        if (zoom < this.currentZoom) {
            return currentParallelThreadsCount;
        }
        if (this.lastThreadCountReconfigurationCounter + (long)currentParallelThreadsCount < this.threadCompletedCounter) {
            long now = System.currentTimeMillis();
            long timeSinceLastRecalculatedTimestamp = now - this.lastRecalculateTimestamp;
            int newParallelThreadsCount = currentParallelThreadsCount;
            double threadsPerSecond = (double)currentParallelThreadsCount / ((double)timeSinceLastRecalculatedTimestamp / 1000.0);
            if (this.lastRecalculateChange == 1 || this.lastRecalculateChange == -1) {
                this.lastRecalculateChange = -2;
            } else {
                boolean isStillCpuFree;
                int renderingSpeedChange = 0;
                renderingSpeedChange = threadsPerSecond > this.lastRecalculateThreadsPerSecond * 1.1 ? 1 : (threadsPerSecond < this.lastRecalculateThreadsPerSecond * 0.7 ? -1 : 0);
                long availableProcessors = Runtime.getRuntime().availableProcessors();
                long maxMemory = Runtime.getRuntime().maxMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                long memoryUsedByEachThread = totalMemory / (long)currentParallelThreadsCount;
                long remainingFreeSpace = maxMemory - totalMemory;
                boolean isStillSufficientMemoryFree = remainingFreeSpace > memoryUsedByEachThread;
                boolean bl = isStillCpuFree = availableProcessors >= (long)(currentParallelThreadsCount + 1);
                if (isStillSufficientMemoryFree && isStillCpuFree) {
                    if (renderingSpeedChange == 1) {
                        boolean wouldCpuStillBeFree;
                        boolean bl2 = wouldCpuStillBeFree = availableProcessors >= (long)(newParallelThreadsCount + 2);
                        if (wouldCpuStillBeFree) {
                            ++newParallelThreadsCount;
                            this.lastRecalculateChange = 1;
                        } else {
                            this.lastRecalculateChange = 0;
                        }
                    } else if (renderingSpeedChange == -1) {
                        newParallelThreadsCount -= 3;
                        this.lastRecalculateChange = -1;
                    } else if (renderingSpeedChange == 0) {
                        boolean wouldCpuStillBeFree;
                        boolean bl3 = wouldCpuStillBeFree = availableProcessors >= (long)(newParallelThreadsCount + 2);
                        if (wouldCpuStillBeFree) {
                            ++newParallelThreadsCount;
                            this.lastRecalculateChange = 1;
                        } else {
                            this.lastRecalculateChange = 0;
                        }
                    } else {
                        this.lastRecalculateChange = 0;
                    }
                } else if (!isStillCpuFree) {
                    --newParallelThreadsCount;
                    this.lastRecalculateChange = -1;
                    this.log.info("RenderRequestThreadBalancer: newParallelThreadsCount-- (memOk cpuFAIL MORE)");
                } else {
                    this.lastRecalculateChange = 0;
                }
            }
            newParallelThreadsCount = Math.max(1, newParallelThreadsCount);
            this.lastThreadCountReconfigurationCounter = currentParallelThreadsCount;
            this.lastRecalculateTimestamp = System.currentTimeMillis();
            this.lastRecalculateThreadsPerSecond = threadsPerSecond;
            return newParallelThreadsCount;
        }
        return currentParallelThreadsCount;
    }
}

