/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import de.wideportal.maprender.datasource.DatasourceRequest;
import de.wideportal.maprender.metrics.PerformanceMetrics;
import de.wideportal.maprender.metrics.StopWatch;
import de.wideportal.maprender.renderer.OsmRenderer;
import de.wideportal.maprender.renderer.progress.RenderProgressTracking;
import de.wideportal.maprender.request.RenderRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderRequestThread
implements Runnable {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderRequest renderRequest;
    private PerformanceMetrics performanceMetrics;
    private long duration = -1L;

    public RenderRequestThread(RenderRequest renderRequest, PerformanceMetrics performanceMetrics) {
        this.renderRequest = renderRequest;
        this.performanceMetrics = performanceMetrics;
    }

    public RenderRequest getRenderRequest() {
        return this.renderRequest;
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public void run() {
        try {
            long startRun = System.currentTimeMillis();
            boolean useMetric = this.renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing().getMetrics();
            StopWatch totalStopWatch = StopWatch.start(useMetric);
            StopWatch renderStopWatch = StopWatch.start(useMetric);
            DatasourceRequest datasourceRequest = this.renderRequest.getDatasource().getNewRequest();
            OsmRenderer renderer = new OsmRenderer();
            boolean exceptionInRenderer = false;
            try {
                renderer.render(this.renderRequest, datasourceRequest);
            }
            catch (Exception exInter) {
                this.log.error("run: unexpected exception occured in thread during rendering which most likely prevented the tile rendering. Closing thread now", (Throwable)exInter);
                exceptionInRenderer = true;
                this.renderRequest.getJobProgressMonitor().addTileFailed((int)this.renderRequest.getZoomInfo().getZoom());
            }
            renderStopWatch.stop("tile-render-zoom-" + (int)this.renderRequest.getZoomInfo().getZoom(), useMetric);
            this.renderRequest.getThreadPerformanceMetrics().addMetric("tile-render", renderStopWatch, useMetric);
            StopWatch renderProgressTrackStopWatch = StopWatch.start(useMetric);
            RenderProgressTracking renderProgressTracking = this.renderRequest.getRenderProgressTracking();
            if (renderProgressTracking.isTrackingConfigured() && !exceptionInRenderer) {
                renderProgressTracking.trackRenderRequestCompleted(this.renderRequest);
            }
            renderProgressTrackStopWatch.stop("tile-cleanup-zoom-" + (int)this.renderRequest.getZoomInfo().getZoom(), useMetric);
            this.renderRequest.getThreadPerformanceMetrics().addMetric("tile-render-process-tracking", renderProgressTrackStopWatch, useMetric);
            StopWatch cleanupStopWatch = StopWatch.start(useMetric);
            datasourceRequest.releaseConnection();
            this.renderRequest.cleanup();
            cleanupStopWatch.stop("tile-cleanup-zoom-" + (int)this.renderRequest.getZoomInfo().getZoom(), useMetric);
            this.renderRequest.getThreadPerformanceMetrics().addMetric("tile-cleanup", cleanupStopWatch, useMetric);
            totalStopWatch.stop("tile-total-zoom-" + (int)this.renderRequest.getZoomInfo().getZoom(), useMetric);
            this.renderRequest.getThreadPerformanceMetrics().addMetric("tile-total", totalStopWatch, useMetric);
            this.renderRequest.getJobProgressMonitor().addTileDone((int)this.renderRequest.getZoomInfo().getZoom());
            this.performanceMetrics.getZoomLevelPerformanceMetric(this.renderRequest.getZoomInfo().getZoom()).addThreadPerfomanceMetrics(this.renderRequest.getThreadPerformanceMetrics());
            long stopRun = System.currentTimeMillis();
            this.duration = stopRun - startRun;
        }
        catch (Exception ex) {
            this.log.error("run: unexpected exception occured in thread management which most likely will prevent clean shutdown of the renderer", (Throwable)ex);
        }
    }
}

