/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.osm.accessor.OsmMapAccessor;
import de.wideportal.maprender.datasource.IRenderDatasource;
import de.wideportal.maprender.datasource.osm.PostgresCache;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.licenselib.LicenseContainer;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.metrics.PerformanceMetrics;
import de.wideportal.maprender.metrics.ThreadPerformanceMetrics;
import de.wideportal.maprender.renderer.blocking.RenderOverlapManager;
import de.wideportal.maprender.renderer.progress.RenderProgressTracking;
import de.wideportal.maprender.request.RenderImage;
import de.wideportal.maprender.request.RenderRequestJobProgress;
import de.wideportal.maprender.request.RenderRequestZoomInfo;
import de.wideportal.maprender.resources.ConnectableResourceManager;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.kml.KmlFileCache;
import de.wideportal.maprender.resources.output.RenderOutputQueue;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;

public class RenderRequest {
    private long renderRequestNumber;
    private long totalRenderRequests;
    private long zoomLevelRenderRequestNumber;
    private long zoomLevelStartTimestampNanos;
    private long totalZoomLevelRenderRequests;
    private OsmMapAccessor osmMap;
    private BoundingBox boundingBoxLatLon;
    private BoundingBox boundingBoxMercator;
    private BoundingBox boundingBoxPixel;
    private RenderRequestZoomInfo zoomInfo;
    private double scaleDenominator;
    private RenderConfiguration renderConfiguration;
    private Point tileIndex;
    private RenderImage renderImage;
    private GeoCalculator geoCalculator;
    private String capsulatedQuery;
    private String capsulatedQueryBBox;
    private RenderOverlapManager renderOverlapManager;
    private PerformanceMetrics performanceMetrics;
    private ThreadPerformanceMetrics threadPerformanceMetrics;
    private IRenderDatasource datasource;
    private KmlFileCache kmlFileCache;
    private ConnectableResourceManager connectableResourceManager;
    private RenderRequestJobProgress jobProgressMonitor;
    private RenderOutputQueue renderOutputQueue;
    private AbstractMapTileOutput tileOutputter;
    private LicenseContainer license;
    private RenderProgressTracking renderProgressTracking;
    private HeightTileAccessor heightTileAccessor;
    private PostgresCache postgresCache;

    public RenderRequest(OsmMapAccessor osmMap, RenderRequestZoomInfo zoomInfo, BoundingBox boundingBoxLatLon, double scaleDenominator, Point tileIndex, RenderConfiguration renderConfiguration, long renderRequestNumber, long totalRenderRequests, long zoomLevelRenderRequestNumber, long zoomLevelStartTimestampNanos, long totalZoomLevelRenderRequests, HeightTileAccessor heightTileAccessor, PerformanceMetrics performanceMetrics, IRenderDatasource datasource, KmlFileCache kmlFileCache, ConnectableResourceManager connectableResourceManager, RenderRequestJobProgress jobProgressMonitor, RenderOutputQueue renderOutputQueue, AbstractMapTileOutput tileOutputter, LicenseContainer license, RenderProgressTracking renderProgressTracking, PostgresCache postgresCache) {
        this.osmMap = osmMap;
        this.zoomInfo = zoomInfo;
        this.scaleDenominator = scaleDenominator;
        this.boundingBoxLatLon = boundingBoxLatLon;
        this.renderConfiguration = renderConfiguration;
        this.tileIndex = tileIndex;
        this.geoCalculator = new GeoCalculator();
        this.boundingBoxMercator = this.geoCalculator.convertLatLonToMercator(boundingBoxLatLon);
        this.boundingBoxPixel = new BoundingBox(0.0, tileOutputter.getTileSize(), tileOutputter.getTileSize(), 0.0);
        this.renderImage = new RenderImage(osmMap, tileOutputter.getTileSize());
        this.renderOverlapManager = new RenderOverlapManager();
        this.renderRequestNumber = renderRequestNumber;
        this.totalRenderRequests = totalRenderRequests;
        this.zoomLevelRenderRequestNumber = zoomLevelRenderRequestNumber;
        this.zoomLevelStartTimestampNanos = zoomLevelStartTimestampNanos;
        this.totalZoomLevelRenderRequests = totalZoomLevelRenderRequests;
        this.performanceMetrics = performanceMetrics;
        this.threadPerformanceMetrics = new ThreadPerformanceMetrics();
        this.datasource = datasource;
        this.kmlFileCache = kmlFileCache;
        this.connectableResourceManager = connectableResourceManager;
        this.jobProgressMonitor = jobProgressMonitor;
        this.renderOutputQueue = renderOutputQueue;
        this.tileOutputter = tileOutputter;
        this.license = license;
        this.renderProgressTracking = renderProgressTracking;
        this.heightTileAccessor = heightTileAccessor;
        this.postgresCache = postgresCache;
    }

    public double getScaleDenominator() {
        return this.scaleDenominator;
    }

    public void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public void saveRenderedImage() {
        this.renderOutputQueue.persistAllTiles(this);
    }

    public OsmMapAccessor getOsmMap() {
        return this.osmMap;
    }

    public void setOsmMap(OsmMapAccessor osmMap) {
        this.osmMap = osmMap;
    }

    public BoundingBox getBoundingBoxLatLon() {
        return this.boundingBoxLatLon;
    }

    public void setBoundingBoxLatLon(BoundingBox boundingBoxLatLon) {
        this.boundingBoxLatLon = boundingBoxLatLon;
    }

    public BoundingBox getBoundingBoxMercator() {
        return this.boundingBoxMercator;
    }

    public BoundingBox getBoundingBoxPixel() {
        return this.boundingBoxPixel.clone();
    }

    public void setBoundingBoxMercator(BoundingBox boundingBoxMercator) {
        this.boundingBoxMercator = boundingBoxMercator;
    }

    public RenderRequestZoomInfo getZoomInfo() {
        return this.zoomInfo;
    }

    public RenderConfiguration getRenderConfiguration() {
        return this.renderConfiguration;
    }

    public Point getTileIndex() {
        return this.tileIndex;
    }

    public void setTileIndex(Point tileIndex) {
        this.tileIndex = tileIndex;
    }

    public void setRenderConfiguration(RenderConfiguration renderConfiguration) {
        this.renderConfiguration = renderConfiguration;
    }

    public RenderImage getRenderImage() {
        return this.renderImage;
    }

    public void setRenderImage(RenderImage renderImage) {
        this.renderImage = renderImage;
    }

    public GeoCalculator getGeoCalculator() {
        return this.geoCalculator;
    }

    public String getCapsulatedQuery() {
        return this.capsulatedQuery;
    }

    public void setCapsulatedQuery(String capsulatedQuery) {
        this.capsulatedQuery = capsulatedQuery;
    }

    public String getCapsulatedQueryBBox() {
        return this.capsulatedQueryBBox;
    }

    public void setCapsulatedQueryBBox(String capsulatedQueryBBox) {
        this.capsulatedQueryBBox = capsulatedQueryBBox;
    }

    public RenderOverlapManager getRenderOverlapManager() {
        return this.renderOverlapManager;
    }

    public long getRenderRequestNumber() {
        return this.renderRequestNumber;
    }

    public long getTotalRenderRequests() {
        return this.totalRenderRequests;
    }

    public HeightTileAccessor getHeightTileAccessor() {
        return this.heightTileAccessor;
    }

    public void setHeightTileAccessor(HeightTileAccessor heightTileAccessor) {
        this.heightTileAccessor = heightTileAccessor;
    }

    public long getZoomLevelRenderRequestNumber() {
        return this.zoomLevelRenderRequestNumber;
    }

    public long getTotalZoomLevelRenderRequests() {
        return this.totalZoomLevelRenderRequests;
    }

    public ThreadPerformanceMetrics getThreadPerformanceMetrics() {
        return this.threadPerformanceMetrics;
    }

    public PerformanceMetrics getPerformanceMetrics() {
        return this.performanceMetrics;
    }

    public IRenderDatasource getDatasource() {
        return this.datasource;
    }

    public long getZoomLevelStartTimestampNanos() {
        return this.zoomLevelStartTimestampNanos;
    }

    public KmlFileCache getKmlFileCache() {
        return this.kmlFileCache;
    }

    public ConnectableResourceManager getConnectableResourceManager() {
        return this.connectableResourceManager;
    }

    public RenderRequestJobProgress getJobProgressMonitor() {
        return this.jobProgressMonitor;
    }

    public AbstractMapTileOutput getTileOutputter() {
        return this.tileOutputter;
    }

    public LicenseContainer getLicense() {
        return this.license;
    }

    public RenderProgressTracking getRenderProgressTracking() {
        return this.renderProgressTracking;
    }

    public PostgresCache getPostgresCache() {
        return this.postgresCache;
    }

    public void cleanup() {
        this.osmMap = null;
        this.boundingBoxLatLon = null;
        this.renderConfiguration = null;
        this.tileIndex = null;
        this.geoCalculator = null;
        this.boundingBoxMercator = null;
        this.renderImage.cleanup();
        this.renderImage = null;
    }

    public String toString() {
        return "RenderRequest[" + this.renderRequestNumber + " of " + this.totalRenderRequests + ", zoomInfo=" + this.zoomInfo + ", boundingBoxLatLon=" + this.boundingBoxLatLon + ", scaleDenominator=" + this.scaleDenominator + ", tileIndex=" + this.tileIndex + "]";
    }
}

