/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import de.wideportal.maprender.config.ConfigurationException;
import de.wideportal.maprender.config.ConfigurationLoader;
import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.config.xml.osm.OsmDatasource;
import de.wideportal.maprender.config.xml.osm.OsmLayer;
import de.wideportal.maprender.config.xml.osm.OsmMap;
import de.wideportal.maprender.config.xml.osm.OsmParameter;
import de.wideportal.maprender.config.xml.osm.accessor.OsmLayerAccessor;
import de.wideportal.maprender.config.xml.osm.imagefilter.LicenseWatermarkFilter;
import de.wideportal.maprender.datasource.DatasourceException;
import de.wideportal.maprender.datasource.IRenderDatasource;
import de.wideportal.maprender.datasource.PooledRenderDatasource;
import de.wideportal.maprender.datasource.osm.PostgresCache;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.licenselib.LicenseCheck;
import de.wideportal.maprender.licenselib.LicenseContainer;
import de.wideportal.maprender.licenselib.exceptions.LicenseException;
import de.wideportal.maprender.manifest.ManifestAccessor;
import de.wideportal.maprender.metrics.PerformanceMetrics;
import de.wideportal.maprender.metrics.StopWatch;
import de.wideportal.maprender.renderer.progress.RenderProgressTracking;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.request.RenderRequestAllJobsProgress;
import de.wideportal.maprender.request.RenderRequestJobProgress;
import de.wideportal.maprender.request.RenderRequestThreadManager;
import de.wideportal.maprender.request.RenderRequestZoomInfo;
import de.wideportal.maprender.request.RenderRequestZoomLevelProgress;
import de.wideportal.maprender.resources.ConnectableResourceManager;
import de.wideportal.maprender.resources.file.FileLoader;
import de.wideportal.maprender.resources.fonts.FontsLoader;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.kml.KmlFileCache;
import de.wideportal.maprender.resources.output.RenderOutputQueue;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.output.format.OutputFormatFactory;
import de.wideportal.maprender.resources.symbols.SymbolsCache;
import de.wideportal.maprender.server.EmbeddedJettyServer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static RenderManager singleton;
    private ConfigurationLoader configurationLoader = new ConfigurationLoader();
    private StopWatch totalDurationStopwatch;
    private RenderRequestAllJobsProgress progressMonitor = new RenderRequestAllJobsProgress();
    boolean allThreadsFinishedCallbackReceived = false;
    private EmbeddedJettyServer embeddedJettyServer = null;

    public static RenderManager getSingleton() {
        if (singleton == null) {
            singleton = new RenderManager();
        }
        return singleton;
    }

    private RenderManager() {
    }

    public void setEmbeddedJettyServer(EmbeddedJettyServer embeddedJettyServer) {
        this.embeddedJettyServer = embeddedJettyServer;
    }

    public void startRendering(String configurationFile, String licenseFile) throws ConfigurationException, DatasourceException {
        this.log.info("startRendering: configurationFile=" + configurationFile + ", licenseFile=" + licenseFile);
        LicenseContainer license = null;
        try {
            license = this.checkLicense(licenseFile);
        }
        catch (LicenseException le) {
            this.log.error("startRendering: no valid license found. Exiting.");
            return;
        }
        try {
            this.logMaprenderInfo();
        }
        catch (Exception e) {
            this.log.error("startRendering: Could not log maprender information. This will not prevent the functionality, but should be checked!");
        }
        RenderConfiguration configuration = this.configurationLoader.loadConfiguration(configurationFile);
        boolean isBasicConfigurationAvailable = true;
        if (configuration.getMaprenderConfiguration().getProcessing() == null) {
            this.log.warn("startRendering: you need to configure the 'processing' element for rendering.");
            isBasicConfigurationAvailable = false;
        }
        if (configuration.getMaprenderConfiguration().getDatasources() == null) {
            this.log.warn("startRendering: you need to configure the 'datasources' element for rendering.");
            isBasicConfigurationAvailable = false;
        }
        if (configuration.getMaprenderConfiguration().getBounds() == null) {
            this.log.warn("startRendering: you need to configure the 'bounds' element for rendering.");
            isBasicConfigurationAvailable = false;
        }
        if (configuration.getMaprenderConfiguration().getJobs() == null) {
            this.log.warn("startRendering: you need to configure the 'jobs' element for rendering.");
            isBasicConfigurationAvailable = false;
        }
        if (!isBasicConfigurationAvailable) {
            this.log.warn("startRendering: Some mandatory configurations were not found. Skipping rendering.");
            return;
        }
        PerformanceMetrics performanceMetrics = new PerformanceMetrics(configuration.getMaprenderConfiguration().getProcessing().getThreads());
        this.totalDurationStopwatch = StopWatch.start(true);
        FontsLoader fontsLoader = new FontsLoader(configuration);
        fontsLoader.loadFonts();
        fontsLoader.checkForMissingFonts();
        SymbolsCache symbolsCache = new SymbolsCache(configuration);
        configuration.setSymbolsCache(symbolsCache);
        int threadCount = configuration.getMaprenderConfiguration().getProcessing().getThreads();
        PooledRenderDatasource datasource = new PooledRenderDatasource(configuration);
        datasource.connect(threadCount);
        boolean successfullConnection = datasource.inspectConnection(datasource.getConnection());
        boolean hasDBConfigured = false;
        if (configuration.getMaprenderConfiguration().getDatasources() != null && configuration.getMaprenderConfiguration().getDatasources().getDb() != null) {
            hasDBConfigured = true;
        }
        if (hasDBConfigured && !successfullConnection) {
            this.log.error("startRendering: a database connection was configured but no connection could be established:  " + configuration.getMaprenderConfiguration().getDatasources().getDb());
            return;
        }
        ConnectableResourceManager connectableResourceManager = new ConnectableResourceManager();
        connectableResourceManager.registerConnectableResources(configuration);
        try {
            connectableResourceManager.connectAllConnectableResources();
        }
        catch (Exception e) {
            this.log.error("startRendering: could not connect to all required resources: exiting.", (Throwable)e);
            return;
        }
        AbstractMapTileOutput tileOutputter = OutputFormatFactory.getInstance().getMapTileOutputter(configuration.getMaprenderConfiguration().getProcessing().getProjection());
        this.logScaleDenominators(tileOutputter);
        RenderRequestThreadManager renderThreadManager = new RenderRequestThreadManager(configuration, datasource, connectableResourceManager, performanceMetrics, this, this.progressMonitor);
        this.log.info("startRendering: finished preparations, continuing to compute the RenderRequests");
        this.computeRenderRequests(configuration, datasource, connectableResourceManager, renderThreadManager, performanceMetrics, this.progressMonitor, license, tileOutputter);
    }

    private void logMaprenderInfo() throws Exception {
        ManifestAccessor manifestAccessor = new ManifestAccessor();
        String version = manifestAccessor.getManifestEntry("Implementation-Version");
        String buildNumber = manifestAccessor.getManifestEntry("Implementation-Build");
        Date buildDate = manifestAccessor.getManifestEntryAsDate("Build-Time");
        this.log.info("logMaprenderInfo: version=" + version);
        this.log.info("logMaprenderInfo: buildNumber=" + buildNumber);
        this.log.info("logMaprenderInfo: buildDate=" + LicenseCheck.DDMMYYYY_Format.format(buildDate));
    }

    private LicenseContainer checkLicense(String licenseFileString) throws LicenseException {
        this.log.info("checkLicense: licenseFileString=" + licenseFileString);
        if (licenseFileString == null) {
            this.log.info("checkLicense: custom license file not found, looking for license file in the default locations");
            licenseFileString = "../license/license-signed.xml";
            File licenseFile = new File(licenseFileString);
            if (!licenseFile.exists() || licenseFile.isDirectory()) {
                this.log.warn("checkLicense: no license file found under: " + licenseFile.getAbsolutePath());
                licenseFileString = "license/license-signed.xml";
                licenseFile = new File(licenseFileString);
                if (!licenseFile.exists() || licenseFile.isDirectory()) {
                    this.log.warn("checkLicense: no license file found under: " + licenseFile.getAbsolutePath());
                }
            }
        }
        LicenseCheck licenseCheck = new LicenseCheck();
        LicenseContainer license = null;
        try {
            ManifestAccessor manifestAccessor = new ManifestAccessor();
            Date buildDate = manifestAccessor.getManifestEntryAsDate("Build-Time");
            license = licenseCheck.isLicenseValid(licenseFileString, buildDate);
        }
        catch (LicenseException le) {
            throw le;
        }
        catch (Exception e) {
            this.log.error("checkLicense: an exception occured while checking the license. ", (Throwable)e);
            throw new LicenseException("checkLicense: an exception occured while checking the license.");
        }
        return license;
    }

    public RenderRequestAllJobsProgress getProgressMonitor() {
        return this.progressMonitor;
    }

    public synchronized void allThreadsFinishedCallback(IRenderDatasource datasource, ConnectableResourceManager connectableResourceManager, PerformanceMetrics performanceMetrics) {
        if (this.allThreadsFinishedCallbackReceived) {
            return;
        }
        this.log.info("allThreadsFinishedCallback: all render threads have finished, starting cleanup and shutdown");
        this.totalDurationStopwatch.stop("total-duration", true);
        this.log.info("allThreadsFinishedCallback: total duration: " + this.totalDurationStopwatch);
        this.allThreadsFinishedCallbackReceived = true;
        performanceMetrics.mergeAllMetrics();
        performanceMetrics.logMetrics();
        connectableResourceManager.disconnectAllConnectableResources();
        datasource.disconnect();
        if (this.embeddedJettyServer != null) {
            this.embeddedJettyServer.stopServer();
        }
        this.log.info("allThreadsFinishedCallback: finished");
    }

    private long getTotalTilesCountOfJob(int zoomMin, int zoomMax, BoundingBox areaToRenderLatLon, AbstractMapTileOutput tileOutputter) {
        long renderRequestCount = 0L;
        for (int zoom = zoomMin; zoom <= zoomMax; ++zoom) {
            long zoomTileCount = this.getTotalTilesCountOfZoomLevel(zoom, areaToRenderLatLon, tileOutputter);
            renderRequestCount += zoomTileCount;
        }
        return renderRequestCount;
    }

    private long getTotalTilesDoneOfJob(int zoomMin, int zoomMax, BoundingBox areaToRenderLatLon, RenderProgressTracking renderProgressTracking, AbstractMapTileOutput tileOutputter) {
        long tilesDoneCount = 0L;
        for (int zoom = zoomMin; zoom <= zoomMax; ++zoom) {
            long zoomTileDoneCount = this.getTotalTilesDoneOfZoomLevel(zoom, areaToRenderLatLon, renderProgressTracking, tileOutputter);
            tilesDoneCount += zoomTileDoneCount;
        }
        return tilesDoneCount;
    }

    private long getTotalTilesCountOfZoomLevel(int zoom, BoundingBox areaToRenderLatLon, AbstractMapTileOutput tileOutputter) {
        BoundingBox minMaxTileIndexBoundingBox = tileOutputter.getMinMaxTileBoundingBox(areaToRenderLatLon, zoom);
        int tileIndexLeft = (int)minMaxTileIndexBoundingBox.getLeft();
        int tileIndexRight = (int)minMaxTileIndexBoundingBox.getRight();
        int tileIndexTop = (int)minMaxTileIndexBoundingBox.getTop();
        int tileIndexBottom = (int)minMaxTileIndexBoundingBox.getBottom();
        if (tileIndexRight < tileIndexLeft) {
            tileIndexRight = tileIndexLeft;
        }
        if (tileIndexBottom < tileIndexTop) {
            tileIndexBottom = tileIndexTop;
        }
        int xTileCount = tileIndexRight - tileIndexLeft + 1;
        int yTileCount = tileIndexBottom - tileIndexTop + 1;
        if (xTileCount == 0 && areaToRenderLatLon.getRight() > areaToRenderLatLon.getLeft()) {
            xTileCount = 1;
        }
        int totalTileCount = xTileCount * yTileCount;
        return totalTileCount;
    }

    private long getTotalTilesDoneOfZoomLevel(int zoom, BoundingBox areaToRenderLatLon, RenderProgressTracking renderProgressTracking, AbstractMapTileOutput tileOutputter) {
        if (renderProgressTracking.isTrackingConfigured()) {
            BoundingBox minMaxTileIndexBoundingBox = tileOutputter.getMinMaxTileBoundingBox(areaToRenderLatLon, zoom);
            int tileIndexLeft = (int)minMaxTileIndexBoundingBox.getLeft();
            int tileIndexRight = (int)minMaxTileIndexBoundingBox.getRight();
            int tileIndexTop = (int)minMaxTileIndexBoundingBox.getTop();
            int tileIndexBottom = (int)minMaxTileIndexBoundingBox.getBottom();
            if (tileIndexRight < tileIndexLeft) {
                tileIndexRight = tileIndexLeft;
            }
            if (tileIndexBottom < tileIndexTop) {
                tileIndexBottom = tileIndexTop;
            }
            return renderProgressTracking.getRenderedCount(zoom, tileIndexLeft, tileIndexRight, tileIndexTop, tileIndexBottom);
        }
        return 0L;
    }

    private boolean checkIfBoundingBoxOk(RenderConfiguration configuration) {
        BoundingBox areaToRenderLatLon = new BoundingBox(configuration.getMaprenderConfiguration().getBounds().getBoundingbox());
        boolean result = true;
        if (areaToRenderLatLon.getLeft() >= areaToRenderLatLon.getRight()) {
            this.log.error("precheckRenderRequests: boundingbox 'left' is bigger than 'right': " + areaToRenderLatLon.getLeft() + ">=" + areaToRenderLatLon.getRight());
            result = false;
        }
        if (areaToRenderLatLon.getTop() <= areaToRenderLatLon.getBottom()) {
            this.log.error("precheckRenderRequests: boundingbox 'top' is smaller than 'bottom': " + areaToRenderLatLon.getTop() + "<=" + areaToRenderLatLon.getBottom());
            result = false;
        }
        return result;
    }

    private long precheckRenderRequests(RenderConfiguration configuration, AbstractMapTileOutput tileOutputter) {
        int zoomMin = Integer.parseInt(configuration.getMaprenderConfiguration().getBounds().getMinzoom());
        int zoomMax = Integer.parseInt(configuration.getMaprenderConfiguration().getBounds().getMaxzoom());
        BoundingBox areaToRenderLatLon = new BoundingBox(configuration.getMaprenderConfiguration().getBounds().getBoundingbox());
        this.log.info("precheckRenderRequests: zoomMin=" + zoomMin + ", zoomMax=" + zoomMax + ", areaToRenderLatLon=" + areaToRenderLatLon);
        long renderRequestCount = this.getTotalTilesCountOfJob(zoomMin, zoomMax, areaToRenderLatLon, tileOutputter);
        int jobsCount = configuration.getMaprenderConfiguration().getJobs().getJobs().size();
        this.log.info("precheckRenderRequests: #" + (renderRequestCount *= (long)jobsCount) + " RenderRequests");
        return renderRequestCount;
    }

    private void computeRenderRequests(RenderConfiguration configuration, IRenderDatasource datasource, ConnectableResourceManager connectableResourceManager, RenderRequestThreadManager renderThreadManager, PerformanceMetrics performanceMetrics, RenderRequestAllJobsProgress progressMonitor, LicenseContainer license, AbstractMapTileOutput tileOutputter) {
        int jobIndex;
        this.log.info("computeRenderRequests: start computing RenderRequests");
        int zoomMin = Integer.parseInt(configuration.getMaprenderConfiguration().getBounds().getMinzoom());
        int zoomMax = Integer.parseInt(configuration.getMaprenderConfiguration().getBounds().getMaxzoom());
        BoundingBox areaToRenderLatLon = new BoundingBox(configuration.getMaprenderConfiguration().getBounds().getBoundingbox());
        PostgresCache postgresEhCache = (PostgresCache)connectableResourceManager.getConnectableResource(PostgresCache.class);
        boolean isBoundingBoxOk = this.checkIfBoundingBoxOk(configuration);
        if (!isBoundingBoxOk) {
            this.log.error("computeRenderRequests: invalid bounding box. Shutting down.");
            renderThreadManager.forceShutdown();
            return;
        }
        long totalRenderRequestCount = this.precheckRenderRequests(configuration, tileOutputter);
        long exitAfter = configuration.getMaprenderConfiguration().getProcessing().getExitafter();
        boolean isThreadCountAutoDetectionConfigured = configuration.getMaprenderConfiguration().getProcessing().getThreads() == 0;
        Optional licenseRestrictionMaxTiles = license.safeParseInteger(license.getOptionalLicenseEntry("tiles-max"));
        if (licenseRestrictionMaxTiles.isPresent()) {
            this.log.warn("computeRenderRequests: license restricts tile count to #" + licenseRestrictionMaxTiles.get() + " tiles.");
            exitAfter = ((Integer)licenseRestrictionMaxTiles.get()).intValue();
        }
        if (exitAfter > 0L && exitAfter < totalRenderRequestCount) {
            this.log.warn("computeRenderRequests: max render tiles restricted to #" + exitAfter + " tiles, either through configuration or license.");
            totalRenderRequestCount = exitAfter;
        }
        long renderRequestCount = 0L;
        List<RenderConfigurationJob> jobs = configuration.getMaprenderConfiguration().getJobs().getJobs();
        this.log.info("computeRenderRequests: start collecting data for progress monitor");
        long totalTilesCountOfJob = this.getTotalTilesCountOfJob(zoomMin, zoomMax, areaToRenderLatLon, tileOutputter);
        for (jobIndex = 0; jobIndex < jobs.size(); ++jobIndex) {
            String jobName = jobs.get(jobIndex).getName();
            boolean skipJob = jobs.get(jobIndex).isSkip();
            RenderProgressTracking renderProgressTracking = new RenderProgressTracking(configuration, jobs.get(jobIndex));
            if (renderProgressTracking.isTrackingConfigured()) {
                renderProgressTracking.startTracking();
            }
            long totalTilesDoneOfJob = this.getTotalTilesDoneOfJob(zoomMin, zoomMax, areaToRenderLatLon, renderProgressTracking, tileOutputter);
            RenderRequestJobProgress jobProgressMonitor = new RenderRequestJobProgress(jobName, skipJob, progressMonitor);
            jobProgressMonitor.setTilesCount(totalTilesCountOfJob);
            jobProgressMonitor.setTilesDone(totalTilesDoneOfJob);
            jobProgressMonitor.setTilesDoneAtStart(totalTilesDoneOfJob);
            this.log.info("computeRenderRequests: status job progress monitor: " + jobName + ", tiles already done:" + totalTilesDoneOfJob);
            for (int zoomLevel = zoomMin; zoomLevel <= zoomMax; ++zoomLevel) {
                long totalTilesCountOfZoomLevel = this.getTotalTilesCountOfZoomLevel(zoomLevel, areaToRenderLatLon, tileOutputter);
                long totalTilesDoneOfZoomLevel = this.getTotalTilesDoneOfZoomLevel(zoomLevel, areaToRenderLatLon, renderProgressTracking, tileOutputter);
                jobProgressMonitor.addZoomLevel(zoomLevel, totalTilesCountOfZoomLevel, totalTilesDoneOfZoomLevel);
            }
            progressMonitor.addJob(jobProgressMonitor);
            if (!renderProgressTracking.isTrackingConfigured()) continue;
            renderProgressTracking.stopTracking();
        }
        this.log.info("computeRenderRequests: finished collecting data for progress monitor");
        for (jobIndex = 0; jobIndex < jobs.size(); ++jobIndex) {
            RenderConfigurationJob job = jobs.get(jobIndex);
            if (job.isSkip()) {
                this.log.info("computeRenderRequests: skipping job flagged as skipable: " + job.getName());
                continue;
            }
            this.log.info("computeRenderRequests: starting job: " + job.getName());
            RenderProgressTracking renderProcessTracking = new RenderProgressTracking(configuration, job);
            if (renderProcessTracking.isTrackingConfigured()) {
                renderProcessTracking.startTracking();
            }
            RenderRequestJobProgress jobProgressMonitor = progressMonitor.getJobs().get(jobIndex);
            jobProgressMonitor.setRenderProgressTracking(renderProcessTracking);
            RenderOutputQueue renderOutputQueue = new RenderOutputQueue();
            renderOutputQueue.init(job.getOutput());
            OsmMap osmMap = job.getOsmMap();
            HeightTileAccessor heightTileAccessor = null;
            if (configuration.getMaprenderConfiguration().getDatasources() != null) {
                heightTileAccessor = new HeightTileAccessor(configuration.getMaprenderConfiguration().getDatasources());
            }
            KmlFileCache kmlFileCache = new KmlFileCache();
            block9: for (int zoom = zoomMin; zoom <= zoomMax; ++zoom) {
                boolean isZoomLevelRenderingRequired;
                if (this.hasZoomSpecificCaches(heightTileAccessor)) {
                    if (!this.isPreviousZoomCompleted(zoom, zoomMin, jobProgressMonitor)) {
                        --zoom;
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.purgeZoomSpecificCaches(heightTileAccessor);
                }
                long zoomLevelStartTimestamp = System.nanoTime();
                if (isThreadCountAutoDetectionConfigured) {
                    renderThreadManager.setMaxParallelThreadCount(1);
                }
                BoundingBox minMaxTileIndexBoundingBox = tileOutputter.getMinMaxTileBoundingBox(areaToRenderLatLon, zoom);
                int tileIndexLeft = (int)minMaxTileIndexBoundingBox.getLeft();
                int tileIndexRight = (int)minMaxTileIndexBoundingBox.getRight();
                int tileIndexTop = (int)minMaxTileIndexBoundingBox.getTop();
                int tileIndexBottom = (int)minMaxTileIndexBoundingBox.getBottom();
                if (tileIndexRight < tileIndexLeft) {
                    tileIndexRight = tileIndexLeft;
                }
                if (tileIndexBottom < tileIndexTop) {
                    tileIndexBottom = tileIndexTop;
                }
                int tilesToRenderPerRow = this.getTilesToRenderPerRow(configuration, job, areaToRenderLatLon, tileIndexLeft, tileIndexRight, zoom, tileOutputter);
                long zoomLevelRenderRequestNumber = 0L;
                int xTileCount = tileIndexRight - tileIndexLeft + 1;
                int yTileCount = tileIndexBottom - tileIndexTop + 1;
                if (xTileCount == 0 && areaToRenderLatLon.getRight() > areaToRenderLatLon.getLeft()) {
                    xTileCount = 1;
                }
                this.log.debug("computeRenderRequests: xTileCount=" + xTileCount);
                this.log.debug("computeRenderRequests: yTileCount=" + yTileCount);
                int totalTileCount = xTileCount * yTileCount;
                this.log.info("computeRenderRequests: zoom=" + zoom + ", totalTileCount=" + totalTileCount + ", tilesToRenderPerRow=" + tilesToRenderPerRow);
                if (renderProcessTracking.isTrackingConfigured() && !(isZoomLevelRenderingRequired = renderProcessTracking.isZoomLevelRenderingRequired(zoom, totalTileCount, tileIndexLeft, tileIndexRight, tileIndexTop, tileIndexBottom))) {
                    this.log.info("computeRenderRequests: zoom level already rendered: zoom=" + zoom);
                    continue;
                }
                RenderRequestZoomInfo zoomInfo = new RenderRequestZoomInfo(zoomMin, zoomMax, zoom);
                for (int block = tileIndexLeft; block <= tileIndexRight; block += tilesToRenderPerRow) {
                    for (int y = tileIndexTop; y <= tileIndexBottom; ++y) {
                        for (int x = block; x < block + tilesToRenderPerRow; ++x) {
                            if (this.allThreadsFinishedCallbackReceived) {
                                this.log.info("computeRenderRequests: already received the allThreadsFinishedCallback so skipping the x loop");
                                break;
                            }
                            if (x >= tileIndexLeft && x <= tileIndexRight && y >= tileIndexTop && y <= tileIndexBottom) {
                                BoundingBox latLonTile = tileOutputter.getBoundingBoxForTile(zoom, x, y);
                                if (latLonTile == null) {
                                    this.log.info("computeRenderRequests: no valid boundingbox found: tile x=" + x + ", y=" + y);
                                    if (renderProcessTracking.isTrackingConfigured()) {
                                        boolean isTileRenderingRequired = true;
                                        try {
                                            isTileRenderingRequired = renderProcessTracking.isTileRenderingRequired(x, y, zoom);
                                        }
                                        catch (Exception e) {
                                            this.log.error("computeRenderRequests: call to isTileRenderingRequired threw unexpected exception", (Throwable)e);
                                        }
                                        if (isTileRenderingRequired) {
                                            renderProcessTracking.trackRenderRequestComplete(x, y, zoom);
                                        }
                                    }
                                    ++renderRequestCount;
                                    ++zoomLevelRenderRequestNumber;
                                    jobProgressMonitor.addTileDone(zoom);
                                    renderThreadManager.notifiyThreadFinished(-1.0, zoom, -1L);
                                    continue;
                                }
                                this.log.debug("computeRenderRequests: tile x=" + x + ", y=" + y + ", bbox=" + latLonTile);
                                Point tileIndex = new Point(x, y);
                                double scaleDenominator = tileOutputter.getScaleDenominator(zoom, 45.0);
                                ++renderRequestCount;
                                ++zoomLevelRenderRequestNumber;
                                if (renderProcessTracking.isTrackingConfigured()) {
                                    boolean isTileRenderingRequired = true;
                                    try {
                                        isTileRenderingRequired = renderProcessTracking.isTileRenderingRequired(x, y, zoom);
                                    }
                                    catch (Exception e) {
                                        this.log.error("computeRenderRequests: call to isTileRenderingRequired threw unexpected exception", (Throwable)e);
                                    }
                                    if (!isTileRenderingRequired) {
                                        this.log.debug("computeRenderRequests: tile already rendered: x=" + x + ", y=" + y + ", zoom=" + zoom);
                                        continue;
                                    }
                                }
                                if (exitAfter > 0L && renderRequestCount > totalRenderRequestCount) {
                                    this.log.warn("computeRenderRequests: reached the configured maximum tiles count: " + exitAfter + ". Exiting now.");
                                    renderThreadManager.forceShutdown();
                                    return;
                                }
                                RenderRequest renderRequest = new RenderRequest(osmMap.getAccessor(), zoomInfo, latLonTile, scaleDenominator, tileIndex, configuration, renderRequestCount, totalRenderRequestCount, zoomLevelRenderRequestNumber, zoomLevelStartTimestamp, totalTileCount, heightTileAccessor, performanceMetrics, datasource, kmlFileCache, connectableResourceManager, jobProgressMonitor, renderOutputQueue, tileOutputter, license, renderProcessTracking, postgresEhCache);
                                renderThreadManager.addRenderRequestToQueue(renderRequest);
                                continue;
                            }
                            this.log.debug("computeRenderRequests: tile out of osm map bbox: tile x=" + x + ", y=" + y + ", bbox=" + areaToRenderLatLon);
                        }
                        if (!this.allThreadsFinishedCallbackReceived) continue;
                        this.log.debug("computeRenderRequests: already received the allThreadsFinishedCallback so skipping the y loop");
                        break;
                    }
                    if (!this.allThreadsFinishedCallbackReceived) continue;
                    this.log.debug("computeRenderRequests: already received the allThreadsFinishedCallback so skipping the block loop");
                    continue block9;
                }
            }
            this.log.info("computeRenderRequests: finished job: " + job.getName());
        }
        this.log.info("computeRenderRequests: put all #" + renderRequestCount + " RenderRequests into thread queue");
    }

    private boolean hasZoomSpecificCaches(HeightTileAccessor heightTileAccessor) {
        return heightTileAccessor != null && heightTileAccessor.isAvailable() && heightTileAccessor.getTileCache().getTiles().size() > 0;
    }

    private void purgeZoomSpecificCaches(HeightTileAccessor heightTileAccessor) {
        if (heightTileAccessor != null && heightTileAccessor.isAvailable()) {
            heightTileAccessor.getTileCache().purgeZoomSpecificCaches();
        }
    }

    private boolean isPreviousZoomCompleted(int zoom, int zoomMin, RenderRequestJobProgress jobProgressMonitor) {
        if (zoom == zoomMin) {
            return true;
        }
        RenderRequestZoomLevelProgress lastZoomProgressMonitor = jobProgressMonitor.getZoomLevelProgress(zoom - 1);
        if (lastZoomProgressMonitor.isDone()) {
            this.log.info("isPreviousZoomCompleted(): zoom level " + (zoom - 1) + " done: " + lastZoomProgressMonitor.getTilesDone() + " done + " + lastZoomProgressMonitor.getTilesFailed() + " failed == " + lastZoomProgressMonitor.getTilesCount() + " total. Continuing with zoom level " + zoom);
            return true;
        }
        this.log.info("isPreviousZoomCompleted(): zoom level " + (zoom - 1) + " not done yet: " + lastZoomProgressMonitor.getTilesDone() + " done + " + lastZoomProgressMonitor.getTilesFailed() + " failed < " + lastZoomProgressMonitor.getTilesCount() + " total. Waiting with start of zoom level " + zoom);
        return false;
    }

    public void analyzeConfiguration(RenderConfiguration configuration, IRenderDatasource datasource) {
        this.log.info("analyzeConfiguration");
        for (RenderConfigurationJob job : configuration.getMaprenderConfiguration().getJobs().getJobs()) {
            OsmMap osmMap = job.getOsmMap();
            for (OsmLayer rawLayer : osmMap.getLayers()) {
                OsmLayerAccessor layer = rawLayer.getAccessor();
                Optional<OsmDatasource> optionalDatasource = layer.getDatasource();
                if (!optionalDatasource.isPresent()) {
                    this.log.error("analyzeConfiguration: layer has no datasource: " + layer.getName());
                    continue;
                }
                Optional<OsmParameter> tableParameter = optionalDatasource.get().findParameter("table");
                Optional<OsmParameter> geometryFieldParameter = optionalDatasource.get().findParameter("geometry_field");
                if (!tableParameter.isPresent() || !geometryFieldParameter.isPresent()) continue;
                String query = tableParameter.get().getValue();
                String geometryField = geometryFieldParameter.get().getValue();
                String capsulatedQuery = "SELECT ST_AsText(" + geometryField + ") " + geometryField + " FROM " + query + ";";
                if (!datasource.getConnection().isPresent()) continue;
                Connection connection = datasource.getConnection().get();
                try {
                    Statement statement = connection.createStatement();
                    statement.setMaxRows(1);
                    ResultSet resultSet = statement.executeQuery(capsulatedQuery);
                    while (resultSet.next()) {
                        this.log.info(resultSet.getString(geometryField));
                    }
                    resultSet.close();
                    statement.close();
                }
                catch (SQLException e) {
                    this.log.error("analyzeConfiguration: Error during executing query: " + capsulatedQuery, (Throwable)e);
                }
            }
        }
    }

    private void logScaleDenominators(AbstractMapTileOutput tileOutputter) {
        for (int m = 1; m < 20; ++m) {
            double scaleDenominator = tileOutputter.getScaleDenominator(m, 45.0);
            double meterPerPixel = tileOutputter.getMeterPerPixel(m, 45.0);
            double wayPixels1 = Math.pow(scaleDenominator * 0.001 * 0.28, 2.0);
            double wayPixels2 = Math.pow(meterPerPixel, 2.0);
            this.log.info("logScaleDenominators: zoom=" + m + "  ->  " + (int)scaleDenominator + "  ->  wayPixels1=" + (int)wayPixels1 + " / wayPixels2=" + wayPixels2);
        }
    }

    private int getTilesToRenderPerRow(RenderConfiguration renderConfiguration, RenderConfigurationJob job, BoundingBox areaToRenderLatLon, int tileIndexLeft, int tileIndexRight, int zoom, AbstractMapTileOutput tileOutputter) {
        int tilesToRenderPerRow = 1;
        int cacheSize = 0;
        if (renderConfiguration.getMaprenderConfiguration().getDatasources().getSrtm() != null && renderConfiguration.getMaprenderConfiguration().getDatasources().getSrtm().getCache() != null) {
            cacheSize = renderConfiguration.getMaprenderConfiguration().getDatasources().getSrtm().getCache();
        } else if (renderConfiguration.getMaprenderConfiguration().getDatasources().getJaxa() != null && renderConfiguration.getMaprenderConfiguration().getDatasources().getJaxa().getCache() != null) {
            cacheSize = renderConfiguration.getMaprenderConfiguration().getDatasources().getJaxa().getCache();
        }
        if (cacheSize > 0) {
            int desiredLonDegreePerSingleRenderRow = (int)Math.floor(Math.sqrt(cacheSize) - 2.0);
            if (desiredLonDegreePerSingleRenderRow < 1) {
                desiredLonDegreePerSingleRenderRow = 1;
            }
            double lonWidth = areaToRenderLatLon.getRight() - areaToRenderLatLon.getLeft();
            double tileWidth = tileIndexRight - tileIndexLeft;
            tileWidth = Math.max(tileWidth, 1.0);
            double lonPerTile = lonWidth / tileWidth;
            tilesToRenderPerRow = (int)Math.ceil((double)desiredLonDegreePerSingleRenderRow / lonPerTile);
        }
        int maxMapOverCaching = this.getMaxMapOverCaching(job, zoom, tileOutputter);
        if (tilesToRenderPerRow == 1 && maxMapOverCaching > 0) {
            tilesToRenderPerRow = maxMapOverCaching;
        }
        return tilesToRenderPerRow;
    }

    public void checkWatermark(String watermarkFile) {
        this.log.info("checkWatermark: checking file for watermark: " + watermarkFile);
        LicenseWatermarkFilter watermarkFilter = new LicenseWatermarkFilter(null);
        FileLoader fileLoader = new FileLoader();
        Optional<BufferedImage> optionalTileImage = fileLoader.loadOsmTile(watermarkFile);
        if (optionalTileImage.isPresent()) {
            watermarkFilter.checkWatermark(optionalTileImage.get());
        } else {
            this.log.warn("checkWatermark: watermark file not accessible.");
        }
    }

    public int getMaxMapOverCaching(RenderConfigurationJob job, int zoom, AbstractMapTileOutput tileOutputter) {
        OsmMap osmMap = job.getOsmMap();
        int overCaching = 0;
        double scaleDenominator = tileOutputter.getScaleDenominator(zoom, 45.0);
        for (OsmLayer layer : osmMap.getLayers()) {
            Optional<Double> optionalMinScaleDenominator;
            Optional<Integer> optionalOverCaching = layer.getAccessor().getOverCaching();
            if (!optionalOverCaching.isPresent()) continue;
            Double maxScaleDenominator = Double.MAX_VALUE;
            Double minScaleDenominator = 0.0;
            Optional<Double> optionalMaxScaleDenominator = layer.getAccessor().getMaximumScaleDenominator();
            if (optionalMaxScaleDenominator.isPresent()) {
                maxScaleDenominator = optionalMaxScaleDenominator.get();
            }
            if ((optionalMinScaleDenominator = layer.getAccessor().getMinimumScaleDenominator()).isPresent()) {
                minScaleDenominator = optionalMinScaleDenominator.get();
            }
            if (!(scaleDenominator >= minScaleDenominator) || !(scaleDenominator <= maxScaleDenominator)) continue;
            Integer layerOverCaching = optionalOverCaching.get();
            overCaching = Math.max(overCaching, layerOverCaching);
        }
        return overCaching;
    }
}

