/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import de.wideportal.maprender.config.xml.osm.accessor.OsmMapAccessor;
import de.wideportal.maprender.request.RenderImageLayer;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.ArrayList;

public class RenderImage
implements ImageObserver {
    private RenderImageLayer baseLayer;
    private ArrayList<RenderImageLayer> layers = new ArrayList();

    public RenderImage(OsmMapAccessor osmMap, long tileSize) {
        this.initRenderImage(osmMap, tileSize);
    }

    private void initRenderImage(OsmMapAccessor osmMap, long tileSize) {
        this.baseLayer = new RenderImageLayer(osmMap.getBackgroundColor(), "LAYER_BASE", (int)tileSize);
        this.layers.add(this.baseLayer);
    }

    public void mergeLayers() {
        int i;
        for (i = 1; i < this.layers.size(); ++i) {
            RenderImageLayer layer = this.layers.get(i);
            this.mergeToLayer(layer, this.baseLayer);
        }
        for (i = this.layers.size() - 1; i >= 1; --i) {
            this.layers.remove(i);
        }
    }

    public void mergeToLayer(RenderImageLayer layerToMerge, RenderImageLayer mergeTo) {
        layerToMerge.getImage().flush();
        if (layerToMerge.getName().equals("LAYER_OPACITY")) {
            Composite oldComposite = mergeTo.getCanvas().getComposite();
            AlphaComposite renderOpacity = AlphaComposite.getInstance(3, layerToMerge.getOpacity());
            mergeTo.getCanvas().setComposite(renderOpacity);
            mergeTo.getCanvas().drawImage((Image)layerToMerge.getImage(), 0, 0, this);
            mergeTo.getCanvas().setComposite(oldComposite);
            this.layers.remove(layerToMerge);
        } else {
            mergeTo.getCanvas().drawImage((Image)layerToMerge.getImage(), 0, 0, this);
            this.layers.remove(layerToMerge);
        }
    }

    public void mergeToLayer(RenderImageLayer layerToMerge, RenderImageLayer mergeTo, int borderToRemove) {
        layerToMerge.getImage().flush();
        mergeTo.getCanvas().drawImage((Image)layerToMerge.getImage(), -borderToRemove, -borderToRemove, this);
        this.layers.remove(layerToMerge);
    }

    public ArrayList<RenderImageLayer> getLayers() {
        return this.layers;
    }

    public RenderImageLayer getLayer(String name) {
        for (RenderImageLayer layer : this.layers) {
            if (!layer.getName().equalsIgnoreCase(name)) continue;
            return layer;
        }
        return null;
    }

    public RenderImageLayer createLayer(String name, long tileSize) {
        RenderImageLayer newLayer = new RenderImageLayer(name, (int)tileSize);
        this.layers.add(newLayer);
        return newLayer;
    }

    public void addLayer(RenderImageLayer newLayer) {
        this.layers.add(newLayer);
    }

    public void mergeBackLayer(RenderImageLayer layer) {
        this.mergeBackLayer(layer.getName());
    }

    public void mergeBackLayer(String name) {
        for (int i = 1; i < this.layers.size(); ++i) {
            RenderImageLayer layer = this.layers.get(i);
            if (!layer.getName().equals(name)) continue;
            RenderImageLayer bottomLayer = this.layers.get(i - 1);
            this.mergeToLayer(layer, bottomLayer);
            return;
        }
    }

    public void discardLayer(RenderImageLayer layer) {
        this.discardLayer(layer.getName());
    }

    public void discardLayer(String name) {
        for (int i = 1; i < this.layers.size(); ++i) {
            RenderImageLayer layer = this.layers.get(i);
            if (!layer.getName().equals(name)) continue;
            layer.cleanup();
            this.layers.remove(i);
            return;
        }
    }

    public RenderImageLayer getBaseLayer() {
        return this.baseLayer;
    }

    public void cleanup() {
        for (RenderImageLayer layer : this.layers) {
            layer.cleanup();
        }
        this.layers.clear();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }
}

