/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.text;

import de.wideportal.maprender.config.xml.osm.accessor.IOsmTextAccessor;
import de.wideportal.maprender.renderer.text.TextRow;
import de.wideportal.maprender.renderer.text.TextRowEntry;
import de.wideportal.maprender.resources.fonts.FontContext;
import java.awt.Graphics;
import java.util.ArrayList;

public class TextRowContainer {
    public static final String HARD_BREAK_CR1 = "\n";
    public static final String HARD_BREAK_CR2 = "\\n";
    public static final String FORMAT_ITALIC = "<i>";
    public static final String FORMAT_BOLD = "<b>";
    public static final String FORMAT_PLAIN = "<p>";
    private ArrayList<TextRow> textRows = new ArrayList();

    private TextRowContainer() {
    }

    public static TextRowContainer createDummy(String text) {
        TextRowContainer result = new TextRowContainer();
        TextRow textRow = new TextRow(0, " ", text);
        textRow.parse();
        result.textRows.add(textRow);
        return result;
    }

    public static TextRowContainer parse(String text, IOsmTextAccessor genericTextAccessor, FontContext fontContext, Graphics dummyCanvas, int minimumLineLength) {
        TextRow textRow;
        int i;
        String textBlock;
        TextRowContainer result = new TextRowContainer();
        if (text == null || text.trim().isEmpty()) {
            return result;
        }
        text = text.trim();
        double wrapWidth = genericTextAccessor.getWrapWidth();
        String wrapCharacter = genericTextAccessor.getWrapCharacter();
        ArrayList<String> hardBreakCharacters = new ArrayList<String>();
        hardBreakCharacters.add(HARD_BREAK_CR1);
        hardBreakCharacters.add(HARD_BREAK_CR2);
        ArrayList<TextRow> newTextRows = new ArrayList<TextRow>();
        int indexStartBlock = 0;
        int indexEndBlock = 0;
        while (true) {
            int smallestIndexOfBreakerFound = Integer.MAX_VALUE;
            String breakerUsed = "";
            for (String breaker : hardBreakCharacters) {
                int index = text.indexOf(breaker, indexEndBlock);
                if (index <= -1 || index >= smallestIndexOfBreakerFound) continue;
                smallestIndexOfBreakerFound = index;
                breakerUsed = breaker;
            }
            if (smallestIndexOfBreakerFound >= Integer.MAX_VALUE) break;
            indexStartBlock = smallestIndexOfBreakerFound;
            textBlock = text.substring(indexEndBlock, indexStartBlock);
            newTextRows.add(new TextRow(0, wrapCharacter, textBlock));
            indexEndBlock = indexStartBlock + breakerUsed.length();
        }
        textBlock = text.substring(indexEndBlock);
        newTextRows.add(new TextRow(0, wrapCharacter, textBlock));
        for (i = 0; i < newTextRows.size(); ++i) {
            ((TextRow)newTextRows.get(i)).parse();
            ((TextRow)newTextRows.get(i)).calculateStringDimension(fontContext, dummyCanvas);
        }
        if (wrapWidth > 0.0) {
            for (i = 0; i < newTextRows.size(); ++i) {
                textRow = (TextRow)newTextRows.get(i);
                double rowWidth = textRow.getStringWidth();
                if (!(rowWidth > wrapWidth)) continue;
                ArrayList<TextRow> splitRows = textRow.breakRowAfterLength((int)wrapWidth, fontContext, dummyCanvas);
                newTextRows.remove(i);
                newTextRows.addAll(i, splitRows);
                i += splitRows.size() - 1;
            }
        }
        for (i = 0; i < newTextRows.size(); ++i) {
            textRow = (TextRow)newTextRows.get(i);
            int rowWidth = textRow.getParsedText().trim().length();
            if (rowWidth >= minimumLineLength) continue;
            int previousRowLength = Integer.MAX_VALUE;
            int nextRowLength = Integer.MAX_VALUE;
            if (i >= 1) {
                previousRowLength = ((TextRow)newTextRows.get(i - 1)).getParsedText().trim().length();
            }
            if (i <= newTextRows.size() - 2) {
                nextRowLength = ((TextRow)newTextRows.get(i + 1)).getParsedText().trim().length();
            }
            if (previousRowLength <= nextRowLength) {
                if (i <= 0) continue;
                ((TextRow)newTextRows.get(i - 1)).add(textRow);
                newTextRows.remove(i);
                --i;
                continue;
            }
            if (i >= newTextRows.size() - 1) continue;
            textRow.add((TextRow)newTextRows.get(i + 1));
            newTextRows.remove(i + 1);
        }
        for (i = 0; i < newTextRows.size(); ++i) {
            textRow = (TextRow)newTextRows.get(i);
            textRow.calculateStringDimension(fontContext, dummyCanvas);
        }
        result.textRows = newTextRows;
        return result;
    }

    public void mergeToSingleLine(FontContext fontContext, Graphics dummyCanvas) {
        if (this.textRows.size() > 0) {
            String wrapCharacter = this.textRows.get(0).getWrapCharacter();
            String fullText = this.getFullText();
            ArrayList<TextRowEntry> textRowEntries = new ArrayList<TextRowEntry>();
            for (int i = 0; i < this.textRows.size(); ++i) {
                TextRow textRow = this.textRows.get(i);
                textRowEntries.addAll(textRow.getTextRowEntries());
                if (i >= this.textRows.size() - 1) continue;
                textRowEntries.add(new TextRowEntry(0, wrapCharacter));
            }
            TextRow newTextRow = new TextRow(0, wrapCharacter, fullText);
            newTextRow.setTextRowEntries(textRowEntries);
            newTextRow.calculateStringDimension(fontContext, dummyCanvas);
            this.textRows.clear();
            this.textRows.add(newTextRow);
        }
    }

    public int getMaxRowWidth() {
        int maxRowLength = 0;
        for (TextRow textRow : this.textRows) {
            maxRowLength = Math.max(maxRowLength, textRow.getStringWidth());
        }
        return maxRowLength;
    }

    public String getFullText() {
        Object fullText = "";
        if (this.textRows.size() > 0) {
            fullText = this.textRows.get(0).getFullText();
            for (int i = 1; i < this.textRows.size(); ++i) {
                TextRow textRow = this.textRows.get(i);
                fullText = (String)fullText + textRow.getWrapCharacter() + textRow.getFullText();
            }
        }
        return fullText;
    }

    public String getParsedText() {
        Object parsedText = "";
        if (this.textRows.size() > 0) {
            parsedText = this.textRows.get(0).getParsedText();
            for (int i = 1; i < this.textRows.size(); ++i) {
                TextRow textRow = this.textRows.get(i);
                parsedText = (String)parsedText + " " + textRow.getParsedText();
            }
        }
        return ((String)parsedText).trim();
    }

    public ArrayList<TextRow> getTextRows() {
        return this.textRows;
    }

    public String toString() {
        return "TextRowContainer[textRows=" + this.textRows + "]";
    }
}

