/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.progress;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.renderer.progress.RenderProgressTrackingSqLiteAccessor;
import de.wideportal.maprender.renderer.progress.RenderProgressTrackingSqLiteConnector;
import de.wideportal.maprender.request.RenderRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderProgressTracking {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    RenderProgressTrackingSqLiteConnector connector;
    RenderProgressTrackingSqLiteAccessor accessor;
    RenderConfigurationJob job;
    boolean isTrackingConfigured = false;
    boolean isTrackingConnectionAvailable = false;

    public RenderProgressTracking(RenderConfiguration renderConfiguration, RenderConfigurationJob job) {
        this.connector = new RenderProgressTrackingSqLiteConnector(renderConfiguration, job);
        this.isTrackingConfigured = this.connector.getFile() != null;
        this.job = job;
    }

    public boolean isTrackingConfigured() {
        return this.isTrackingConfigured;
    }

    public boolean isTrackingConnectionAvailable() {
        return this.isTrackingConnectionAvailable;
    }

    public void startTracking() {
        try {
            this.connector.connect();
            this.accessor = new RenderProgressTrackingSqLiteAccessor(this.connector);
            this.accessor.initTablesIfNecessary();
            this.isTrackingConnectionAvailable = true;
        }
        catch (Exception e) {
            this.log.error("startTracking: could not establish tracking db connection. Tracking will not be available. ", (Throwable)e);
        }
    }

    public void stopTracking() {
        this.isTrackingConnectionAvailable = false;
        this.connector.disconnect();
    }

    public void trackRenderRequestCompleted(RenderRequest renderRequest) {
        if (!this.isTrackingConnectionAvailable) {
            return;
        }
        if (this.accessor != null) {
            this.accessor.setRendered((int)renderRequest.getTileIndex().getX(), (int)renderRequest.getTileIndex().getY(), (int)renderRequest.getZoomInfo().getZoom(), true);
        }
    }

    public void trackRenderRequestComplete(int x, int y, int zoom) {
        if (!this.isTrackingConnectionAvailable) {
            return;
        }
        if (this.accessor != null) {
            this.accessor.setRendered(x, y, zoom, true);
        }
    }

    public void trackRenderRequestIncomplete(int x, int y, int zoom) {
        if (!this.isTrackingConnectionAvailable) {
            return;
        }
        if (this.accessor != null) {
            this.accessor.setRendered(x, y, zoom, false);
        }
    }

    public boolean isTileRenderingRequired(double x, double y, double zoom) {
        if (!this.isTrackingConnectionAvailable) {
            return true;
        }
        if (this.job.isSkip()) {
            return false;
        }
        if (this.accessor != null) {
            return !this.accessor.isRendered((int)x, (int)y, (int)zoom);
        }
        return false;
    }

    public boolean isZoomLevelRenderingRequired(double zoom, int expectedCount, int tileIndexLeft, int tileIndexRight, int tileIndexTop, int tileIndexBottom) {
        if (!this.isTrackingConnectionAvailable) {
            return true;
        }
        if (this.job.isSkip()) {
            return false;
        }
        if (this.accessor != null) {
            return !this.accessor.isRendered((int)zoom, expectedCount, tileIndexLeft, tileIndexRight, tileIndexTop, tileIndexBottom);
        }
        return false;
    }

    public long getRenderedCount(int zoom, int tileIndexLeft, int tileIndexRight, int tileIndexTop, int tileIndexBottom) {
        if (!this.isTrackingConnectionAvailable) {
            return 0L;
        }
        if (this.accessor != null) {
            return this.accessor.getRenderedCount(zoom, tileIndexLeft, tileIndexRight, tileIndexTop, tileIndexBottom);
        }
        return 0L;
    }
}

